/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.util.Arrays;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.MethodInfoInternal;
import org.jboss.reflect.plugins.bytecode.BytecodeAccessController;
import org.jboss.reflect.plugins.bytecode.BytecodeBehaviourInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeVariableSpy;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.accessor.MemberAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class BytecodeMethodInfo
extends BytecodeBehaviourInfo
implements MethodInfo,
MethodInfoInternal {
    private static final long serialVersionUID = 101183748227690112L;
    private volatile transient MethodAccessor method;
    private volatile transient TypeInfo returnType;

    public BytecodeMethodInfo(AnnotationHelper annotationHelper, BytecodeTypeInfo typeInfo, MethodBytes method) {
        super(annotationHelper, typeInfo, method);
    }

    public String getName() {
        return this.behaviour.getName();
    }

    public int getNumberParameters() {
        return this.getSignatureKey().getParams().length;
    }

    public TypeInfo getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        SignatureAttribute.MethodSignature sig = this.getMethodSignature();
        boolean doneReturn = false;
        if (sig != null && !(sig.getReturnType() instanceof SignatureAttribute.BaseType)) {
            this.returnType = this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), sig.getReturnType(), BytecodeTypeVariableSpy.createForBehavior(this.getDeclaringClass().getClassSignature(), sig));
            doneReturn = true;
        }
        if (!doneReturn) {
            String name = SignatureKey.getReturnType(this.behaviour);
            try {
                this.returnType = this.typeInfo.getFactory().getTypeInfo(name, this.typeInfo.getClassLoaderInternal());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.returnType;
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            MethodAccessor m = MemberAccessorFactory.INSTANCE.createMethod(this);
            if (this.method == null) {
                this.method = m;
            }
        }
        BytecodeAccessController.checkAccess(this);
        return this.method.invoke(target, args);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (other instanceof BytecodeMethodInfo) {
            return this.getSignatureKey().equals(((BytecodeMethodInfo)other).getSignatureKey());
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }
}

