/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.TypeVariableAware;
import org.jboss.reflect.plugins.javassist.JavassistClassInfo;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.DelegateClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistParameterizedClassInfo
extends DelegateClassInfo
implements TypeVariableAware,
JavassistClassInfo {
    private static final long serialVersionUID = 2L;
    private final JavassistTypeInfoFactoryImpl factory;
    private volatile TypeInfo[] typeArgumentInfos = ClassInfoImpl.UNKNOWN_TYPES;
    private final LazyTypeArgumentFactory lazyTypeArgumentFactory;
    private volatile String typeVariable;

    public JavassistParameterizedClassInfo(JavassistTypeInfoFactoryImpl factory, ClassInfo delegate, ClassLoader classLoader, SignatureAttribute.TypeArgument[] typeArguments, JavassistTypeVariableSpy spy) {
        this(factory, delegate, classLoader, typeArguments, spy, null);
    }

    public JavassistParameterizedClassInfo(JavassistTypeInfoFactoryImpl factory, ClassInfo delegate, Type[] reflectTypeArguments) {
        this(factory, delegate, null, null, null, reflectTypeArguments);
    }

    private JavassistParameterizedClassInfo(JavassistTypeInfoFactoryImpl factory, ClassInfo delegate, ClassLoader classLoader, SignatureAttribute.TypeArgument[] typeArguments, JavassistTypeVariableSpy spy, Type[] reflectTypeArguments) {
        super(delegate);
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        this.factory = factory;
        this.lazyTypeArgumentFactory = reflectTypeArguments != null ? new FromReflectTypeArgumentFactory(reflectTypeArguments) : new FromClassFileTypeArgumentFactory(typeArguments, spy, classLoader);
    }

    @Override
    public void setTypeVariable(String typeVariable) {
        this.typeVariable = typeVariable;
    }

    @Override
    public String getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return this.factory;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.lazyTypeArgumentFactory.getClassLoader();
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        if (this.typeArgumentInfos == ClassInfoImpl.UNKNOWN_TYPES) {
            this.typeArgumentInfos = this.lazyTypeArgumentFactory.createTypeInfos();
        }
        return this.typeArgumentInfos;
    }

    @Override
    public TypeInfo getComponentType() {
        return this.findTypeInfo(JavassistTypeInfo.COLLECTION, 0, CollectionTypeChecker.INSTANCE);
    }

    @Override
    public TypeInfo getKeyType() {
        return this.findTypeInfo(JavassistTypeInfo.MAP, 0, MapTypeChecker.INSTANCE);
    }

    @Override
    public TypeInfo getValueType() {
        return this.findTypeInfo(JavassistTypeInfo.MAP, 1, MapTypeChecker.INSTANCE);
    }

    private TypeInfo findTypeInfo(ClassInfo target, int parameter, TypeChecker checker) {
        SignatureAttribute.ClassSignature sig = this.getClassSignature();
        if (sig == null) {
            return this.delegate.getComponentType();
        }
        if (!checker.check(this)) {
            return null;
        }
        try {
            return JavassistHelper.determineInfoIndex(this.getActualTypeArguments(), this, target, parameter);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        this.appendTypeGenericInfo(this, buffer, null);
    }

    private void appendTypeGenericInfo(TypeInfo info, JBossStringBuilder buffer, Set<String> doneTypeVariables) {
        boolean first = true;
        ClassInfo cinfo = null;
        if (info instanceof ClassInfo && (cinfo = (ClassInfo)info).getTypeVariable() != null) {
            if (doneTypeVariables == null) {
                doneTypeVariables = new HashSet<String>();
            } else if (doneTypeVariables.contains(cinfo.getTypeVariable())) {
                return;
            }
            doneTypeVariables.add(cinfo.getTypeVariable());
        }
        buffer.append(info.getName());
        if (cinfo != null && cinfo.getActualTypeArguments().length > 0) {
            JBossStringBuilder params = new JBossStringBuilder();
            params.append("<");
            for (TypeInfo arg : cinfo.getActualTypeArguments()) {
                if (!first) {
                    params.append(", ");
                } else {
                    first = false;
                }
                this.appendTypeGenericInfo(arg, params, doneTypeVariables);
            }
            if (params.length() > 0) {
                params.append(">");
                buffer.append(params.toString());
            }
        }
    }

    @Override
    protected void toString(JBossStringBuilder buffer) {
        this.toShortString(buffer);
    }

    @Override
    public SignatureAttribute.ClassSignature getClassSignature() {
        return ((JavassistTypeInfo)this.delegate).getClassSignature();
    }

    @Override
    public ClassLoader getClassLoaderInternal() {
        return ((JavassistClassInfo)this.delegate).getClassLoaderInternal();
    }

    @Override
    public JavassistTypeInfoFactoryImpl getFactory() {
        return this.factory;
    }

    static /* synthetic */ TypeInfo[] access$302(JavassistParameterizedClassInfo x0, TypeInfo[] x1) {
        x0.typeArgumentInfos = x1;
        return x1;
    }

    private class FromClassFileTypeArgumentFactory
    implements LazyTypeArgumentFactory {
        private final SignatureAttribute.TypeArgument[] typeArguments;
        private final JavassistTypeVariableSpy spy;
        private final ClassLoader classLoader;

        public FromClassFileTypeArgumentFactory(SignatureAttribute.TypeArgument[] typeArguments, JavassistTypeVariableSpy spy, ClassLoader classLoader) {
            this.typeArguments = typeArguments;
            this.spy = spy;
            this.classLoader = classLoader;
        }

        public TypeInfo[] createTypeInfos() {
            if (this.typeArguments != null && this.typeArguments.length > 0) {
                if (!(JavassistParameterizedClassInfo.this.delegate instanceof JavassistTypeInfo)) {
                    throw new IllegalStateException("Delegate is not a javassist one");
                }
                TypeInfo[] infos = new TypeInfo[this.typeArguments.length];
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    infos[i] = JavassistParameterizedClassInfo.this.factory.createTypeInfoForTypeArgument(this.typeArguments[i], this.classLoader, this.spy);
                }
                JavassistParameterizedClassInfo.access$302(JavassistParameterizedClassInfo.this, infos);
            }
            return JavassistParameterizedClassInfo.this.typeArgumentInfos;
        }

        public ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(JavassistTypeInfo.GET_CLASSLOADER_PERMISSION);
            }
            return this.classLoader;
        }
    }

    private class FromReflectTypeArgumentFactory
    implements LazyTypeArgumentFactory {
        private final Type[] typeArguments;

        FromReflectTypeArgumentFactory(Type[] typeArguments) {
            this.typeArguments = typeArguments;
        }

        public TypeInfo[] createTypeInfos() {
            TypeInfo[] infos = new TypeInfo[this.typeArguments.length];
            for (int i = 0; i < this.typeArguments.length; ++i) {
                try {
                    infos[i] = JavassistParameterizedClassInfo.this.factory.getTypeInfo(this.typeArguments[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return infos;
        }

        public ClassLoader getClassLoader() {
            return JavassistParameterizedClassInfo.this.delegate.getClassLoader();
        }
    }

    private static interface LazyTypeArgumentFactory {
        public TypeInfo[] createTypeInfos();

        public ClassLoader getClassLoader();
    }

    private static class CollectionTypeChecker
    implements TypeChecker {
        static final CollectionTypeChecker INSTANCE = new CollectionTypeChecker();

        private CollectionTypeChecker() {
        }

        public boolean check(JavassistParameterizedClassInfo info) {
            return info.isCollection();
        }
    }

    private static class MapTypeChecker
    implements TypeChecker {
        static final MapTypeChecker INSTANCE = new MapTypeChecker();

        private MapTypeChecker() {
        }

        public boolean check(JavassistParameterizedClassInfo info) {
            return info.isMap();
        }
    }

    private static interface TypeChecker {
        public boolean check(JavassistParameterizedClassInfo var1);
    }
}

