/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.PackageInfoImpl;
import org.jboss.reflect.plugins.TypeInfoAttachments;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.javassist.InsertBeforeJavassistBody;
import org.jboss.reflect.plugins.javassist.JavassistClassInfo;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistInheritableAnnotationHolder;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.SecurityActions;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.Body;
import org.jboss.reflect.spi.CannotCompileException;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MutableClassInfo;
import org.jboss.reflect.spi.MutableConstructorInfo;
import org.jboss.reflect.spi.MutableFieldInfo;
import org.jboss.reflect.spi.MutableMethodInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTypeInfo
extends JavassistInheritableAnnotationHolder
implements MutableClassInfo,
InterfaceInfo,
JavassistClassInfo {
    private static final long serialVersionUID = -5072033691434335775L;
    protected static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    static final JavassistTypeInfo COLLECTION;
    static final JavassistTypeInfo MAP;
    private JavassistTypeInfoFactoryImpl factory;
    private final String name;
    private volatile Class<? extends Object> clazz;
    private final Map<SignatureKey, JavassistConstructorInfo> constructors = new ConcurrentHashMap<SignatureKey, JavassistConstructorInfo>();
    private volatile MutableConstructorInfo[] constructorArray;
    private final Map<String, JavassistFieldInfo> fields = new ConcurrentHashMap<String, JavassistFieldInfo>();
    private volatile MutableFieldInfo[] fieldArray;
    private final Map<SignatureKey, JavassistMethodInfo> methods = new ConcurrentHashMap<SignatureKey, JavassistMethodInfo>();
    private final Map<SignatureKey, List<JavassistMethodInfo>> volatileMethods = new HashMap<SignatureKey, List<JavassistMethodInfo>>();
    private volatile MutableMethodInfo[] methodArray;
    private volatile PackageInfo packageInfo;
    private volatile transient TypeInfoAttachments attachments;
    private volatile ClassInfo genericSuperClass = ClassInfoImpl.UNKNOWN_CLASS;
    private volatile InterfaceInfo[] genericInterfaces = ClassInfoImpl.UNKNOWN_INTERFACES;
    private volatile TypeInfo componentType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile TypeInfo keyType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile TypeInfo valueType = ClassInfoImpl.UNKNOWN_TYPE;
    private volatile Boolean isMap;
    private volatile Boolean isCollection;
    private volatile transient ClassInfo superClass = ClassInfoImpl.UNKNOWN_CLASS;
    private volatile transient InterfaceInfo[] interfaces = ClassInfoImpl.UNKNOWN_INTERFACES;
    private volatile transient boolean initializedClassSignature;
    private volatile transient SignatureAttribute.ClassSignature classSignature;

    JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz) {
        this(factory, ctClass.getName(), ctClass, clazz);
    }

    JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, String name, CtClass ctClass, Class<? extends Object> clazz) {
        super(ctClass, factory);
        this.factory = factory;
        this.clazz = clazz;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    @Override
    public String getSimpleName() {
        return this.ctClass.getSimpleName();
    }

    @Override
    public int getModifiers() {
        return this.ctClass.getModifiers();
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    @Deprecated
    public Class<? extends Object> getType() {
        if (this.clazz == null) {
            this.clazz = SecurityActions.ctClassToClass(this.ctClass);
        }
        return this.clazz;
    }

    @Override
    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERMISSION);
        }
        return this.getClassLoaderInternal();
    }

    @Override
    public ClassLoader getClassLoaderInternal() {
        return JavassistUtil.getClassLoader(this.ctClass);
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superClass == ClassInfoImpl.UNKNOWN_CLASS) {
            if (this.isInterface()) {
                this.superClass = null;
            } else {
                try {
                    CtClass superclass = this.ctClass.getSuperclass();
                    this.superClass = superclass == null ? null : (ClassInfo)this.factory.getTypeInfo(superclass);
                }
                catch (NotFoundException e) {
                    throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(this.ctClass.getClassFile2().getSuperclass() + " from " + this.ctClass.getName() + " in pool " + this.ctClass.getClassPool(), e);
                }
            }
        }
        return this.superClass;
    }

    @Override
    public ClassInfo getGenericSuperclass() {
        if (this.genericSuperClass == ClassInfoImpl.UNKNOWN_CLASS) {
            SignatureAttribute.ClassSignature classSig = this.getClassSignature();
            if (this.getClassSignature() != null) {
                SignatureAttribute.ClassType type = classSig.getSuperClass();
                this.genericSuperClass = (ClassInfo)this.factory.getTypeInfo(this.getClassLoaderInternal(), type, JavassistTypeVariableSpy.createForClass(classSig));
            } else {
                this.genericSuperClass = this.getSuperclass();
            }
        }
        return this.genericSuperClass;
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == ClassInfoImpl.UNKNOWN_INTERFACES) {
            try {
                CtClass[] ifaces = this.ctClass.getInterfaces();
                if (ifaces == null || ifaces.length == 0) {
                    return null;
                }
                InterfaceInfo[] result = new InterfaceInfo[ifaces.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (InterfaceInfo)this.factory.getTypeInfo(ifaces[i]);
                }
                this.interfaces = result;
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for interfaces of " + this.getName(), e);
            }
        }
        return this.interfaces;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        InterfaceInfo[] interfaces = this.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            this.genericInterfaces = null;
        }
        if (this.genericInterfaces == ClassInfoImpl.UNKNOWN_INTERFACES) {
            InterfaceInfo[] infos = new InterfaceInfo[this.getInterfaces().length];
            SignatureAttribute.ClassSignature classSig = this.getClassSignature();
            if (classSig != null) {
                SignatureAttribute.ClassType[] types = classSig.getInterfaces();
                for (int i = 0; i < types.length; ++i) {
                    ClassInfo info = (ClassInfo)this.factory.getTypeInfo(this.getClassLoaderInternal(), types[i], JavassistTypeVariableSpy.createForClass(classSig));
                    if (!(info instanceof InterfaceInfo)) {
                        throw new IllegalStateException(info + " is not an InterfaceInfo");
                    }
                    infos[i] = (InterfaceInfo)info;
                }
                this.genericInterfaces = infos;
            } else {
                this.genericInterfaces = this.getInterfaces();
            }
        }
        return this.genericInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConstructorInfo[] getDeclaredConstructors() {
        if (this.constructorArray == null) {
            CtConstructor[] declaredConstructors = this.ctClass.getDeclaredConstructors();
            if (declaredConstructors == null || declaredConstructors.length == 0) {
                this.constructorArray = new MutableConstructorInfo[0];
            } else {
                Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
                synchronized (map) {
                    for (int i = 0; i < declaredConstructors.length; ++i) {
                        this.generateConstructorInfo(declaredConstructors[i]);
                    }
                    Collection<JavassistConstructorInfo> constructorCollection = this.constructors.values();
                    this.constructorArray = constructorCollection.toArray(new MutableConstructorInfo[constructorCollection.size()]);
                }
            }
        }
        return this.constructorArray;
    }

    @Override
    public MutableConstructorInfo getDeclaredConstructor() {
        return this.getDeclaredConstructor(new SignatureKey(null));
    }

    @Override
    public MutableConstructorInfo getDeclaredConstructor(TypeInfo ... parameters) {
        return this.getDeclaredConstructor(new SignatureKey(null, parameters));
    }

    @Override
    public MutableConstructorInfo getDeclaredConstructor(String ... parameters) throws ClassNotFoundException {
        TypeInfo[] typeParams = new TypeInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typeParams[i] = this.factory.getTypeInfo(parameters[i], this.ctClass.getClassPool().getClassLoader());
        }
        return this.getDeclaredConstructor(typeParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableConstructorInfo getDeclaredConstructor(SignatureKey key) {
        Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
        synchronized (map) {
            MutableConstructorInfo constructor = this.constructors.get(key);
            if (constructor != null) {
                return constructor;
            }
        }
        if (this.constructorArray != null) {
            return null;
        }
        return this.generateConstructorInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFieldInfo getDeclaredField(String fieldName) {
        Map<String, JavassistFieldInfo> map = this.fields;
        synchronized (map) {
            MutableFieldInfo field = this.fields.get(fieldName);
            if (field != null) {
                return field;
            }
        }
        if (this.fieldArray != null) {
            return null;
        }
        try {
            CtField field = this.ctClass.getDeclaredField(fieldName);
            if (field == null) {
                return null;
            }
            return this.generateFieldInfo(field);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFieldInfo[] getDeclaredFields() {
        if (this.fieldArray == null) {
            CtField[] declaredFields = this.ctClass.getDeclaredFields();
            if (declaredFields == null || declaredFields.length == 0) {
                this.fieldArray = new MutableFieldInfo[0];
            } else {
                Map<String, JavassistFieldInfo> map = this.fields;
                synchronized (map) {
                    for (int i = 0; i < declaredFields.length; ++i) {
                        this.generateFieldInfo(declaredFields[i]);
                    }
                    Collection<JavassistFieldInfo> fieldCollection = this.fields.values();
                    this.fieldArray = fieldCollection.toArray(new MutableFieldInfo[fieldCollection.size()]);
                }
            }
        }
        return this.fieldArray;
    }

    @Override
    public MutableMethodInfo getDeclaredMethod(String methodName) {
        return this.getDeclaredMethod(new SignatureKey(methodName));
    }

    @Override
    public MutableMethodInfo getDeclaredMethod(String methodName, TypeInfo ... parameters) {
        return this.getDeclaredMethod(new SignatureKey(methodName, parameters));
    }

    @Override
    public MutableMethodInfo getDeclaredMethod(String methodName, String ... parameters) throws ClassNotFoundException {
        TypeInfo[] typeParams = new TypeInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typeParams[i] = this.factory.getTypeInfo(parameters[i], this.ctClass.getClassPool().getClassLoader());
        }
        return this.getDeclaredMethod(methodName, typeParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableMethodInfo getDeclaredMethod(SignatureKey key) {
        Map<SignatureKey, JavassistMethodInfo> map = this.methods;
        synchronized (map) {
            MutableMethodInfo method = this.methods.get(key);
            if (method != null) {
                return method;
            }
        }
        if (this.methodArray != null) {
            return null;
        }
        return this.generateMethodInfo(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMethodInfo[] getDeclaredMethods() {
        if (this.methodArray == null) {
            CtMethod[] declaredMethods = this.ctClass.getDeclaredMethods();
            if (declaredMethods == null || declaredMethods.length == 0) {
                this.methodArray = new MutableMethodInfo[0];
            } else {
                Map<SignatureKey, JavassistMethodInfo> map = this.methods;
                synchronized (map) {
                    for (int i = 0; i < declaredMethods.length; ++i) {
                        this.generateMethodInfo(declaredMethods[i]);
                    }
                    Collection<JavassistMethodInfo> methodCollection = this.methods.values();
                    if (this.volatileMethods.size() > 0) {
                        ArrayList<JavassistMethodInfo> allMethods = new ArrayList<JavassistMethodInfo>();
                        allMethods.addAll(methodCollection);
                        methodCollection = allMethods;
                        for (List<JavassistMethodInfo> infos : this.volatileMethods.values()) {
                            if (infos.size() <= 0) continue;
                            methodCollection.addAll(infos);
                        }
                    }
                    this.methodArray = methodCollection.toArray(new MutableMethodInfo[methodCollection.size()]);
                }
            }
        }
        return this.methodArray;
    }

    @Override
    public boolean isArray() {
        return this.getCtClass().isArray();
    }

    @Override
    public boolean isCollection() {
        if (this.isCollection == null) {
            try {
                this.isCollection = JavassistHelper.determineHierarchy(null, this, COLLECTION);
            }
            catch (NotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.isCollection;
    }

    @Override
    public boolean isMap() {
        if (this.isMap == null) {
            try {
                this.isMap = JavassistHelper.determineHierarchy(null, this, MAP);
            }
            catch (NotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.isMap;
    }

    @Override
    public boolean isAnnotation() {
        return this.getCtClass().isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.getCtClass().isEnum();
    }

    @Override
    public boolean isPrimitive() {
        return this.getCtClass().isPrimitive();
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    @Override
    public TypeInfo getArrayType() {
        Class<?> arrayClass = JavassistTypeInfo.getArrayClass(this.getType());
        return this.factory.getTypeInfo(arrayClass);
    }

    @Override
    public Object newArrayInstance(int size) throws Throwable {
        if (!this.isArray()) {
            throw new ClassCastException(this + " is not an array.");
        }
        return Array.newInstance(this.getComponentType().getType(), size);
    }

    @Override
    public boolean isAssignableFrom(TypeInfo info) {
        if (info == null) {
            throw new NullPointerException("Parameter info cannot be null!");
        }
        return this.getType().isAssignableFrom(info.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.getType().isInstance(object);
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return this.factory;
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable {
        return ValueConvertor.convertValue(this.getType(), value, replaceProperties, trim);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return this.getName().equals(other.getName());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    @Override
    public JavassistTypeInfoFactoryImpl getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MutableConstructorInfo generateConstructorInfo(CtConstructor constructor) {
        SignatureKey key = new SignatureKey(null, (CtBehavior)constructor);
        JavassistConstructorInfo info = new JavassistConstructorInfo(key, (AnnotationHelper)this.factory, this, constructor);
        Map<SignatureKey, JavassistConstructorInfo> map = this.constructors;
        synchronized (map) {
            this.constructors.put(key, info);
        }
        return info;
    }

    protected MutableConstructorInfo generateConstructorInfo(SignatureKey key) {
        CtClass[] params = this.getParameterTypes(key);
        try {
            CtConstructor ctConstructor = this.ctClass.getDeclaredConstructor(params);
            return this.generateConstructorInfo(ctConstructor);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for constructor " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MutableFieldInfo generateFieldInfo(CtField field) {
        JavassistFieldInfo info = new JavassistFieldInfo(this.factory, this, field);
        Map<String, JavassistFieldInfo> map = this.fields;
        synchronized (map) {
            this.fields.put(field.getName(), info);
        }
        return info;
    }

    protected MutableMethodInfo generateMethodInfo(SignatureKey key) {
        CtClass[] params = this.getParameterTypes(key);
        try {
            CtMethod ctMethod = this.ctClass.getDeclaredMethod(key.name, params);
            return this.generateMethodInfo(key, ctMethod);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for method " + key.name, e);
        }
    }

    protected MutableMethodInfo generateMethodInfo(CtMethod method) {
        SignatureKey key = new SignatureKey(method.getName(), (CtBehavior)method);
        return this.generateMethodInfo(key, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MutableMethodInfo generateMethodInfo(SignatureKey key, CtMethod method) {
        JavassistMethodInfo info = new JavassistMethodInfo(key, (AnnotationHelper)this.factory, this, method);
        Map<SignatureKey, JavassistMethodInfo> map = this.methods;
        synchronized (map) {
            if (Modifier.isVolatile(method.getModifiers())) {
                List<JavassistMethodInfo> infos = this.volatileMethods.get(key);
                if (infos == null) {
                    infos = new CopyOnWriteArrayList<JavassistMethodInfo>();
                    this.volatileMethods.put(key, infos);
                }
                infos.add(info);
            } else {
                this.methods.put(key, info);
            }
        }
        return info;
    }

    protected CtClass[] getParameterTypes(SignatureKey key) {
        if (key.params == null) {
            return null;
        }
        CtClass[] result = new CtClass[key.params.length];
        for (int i = 0; i < key.params.length; ++i) {
            result[i] = this.factory.getCtClass(key.params[i]);
        }
        return result;
    }

    protected Object getAnnotatedTarget() {
        return this.ctClass;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctClass);
    }

    @Override
    public JavassistInheritableAnnotationHolder getSuperHolder() {
        try {
            CtClass zuper = this.ctClass.getSuperclass();
            if (zuper == null) {
                return null;
            }
            return (JavassistTypeInfo)this.factory.getTypeInfo(zuper);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TypeInfo[] getActualTypeArguments() {
        return ClassInfoImpl.UNKNOWN_TYPES;
    }

    @Override
    public TypeInfo getOwnerType() {
        return null;
    }

    @Override
    public ClassInfo getRawType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        if (!this.isCollection()) {
            return null;
        }
        if (this.componentType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.componentType = this.findTypeInfo(COLLECTION, 0);
        }
        return this.componentType;
    }

    @Override
    public TypeInfo getKeyType() {
        if (!this.isMap()) {
            return null;
        }
        if (this.keyType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.keyType = this.findTypeInfo(MAP, 0);
        }
        return this.keyType;
    }

    @Override
    public TypeInfo getValueType() {
        if (!this.isMap()) {
            return null;
        }
        if (this.valueType == ClassInfoImpl.UNKNOWN_TYPE) {
            this.valueType = this.findTypeInfo(MAP, 1);
        }
        return this.valueType;
    }

    private TypeInfo findTypeInfo(ClassInfo iface, int parameter) {
        try {
            SignatureAttribute.ClassType type = JavassistHelper.determineType(this, iface, parameter);
            return this.factory.getTypeInfo(this.getClassLoaderInternal(), type, JavassistTypeVariableSpy.createForClass(this.getClassSignature()));
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public PackageInfo getPackage() {
        String packageName;
        if (this.packageInfo == null && (packageName = this.ctClass.getPackageName()) != null) {
            AnnotationValue[] annotations = null;
            try {
                ClassLoader cl = this.ctClass.getClassPool().getClassLoader();
                String name = packageName + ".package-info";
                JavassistTypeInfo javassistTypeInfo = this;
                CtClass clazz = javassistTypeInfo.factory.getPoolFactory().getPoolForLoader(cl).get(name);
                try {
                    ClassInfo info = (ClassInfo)this.factory.get(clazz, null, name, cl, false);
                    annotations = info.getAnnotations();
                }
                catch (ClassNotFoundException ignoree) {}
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            this.packageInfo = new PackageInfoImpl(this.ctClass.getPackageName(), annotations);
        }
        return this.packageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        JavassistTypeInfo javassistTypeInfo = this;
        synchronized (javassistTypeInfo) {
            if (this.attachments == null) {
                if (attachment == null) {
                    return;
                }
                this.attachments = new TypeInfoAttachments();
            }
        }
        if (attachment == null) {
            this.attachments.removeAttachment(name);
        } else {
            this.attachments.addAttachment(name, attachment);
        }
    }

    @Override
    public <T> T getAttachment(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(expectedType.getName());
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttachment(String attachmentName) {
        if (attachmentName == null) {
            throw new IllegalArgumentException("Null name");
        }
        JavassistTypeInfo javassistTypeInfo = this;
        synchronized (javassistTypeInfo) {
            if (this.attachments == null) {
                return null;
            }
        }
        return this.attachments.getAttachment(attachmentName);
    }

    CtClass getCtClass() {
        return this.ctClass;
    }

    protected void clearMethodCache() {
        if (this.methodArray != null) {
            this.methodArray = null;
        }
        if (this.methods.size() > 0) {
            this.methods.clear();
        }
    }

    protected void clearConstructorCache() {
        if (this.constructorArray != null) {
            this.constructorArray = null;
        }
        if (this.constructors.size() > 0) {
            this.constructors.clear();
        }
    }

    protected void clearFieldCache() {
        if (this.fieldArray != null) {
            this.fieldArray = null;
        }
        if (this.fields.size() > 0) {
            this.fields.clear();
        }
    }

    @Override
    public void addConstructor(MutableConstructorInfo mci) {
        if (mci instanceof JavassistConstructorInfo) {
            try {
                this.ctClass.addConstructor(((JavassistConstructorInfo)mci).getCtConstructor());
                this.clearConstructorCache();
            }
            catch (javassist.CannotCompileException e) {
                throw new CannotCompileException(e.toString());
            }
        }
    }

    @Override
    public void addField(MutableFieldInfo mfi) {
        if (mfi instanceof JavassistFieldInfo) {
            try {
                this.ctClass.addField(((JavassistFieldInfo)mfi).getCtField());
                this.clearFieldCache();
            }
            catch (javassist.CannotCompileException e) {
                throw new CannotCompileException(e.toString());
            }
        }
    }

    @Override
    public void addMethod(MutableMethodInfo mmi) {
        if (mmi instanceof JavassistMethodInfo) {
            try {
                this.ctClass.addMethod(((JavassistMethodInfo)mmi).getCtMethod());
                this.clearMethodCache();
            }
            catch (javassist.CannotCompileException e) {
                throw new CannotCompileException(e.toString());
            }
        }
    }

    @Override
    public MutableConstructorInfo createMutableConstructor(Body body) {
        try {
            CtConstructor constructor = CtNewConstructor.make((String)body.getBody(), (CtClass)this.ctClass);
            return new JavassistConstructorInfo(null, (AnnotationHelper)this.factory, this, constructor);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableConstructorInfo createMutableConstructor(int modifiers, String[] parameters, String[] exceptions) {
        try {
            CtConstructor constructor = CtNewConstructor.make((CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), parameters), (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), exceptions), (CtClass)this.ctClass);
            constructor.setModifiers(modifiers);
            return new JavassistConstructorInfo(null, (AnnotationHelper)this.factory, this, constructor);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableConstructorInfo createMutableConstructor(int modifiers, ClassInfo[] parameters, ClassInfo[] exceptions) {
        try {
            CtConstructor constructor = CtNewConstructor.make((CtClass[])JavassistUtil.toCtClass(parameters), (CtClass[])JavassistUtil.toCtClass(exceptions), (CtClass)this.ctClass);
            constructor.setModifiers(modifiers);
            return new JavassistConstructorInfo(null, (AnnotationHelper)this.factory, this, constructor);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableConstructorInfo createMutableConstructor(int modifiers, Body body, String[] parameters, String[] exceptions) {
        try {
            CtConstructor constructor = CtNewConstructor.make((CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), parameters), (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), exceptions), (String)body.getBody(), (CtClass)this.ctClass);
            constructor.setModifiers(modifiers);
            return new JavassistConstructorInfo(null, (AnnotationHelper)this.factory, this, constructor);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableConstructorInfo createMutableConstructor(int modifiers, Body body, ClassInfo[] parameters, ClassInfo[] exceptions) {
        try {
            CtConstructor constructor = CtNewConstructor.make((CtClass[])JavassistUtil.toCtClass(parameters), (CtClass[])JavassistUtil.toCtClass(exceptions), (String)body.getBody(), (CtClass)this.ctClass);
            constructor.setModifiers(modifiers);
            return new JavassistConstructorInfo(null, (AnnotationHelper)this.factory, this, constructor);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableFieldInfo createMutableField(int modifiers, String type, String fieldName) {
        try {
            CtField field = new CtField(JavassistUtil.toCtClass(this.ctClass.getClassPool(), type), fieldName, this.ctClass);
            field.setModifiers(modifiers);
            return new JavassistFieldInfo(this.factory, this, field);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableFieldInfo createMutableField(int modifiers, ClassInfo type, String fieldName) {
        try {
            CtField field = new CtField(JavassistUtil.toCtClass(type), fieldName, this.ctClass);
            field.setModifiers(modifiers);
            return new JavassistFieldInfo(this.factory, this, field);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableMethodInfo createMutableMethod(Body body) {
        try {
            CtMethod method = CtNewMethod.make((String)body.getBody(), (CtClass)this.ctClass);
            return new JavassistMethodInfo(null, (AnnotationHelper)this.factory, this, method);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableMethodInfo createMutableMethod(int modifiers, String returnType, String methodName, String[] parameters, String[] exceptions) {
        try {
            CtMethod method = CtNewMethod.make((int)modifiers, (CtClass)JavassistUtil.toCtClass(this.ctClass.getClassPool(), returnType), (String)methodName, (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), parameters), (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), exceptions), (String)new InsertBeforeJavassistBody("{}").getBody(), (CtClass)this.ctClass);
            return new JavassistMethodInfo(null, (AnnotationHelper)this.factory, this, method);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableMethodInfo createMutableMethod(int modifiers, ClassInfo returnType, String methodName, ClassInfo[] parameters, ClassInfo[] exceptions) {
        try {
            CtMethod method = CtNewMethod.make((int)modifiers, (CtClass)JavassistUtil.toCtClass(returnType), (String)methodName, (CtClass[])JavassistUtil.toCtClass(parameters), (CtClass[])JavassistUtil.toCtClass(exceptions), (String)new InsertBeforeJavassistBody("{}").getBody(), (CtClass)this.ctClass);
            return new JavassistMethodInfo(null, (AnnotationHelper)this.factory, this, method);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableMethodInfo createMutableMethod(int modifiers, String returnType, String methodName, Body body, String[] parameters, String[] exceptions) {
        try {
            CtMethod method = CtNewMethod.make((int)modifiers, (CtClass)JavassistUtil.toCtClass(this.ctClass.getClassPool(), returnType), (String)methodName, (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), parameters), (CtClass[])JavassistUtil.toCtClass(this.ctClass.getClassPool(), exceptions), (String)body.getBody(), (CtClass)this.ctClass);
            return new JavassistMethodInfo(null, (AnnotationHelper)this.factory, this, method);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public MutableMethodInfo createMutableMethod(int modifiers, ClassInfo returnType, String methodName, Body body, ClassInfo[] parameters, ClassInfo[] exceptions) {
        try {
            CtMethod method = CtNewMethod.make((int)modifiers, (CtClass)JavassistUtil.toCtClass(returnType), (String)methodName, (CtClass[])JavassistUtil.toCtClass(parameters), (CtClass[])JavassistUtil.toCtClass(exceptions), (String)body.getBody(), (CtClass)this.ctClass);
            return new JavassistMethodInfo(null, (AnnotationHelper)this.factory, this, method);
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    @Override
    public void removeConstructor(MutableConstructorInfo mci) {
        if (mci instanceof JavassistConstructorInfo) {
            try {
                this.ctClass.removeConstructor(((JavassistConstructorInfo)mci).getCtConstructor());
                this.clearConstructorCache();
            }
            catch (NotFoundException e) {
                throw new org.jboss.reflect.spi.NotFoundException(e.toString());
            }
        }
    }

    @Override
    public void removeField(MutableFieldInfo mfi) {
        if (mfi instanceof JavassistFieldInfo) {
            try {
                this.ctClass.removeField(((JavassistFieldInfo)mfi).getCtField());
                this.clearFieldCache();
            }
            catch (NotFoundException e) {
                throw new org.jboss.reflect.spi.NotFoundException(e.toString());
            }
        }
    }

    @Override
    public void removeMethod(MutableMethodInfo mmi) {
        if (mmi instanceof JavassistMethodInfo) {
            try {
                this.ctClass.removeMethod(((JavassistMethodInfo)mmi).getCtMethod());
                this.clearMethodCache();
            }
            catch (NotFoundException e) {
                throw new org.jboss.reflect.spi.NotFoundException(e.toString());
            }
        }
    }

    @Override
    public byte[] toByteCode() {
        try {
            return this.ctClass.toBytecode();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        catch (javassist.CannotCompileException e) {
            throw new CannotCompileException(e.toString());
        }
    }

    protected Object writeReplace() {
        return new MarshalledClassInfo(this.getType());
    }

    @Override
    public String getTypeVariable() {
        return null;
    }

    @Override
    public SignatureAttribute.ClassSignature getClassSignature() {
        if (!this.initializedClassSignature) {
            this.classSignature = JavassistHelper.getClassSignature(this.getCtClass());
            this.initializedClassSignature = true;
        }
        return this.classSignature;
    }

    static {
        JavassistTypeInfoFactory factory = new JavassistTypeInfoFactory();
        try {
            COLLECTION = (JavassistTypeInfo)factory.getTypeInfo(Collection.class);
            MAP = (JavassistTypeInfo)factory.getTypeInfo(Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarshalledClassInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Class<?> type;

        public MarshalledClassInfo(Class<?> type) {
            this.type = type;
        }

        protected Object readResolve() {
            JavassistTypeInfoFactory tif = new JavassistTypeInfoFactory();
            return tif.getTypeInfo(this.type);
        }
    }
}

