/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class CachingLoadClassClassLoaderFinder implements ClassLoaderFinder
{
   public static CachingLoadClassClassLoaderFinder INSTANCE = new CachingLoadClassClassLoaderFinder();
   
   private final ConcurrentMap<ClassLoader, ConcurrentMap<String, ClassLoader>> loaders = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String,ClassLoader>>(8, .75f, 2);
   
   private CachingLoadClassClassLoaderFinder()
   {
   }
   
   public ClassLoader getLoaderForClass(ClassLoader initiating, String name)
   {
      ConcurrentMap<String, ClassLoader> loadersByClass = loaders.get(name);
      if (loadersByClass == null)
      {
         loadersByClass = new ConcurrentHashMap<String, ClassLoader>(8, .75f, 2);
         ConcurrentMap<String, ClassLoader> old = loaders.putIfAbsent(initiating, loadersByClass);
         if (old != null)
            loadersByClass = old;
      }
      ClassLoader loader = loadersByClass.get(name);
      if (loader == null)
      {
         try
         {
            Class<?> clazz = SecurityActions.loadClass(initiating, name);;
            loader = SecurityActions.getClassLoader(clazz);
            if (loader == null)
               loader = SecurityActions.getSystemClassLoader();;
            loadersByClass.putIfAbsent(name, loader);
         }
         catch (ClassNotFoundException e)
         {
            if (name.endsWith(".package-info"))
               return null;
            // AutoGenerated
            throw new RuntimeException("Could not find '" + name + "' in classloader " + initiating);
         }
         
      }

      return loader;
   }

}
