/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.lang.annotation.Annotation;

import org.jboss.reflect.plugins.bytecode.bytes.BytecodePrimitive;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class AsmPrimitiveClassBytes extends JBossObject implements PrimitiveBytes
{
   final static String[] NO_INTERFACES = new String[0];
   
   static final AsmPrimitiveClassBytes BOOLEAN = new AsmPrimitiveClassBytes(BytecodePrimitive.BOOLEAN);

   static final AsmPrimitiveClassBytes CHAR = new AsmPrimitiveClassBytes(BytecodePrimitive.CHAR);

   static final AsmPrimitiveClassBytes BYTE = new AsmPrimitiveClassBytes(BytecodePrimitive.BYTE);

   static final AsmPrimitiveClassBytes SHORT = new AsmPrimitiveClassBytes(BytecodePrimitive.SHORT);

   static final AsmPrimitiveClassBytes INT = new AsmPrimitiveClassBytes(BytecodePrimitive.INT);

   static final AsmPrimitiveClassBytes LONG = new AsmPrimitiveClassBytes(BytecodePrimitive.LONG);

   static final AsmPrimitiveClassBytes FLOAT = new AsmPrimitiveClassBytes(BytecodePrimitive.FLOAT);

   static final AsmPrimitiveClassBytes DOUBLE = new AsmPrimitiveClassBytes(BytecodePrimitive.DOUBLE);

   static final AsmPrimitiveClassBytes VOID = new AsmPrimitiveClassBytes(BytecodePrimitive.FLOAT);
   
   final BytecodePrimitive delegate;
   
   public AsmPrimitiveClassBytes(BytecodePrimitive primitives)
   {
      this.delegate = primitives;
   }
   
   public String getJvmName()
   {
      return delegate.getName();
   }

   public String getTypeInfoName()
   {
      return delegate.getName();
   }
   
   public String getArrayComponentName()
   {
      return delegate.getArrayComponentName();
   }

   public String getValueMethodName()
   {
      return delegate.getValueMethodName();
   }

   public String getWrapperClassName()
   {
      return delegate.getWrapperClassName();
   }
   
   public PrimitiveBytes getPrimitive()
   {
      return this;
   }
   
   public ClassLoader getClassLoader()
   {
      return SecurityActions.getSystemClassLoader();
   }

   public ClassBytes getComponentType()
   {
      return null;
   }

   public ConstructorBytes[] getDeclaredConstructorBytes()
   {
      return AsmClassBytes.NO_CONSTRUCTORS;
   }

   public FieldBytes[] getDeclaredFieldBytes()
   {
      return AsmClassBytes.NO_FIELDS;
   }

   public MethodBytes[] getDeclaredMethodBytes()
   {
      return AsmClassBytes.NO_METHODS;
   }

   public String[] getInterfaceJvmNames()
   {
      return NO_INTERFACES;
   }

   public String[] getInterfaceTypeInfoNames()
   {
      return NO_INTERFACES;
   }

   public String getSuperClassJvmName()
   {
      return null;
   }

   public String getSuperClassTypeInfoName()
   {
      return null;
   }

   public boolean isAnnotation()
   {
      return false;
   }

   public boolean isEnum()
   {
      return false;
   }

   public boolean isInterface()
   {
      return false;
   }

   public Annotation[] getAnnotations()
   {
      return AsmClassBytes.NO_ANNOTATIONS;
   }

   public String getGenericSignature()
   {
      return null;
   }

   public int getModifiers()
   {
      return 0;
   }

   @Override
   public void toShortString(JBossStringBuilder buffer)
   {
      buffer.append(getJvmName());
   }

   @Override
   protected void toString(JBossStringBuilder buffer)
   {
      toShortString(buffer);
   }
}
