/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.io.Serializable;
import java.lang.annotation.Annotation;

import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class AsmArrayBytes extends JBossObject implements ClassBytes
{
   static final String[] INTERFACE_TYPE_INFO_NAMES = new String[] {Cloneable.class.getName(), Serializable.class.getName()};  
   static final String[] INTERFACE_JVM_NAMES = new String[] {Cloneable.class.getName().replace('.', '/'), Serializable.class.getName().replace('.', '/')};  

   private final ClassBytes componentType;
   
   public AsmArrayBytes(ClassBytes componentType)
   {
      this.componentType = componentType;
   }

   public String getJvmName()
   {
      if (componentType.getComponentType() == null)
      {
         //We are the first dimension
         return "[L" + componentType.getJvmName() + ";";
      }
      return "[" + componentType.getJvmName();
   }

   public String getTypeInfoName()
   {
      return componentType.getTypeInfoName() + "[]";
   }

   public ClassLoader getClassLoader()
   {
      return componentType.getClassLoader();
   }

   public ClassBytes getComponentType()
   {
      return componentType;
   }

   public ConstructorBytes[] getDeclaredConstructorBytes()
   {
      return AsmClassBytes.NO_CONSTRUCTORS;
   }

   public FieldBytes[] getDeclaredFieldBytes()
   {
      return AsmClassBytes.NO_FIELDS;
   }

   public MethodBytes[] getDeclaredMethodBytes()
   {
      return AsmClassBytes.NO_METHODS;
   }

   public String[] getInterfaceJvmNames()
   {
      return INTERFACE_JVM_NAMES;
   }

   public String[] getInterfaceTypeInfoNames()
   {
      return INTERFACE_JVM_NAMES;
   }

   public String getSuperClassJvmName()
   {
      return "java/lang/Object";
   }

   public String getSuperClassTypeInfoName()
   {
      return "java.lang.Object";
   }

   public boolean isAnnotation()
   {
      return false;
   }

   public boolean isEnum()
   {
      return false;
   }

   public boolean isInterface()
   {
      return false;
   }

   public Annotation[] getAnnotations()
   {
      return null;
   }

   public String getGenericSignature()
   {
      return null;
   }

   public int getModifiers()
   {
      return 0;
   }

   public PrimitiveBytes getPrimitive()
   {
      return null;
   }

   @Override
   public void toShortString(JBossStringBuilder buffer)
   {
      toShortString(buffer);
   }

   @Override
   protected void toString(JBossStringBuilder buffer)
   {
      buffer.append(getJvmName());
   }
}
