/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteNamingStore;

public class RemoteContext
implements Context,
NameParser {
    private static final Logger log = Logger.getLogger(RemoteContext.class);
    public static int STATIC_KEEP_ALIVE;
    private static AtomicIntegerFieldUpdater<RemoteContext> keepAliveUpdater;
    private volatile int keepAlive = STATIC_KEEP_ALIVE;
    private final Name prefix;
    private final Hashtable<String, Object> environment;
    private final RemoteNamingStore namingStore;
    private final List<CloseTask> closeTasks;
    private final AtomicBoolean closed = new AtomicBoolean();

    public RemoteContext(RemoteNamingStore namingStore, Hashtable<String, Object> environment) {
        this(namingStore, environment, Collections.emptyList());
    }

    public RemoteContext(RemoteNamingStore namingStore, Hashtable<String, Object> environment, List<CloseTask> closeTasks) {
        this(new CompositeName(), namingStore, environment, closeTasks);
    }

    public RemoteContext(Name prefix, RemoteNamingStore namingStore, Hashtable<String, Object> environment) {
        this(prefix, namingStore, environment, Collections.emptyList());
    }

    public RemoteContext(Name prefix, RemoteNamingStore namingStore, Hashtable<String, Object> environment, List<CloseTask> closeTasks) {
        this.prefix = prefix;
        this.namingStore = namingStore;
        this.environment = environment;
        this.closeTasks = closeTasks;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            Object object = this.lookupInternal(name);
            return object;
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    private Object lookupInternal(Name name) throws NamingException {
        if (ClientUtil.isEmpty(name)) {
            return new RemoteContext(this.prefix, this.namingStore, this.environment);
        }
        Name absoluteName = this.getAbsoluteName(name);
        Object result = this.namingStore.lookup(absoluteName);
        if (result instanceof LinkRef) {
            result = this.resolveLink((LinkRef)result);
        } else if (result instanceof Reference && (result = this.getObjectInstance((Reference)result, name, this.environment)) instanceof LinkRef) {
            result = this.resolveLink((LinkRef)result);
        }
        return result;
    }

    private Object getObjectInstance(Reference reference, Name name, Hashtable<?, ?> environment) throws NamingException {
        try {
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(reference.getFactoryClassName());
            ObjectFactory factory = (ObjectFactory)ObjectFactory.class.cast(factoryClass.newInstance());
            return factory.getObjectInstance(reference, name, this, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Throwable t) {
            throw ClientUtil.namingException("failed to get object instance from reference", t);
        }
    }

    private Object resolveLink(LinkRef result) throws NamingException {
        Object linkResult;
        try {
            LinkRef linkRef = result;
            String referenceName = linkRef.getLinkName();
            linkResult = referenceName.startsWith("./") ? this.lookup(referenceName.substring(2)) : new InitialContext().lookup(referenceName);
        }
        catch (Throwable t) {
            throw ClientUtil.namingException("failed to deref link", t);
        }
        return linkResult;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parse(name));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        try {
            this.namingStore.bind(this.getAbsoluteName(name), object);
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        this.bind(this.parse(name), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        try {
            this.namingStore.rebind(name, object);
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this.parse(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.namingStore.unbind(name);
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.parse(name));
    }

    @Override
    public void rename(Name name, Name newName) throws NamingException {
        try {
            this.namingStore.rename(name, newName);
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public void rename(String name, String newName) throws NamingException {
        this.rename(this.parse(name), this.parse(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = ClientUtil.namingEnumeration(this.namingStore.list(name));
            return namingEnumeration;
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        try {
            NamingEnumeration<Binding> namingEnumeration = ClientUtil.namingEnumeration(this.namingStore.listBindings(name));
            return namingEnumeration;
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        try {
            this.namingStore.destroySubcontext(name);
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        try {
            Context context = this.namingStore.createSubcontext(name);
            return context;
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        try {
            Object object = this.namingStore.lookupLink(name);
            return object;
        }
        finally {
            keepAliveUpdater.lazySet(this, this.keepAlive + 1);
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this;
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.parse(name), this.parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.environment.put(s, o);
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return this.environment.remove(s);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        if (this.closed.compareAndSet(false, true)) {
            for (CloseTask closeTask : this.closeTasks) {
                closeTask.close(false);
            }
        }
    }

    public void finalize() {
        if (this.closed.compareAndSet(false, true)) {
            STATIC_KEEP_ALIVE = this.keepAlive;
            for (CloseTask closeTask : this.closeTasks) {
                closeTask.close(true);
            }
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public Name parse(String name) throws NamingException {
        return new CompositeName(name);
    }

    private Name getAbsoluteName(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.composeName(name, this.prefix);
        }
        return this.composeName(name, this.prefix);
    }

    static {
        keepAliveUpdater = AtomicIntegerFieldUpdater.newUpdater(RemoteContext.class, "keepAlive");
    }

    public static interface CloseTask {
        public void close(boolean var1);
    }
}

