/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestId
implements Serializable {
    private final String[] names;

    public TestId() {
        this.names = new String[0];
    }

    public TestId(TestId prefix, String name) throws IllegalArgumentException {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String[] names = new String[prefix.names.length + 1];
        System.arraycopy(prefix.names, 0, names, 0, prefix.names.length);
        names[prefix.names.length] = name;
        this.names = names;
    }

    public TestId(String name, TestId suffix) throws IllegalArgumentException {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String[] names = new String[1 + suffix.names.length];
        names[0] = name;
        System.arraycopy(suffix.names, 0, names, 1, suffix.names.length);
        this.names = names;
    }

    public TestId(String ... names) throws IllegalArgumentException {
        String[] tmp;
        if (names == null) {
            throw new IllegalArgumentException();
        }
        for (String name : tmp = (String[])names.clone()) {
            if (name != null) continue;
            throw new IllegalArgumentException();
        }
        this.names = tmp;
    }

    public TestId(Collection<String> names) throws IllegalArgumentException {
        String[] tmp;
        if (names == null) {
            throw new IllegalArgumentException();
        }
        for (String name : tmp = names.toArray(new String[names.size()])) {
            if (name != null) continue;
            throw new IllegalArgumentException();
        }
        this.names = tmp;
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TestId.this.names.length;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return TestId.this.names[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getName(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        if (index >= this.names.length) {
            throw new IllegalArgumentException("Index cannot be greater than the length " + this.names.length);
        }
        return this.names[index];
    }

    public int getLength() {
        return this.names.length;
    }

    public TestId range(int from) throws IllegalArgumentException {
        if (from < 0) {
            throw new IllegalArgumentException();
        }
        if (from > this.names.length) {
            throw new IllegalArgumentException();
        }
        String[] subNames = new String[this.names.length - from];
        System.arraycopy(this.names, from, subNames, 0, subNames.length);
        return new TestId(subNames);
    }

    public int hashCode() {
        int hashCode = 0;
        for (String name : this.names) {
            hashCode = hashCode * 41 + name.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TestId) {
            TestId that = (TestId)object;
            if (this.names.length != that.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                String thisName = this.names[i];
                String thatName = that.names[i];
                if (thisName.equals(thatName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("TestId[");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                tmp.append(',');
            }
            tmp.append("\"").append(this.names[i]).append("\"");
        }
        tmp.append(']');
        return tmp.toString();
    }
}

