/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.report.impl.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.event.EndRunnerEvent;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.EndTestSuiteEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.event.StartTestSuiteEvent;
import org.jboss.unit.tooling.SystemOutputManager;
import org.jboss.unit.tooling.SystemOutputView;

public abstract class AbstractJUnitReport
implements TestRunnerEventListener {
    private TestSuite current;

    public void onEvent(TestRunnerEvent event) {
        if (event instanceof StartRunnerEvent) {
            this.handle((StartRunnerEvent)event);
        } else if (event instanceof EndRunnerEvent) {
            this.handle((EndRunnerEvent)event);
        } else if (event instanceof RunnerFailureEvent) {
            this.handle((RunnerFailureEvent)event);
        } else if (event instanceof StartTestSuiteEvent) {
            this.handle((StartTestSuiteEvent)event);
        } else if (event instanceof EndTestSuiteEvent) {
            this.handle((EndTestSuiteEvent)event);
        } else if (event instanceof StartTestCaseEvent) {
            this.handle((StartTestCaseEvent)event);
        } else if (event instanceof EndTestCaseEvent) {
            this.handle((EndTestCaseEvent)event);
        }
    }

    protected abstract void startRunner();

    protected abstract void endRunner();

    protected abstract void runnerFailure(TestSuite var1, Failure var2);

    protected abstract void endTestCase(TestSuite var1, String var2, TestResult var3);

    protected abstract void startTestSuite(TestSuite var1);

    protected abstract void endTestSuite(TestSuite var1);

    private void handle(StartRunnerEvent event) {
        this.current = new TestSuite(null, "", new HashMap<String, String>());
        this.startTestSuite(this.current);
        this.startRunner();
    }

    private void handle(EndRunnerEvent event) {
        TestSuite tmp = this.current;
        this.current = null;
        this.endTestSuite(tmp);
        this.endRunner();
    }

    private void handle(StartTestSuiteEvent event) {
        this.current = new TestSuite(this.current, event.getTestInfo().getName(), event.getProperties());
        this.startTestSuite(this.current);
    }

    private void handle(EndTestSuiteEvent event) {
        TestSuite testSuite = this.current;
        this.current = this.current.parent;
        this.endTestSuite(testSuite);
    }

    private void handle(StartTestCaseEvent event) {
        this.current.startedTests.put(event.getTestId(), event.getTestInfo());
    }

    private void handle(RunnerFailureEvent event) {
        ++this.current.tests;
        ++this.current.errors;
        this.runnerFailure(this.current, event.getFailure());
    }

    private void handle(EndTestCaseEvent event) {
        TestId testId = event.getTestId();
        TestResult result = event.getTestResult();
        TestInfo info = this.current.startedTests.get(testId);
        this.current.startedTests.remove(testId);
        this.current.durationMillis += result.getDurationMillis();
        ++this.current.tests;
        this.endTestCase(this.current, info.getName(), result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestSuite {
        final TestSuite parent;
        final String name;
        Map<String, String> properties;
        long durationMillis;
        int tests;
        int errors;
        int failures;
        Map<TestId, TestInfo> startedTests = new HashMap<TestId, TestInfo>();
        SystemOutputView view = SystemOutputManager.getInstance().createView(false);

        TestSuite(TestSuite parent, String name, Map<String, String> properties) {
            this.parent = parent;
            this.name = name;
            this.properties = properties;
        }

        public StringBuffer getFQN() {
            if (this.parent == null) {
                return new StringBuffer("_none_");
            }
            ArrayList<TestSuite> tmp = new ArrayList<TestSuite>();
            TestSuite current = this;
            while (current.parent != null) {
                tmp.add(current);
                current = current.parent;
            }
            Collections.reverse(tmp);
            StringBuffer nb = new StringBuffer();
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                TestSuite testSuite = (TestSuite)i.next();
                nb.append(testSuite.name);
                if (!i.hasNext()) continue;
                nb.append(".");
            }
            return nb;
        }
    }
}

