/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.impl.driver;

import java.util.Map;
import org.jboss.unit.Failure;
import org.jboss.unit.FailureType;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.unit.driver.impl.pojo.SimpleDriverContext;
import org.jboss.unit.driver.response.EndTestResponse;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestCaseInfo;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.EndTestSuiteEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.event.StartTestSuiteEvent;
import org.jboss.unit.runner.results.TestFailure;
import org.jboss.unit.runner.results.TestSuccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDriverRunner
extends AbstractTestRunner {
    private final TestDriver driver;
    private TestId testId;

    public TestDriverRunner(TestDriver driver, TestId testId) {
        this.driver = driver;
        this.testId = testId;
    }

    public TestDriverRunner(TestDriver driver) {
        this(driver, null);
    }

    public TestId getTestId() {
        return this.testId;
    }

    public void setTestId(TestId testId) {
        this.testId = testId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalRun(TestRunnerContext context) {
        if (this.testId == null) {
            context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createErrorFailure("No test id specified")));
        } else {
            try {
                this.driver.initDriver(new SimpleDriverContext(context.getProperties()));
            }
            catch (Exception e) {
                context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createFailure("Was not able to start the test driver properly", e)));
                return;
            }
            try {
                TestInfo info = this.driver.getInfo();
                this.internalRun(context, info, this.testId, new TestId());
            }
            finally {
                try {
                    this.driver.destroyDriver();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRun(TestRunnerContext context, TestInfo currentInfo, TestId targetId, TestId currentId) {
        if (currentId.equals(targetId)) {
            if (context.getFilter().include(currentId, currentInfo)) {
                if (currentInfo instanceof TestSuiteInfo) {
                    TestSuiteInfo testSuiteInfo = (TestSuiteInfo)currentInfo;
                    context.getEventListener().onEvent(new StartTestSuiteEvent(currentId, testSuiteInfo, context.getProperties()));
                    for (String name : testSuiteInfo.getNames()) {
                        TestInfo childInfo = testSuiteInfo.getTest(name);
                        TestId childId = new TestId(currentId, name);
                        this.internalRun(context, childInfo, childId, childId);
                    }
                    context.getEventListener().onEvent(new EndTestSuiteEvent(this.testId));
                } else {
                    TestCaseInfo testCaseInfo = (TestCaseInfo)currentInfo;
                    for (Map<String, String> parametrization : context.getParametrizations().enumerate(testCaseInfo.getParameters().keySet())) {
                        context.getEventListener().onEvent(new StartTestCaseEvent(currentId, testCaseInfo));
                        StartTestCommand command = new StartTestCommand(parametrization);
                        TestResult result = null;
                        long duration = -System.currentTimeMillis();
                        DriverResponse response = null;
                        try {
                            try {
                                response = this.driver.invoke(currentId, command);
                            }
                            finally {
                                duration += System.currentTimeMillis();
                            }
                        }
                        catch (Exception e) {
                            Failure failure = new Failure("The test driver threw an unexpected exception ", e, FailureType.ERROR);
                            result = new TestFailure(failure, parametrization, duration);
                        }
                        if (result == null) {
                            result = this.unwrap(response, parametrization, duration);
                        }
                        context.getEventListener().onEvent(new EndTestCaseEvent(currentId, result));
                    }
                }
            }
        } else {
            TestSuiteInfo currentSuiteInfo;
            TestInfo nextInfo;
            String name = targetId.getName(currentId.getLength());
            if (currentInfo instanceof TestSuiteInfo && (nextInfo = (currentSuiteInfo = (TestSuiteInfo)currentInfo).getTest(name)) != null) {
                TestId nextId = new TestId(currentId, name);
                context.getEventListener().onEvent(new StartTestSuiteEvent(currentId, currentSuiteInfo, context.getProperties()));
                this.internalRun(context, nextInfo, targetId, nextId);
                context.getEventListener().onEvent(new EndTestSuiteEvent(currentId));
            }
        }
    }

    private TestResult unwrap(DriverResponse response, Map<String, String> parametrization, long duration) {
        if (response instanceof EndTestResponse) {
            return new TestSuccess(parametrization, duration);
        }
        if (response instanceof FailureResponse) {
            FailureResponse failureResponse = (FailureResponse)response;
            Failure failure = failureResponse.getFailure();
            return new TestFailure(failure, parametrization, duration);
        }
        Failure failure = new Failure("The test driver returned an unexpected response " + response, FailureType.ERROR);
        return new TestFailure(failure, parametrization, duration);
    }
}

