/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.unit.TestId;
import org.jboss.unit.TestIdFormat;
import org.jboss.unit.runner.model.ParameterValueDef;
import org.jboss.unit.runner.model.ParametersDef;
import org.jboss.unit.runner.model.TestSuiteDef;
import org.jboss.unit.runner.model.composite.CompositeTestSuiteDef;
import org.jboss.unit.runner.model.generic.GenericTestSuiteDef;
import org.jboss.unit.runner.model.generic.TestDef;
import org.jboss.unit.runner.model.pojo.POJOTestSuiteDef;
import org.jboss.unit.runner.model.pojo.TestCaseDef;
import org.jboss.unit.runner.model.pojo.TestClassDef;
import org.jboss.unit.util.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder {
    private final Element rootElt;
    private static final Schema schema;
    private static final int NO_SOURCE = 0;
    private static final int ELEMENT_SOURCE = 1;
    private static final int ATTRIBUTE_SOURCE = 2;

    public ModelBuilder(InputSource source) throws ParserConfigurationException, IOException, SAXException {
        if (source == null) {
            throw new IllegalArgumentException("No null source allowed");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            this.rootElt = doc.getDocumentElement();
        }
        catch (SAXParseException e) {
            System.out.println("Parse exception at line " + e.getLineNumber() + " and column " + e.getColumnNumber() + ": " + e.getMessage());
            throw e;
        }
    }

    public ModelBuilder(Element rootElt) {
        if (rootElt == null) {
            throw new IllegalArgumentException("No null suite element allowed");
        }
        this.rootElt = rootElt;
    }

    public TestSuiteDef build() {
        return this.buildTestSuite(this.rootElt);
    }

    private TestSuiteDef buildTestSuite(Element suiteElt) {
        String suiteName = suiteElt.getNodeName();
        if (suiteName.equals("jboss-unit") || suiteName.equals("suite")) {
            CompositeTestSuiteDef composite = new CompositeTestSuiteDef();
            for (Element childSuiteElt : XMLTools.children(suiteElt, new String[0])) {
                TestSuiteDef childSuite = this.buildTestSuite(childSuiteElt);
                composite.addSuite(childSuite);
            }
            return composite;
        }
        if (suiteName.equals("pojo")) {
            return this.buildPOJOTestSuite(suiteElt);
        }
        if (suiteName.equals("generic")) {
            return this.buildGenericTestSuite(suiteElt);
        }
        throw new AssertionError();
    }

    private TestSuiteDef buildGenericTestSuite(Element suiteElt) {
        Element classElt = XMLTools.child(suiteElt, "class");
        if (classElt == null) {
            throw new IllegalArgumentException();
        }
        Attr nameAttrOfClassElt = classElt.getAttributeNode("name");
        if (nameAttrOfClassElt == null) {
            throw new IllegalArgumentException();
        }
        GenericTestSuiteDef suite = new GenericTestSuiteDef(nameAttrOfClassElt.getValue());
        for (Element testElt : XMLTools.children(suiteElt, "test")) {
            Attr refidAttr = testElt.getAttributeNode("refid");
            if (refidAttr == null) {
                throw new IllegalArgumentException();
            }
            String refIdLitteral = refidAttr.getValue();
            TestId refId = TestIdFormat.CLASSIC.parse(refIdLitteral);
            TestDef test = new TestDef(refId);
            test.setParameters(this.buildParameters(testElt));
            suite.addTest(test);
        }
        suite.setProperties(this.buildProperties(suiteElt));
        suite.setParameters(this.buildParameters(suiteElt));
        return suite;
    }

    private TestSuiteDef buildPOJOTestSuite(Element suiteElt) {
        POJOTestSuiteDef suite = new POJOTestSuiteDef();
        for (Element testElt : XMLTools.children(suiteElt, "test")) {
            Element classElt = XMLTools.child(testElt, "class");
            Attr nameAttr = classElt.getAttributeNode("name");
            if (nameAttr == null) {
                throw new IllegalArgumentException();
            }
            String classname = nameAttr.getValue();
            TestClassDef testClass = new TestClassDef(classname);
            testClass.setParameters(this.buildParameters(testElt));
            testClass.setProperties(this.buildProperties(testElt));
            for (Element caseElt : XMLTools.children(classElt, "case")) {
                Attr caseNameAttr = caseElt.getAttributeNode("name");
                if (caseNameAttr == null) {
                    throw new IllegalArgumentException();
                }
                String testCaseName = caseNameAttr.getValue();
                TestCaseDef testCase = new TestCaseDef(testCaseName);
                testClass.addTestCase(testCase);
            }
            suite.addClass(testClass);
        }
        suite.setParameters(this.buildParameters(suiteElt));
        return suite;
    }

    private Map<String, String> buildProperties(Element propertyEltContainer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element propertyElt : XMLTools.children(propertyEltContainer, "property")) {
            String propertyName = propertyElt.getAttribute("name");
            String propertyValue = propertyElt.getAttribute("value");
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    private ParametersDef buildParameters(Element parameterEltContainer) {
        ParametersDef parameters = new ParametersDef();
        for (Element parameterElt : XMLTools.children(parameterEltContainer, "parameter")) {
            String parameterName = parameterElt.getAttribute("name");
            ArrayList<String> values = new ArrayList<String>();
            Attr attr = parameterElt.getAttributeNode("value");
            int src = 0;
            if (attr != null) {
                src = 2;
                values.add(attr.getValue());
            }
            NodeList children = parameterElt.getChildNodes();
            block4: for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 1: {
                        Element elt = (Element)child;
                        if (src == 2) {
                            throw new IllegalArgumentException();
                        }
                        src = 1;
                        String eltName = elt.getNodeName();
                        if ("value".equals(eltName)) {
                            values.add(XMLTools.text(elt));
                            continue block4;
                        }
                        if ("null".equals(eltName)) {
                            values.add(null);
                            continue block4;
                        }
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (values.size() == 0) {
                throw new IllegalArgumentException();
            }
            ParameterValueDef parameterValue = new ParameterValueDef(values);
            parameters.setParameter(parameterName, parameterValue);
        }
        return parameters;
    }

    static {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream in = ModelBuilder.class.getResourceAsStream("jboss-unit_1_0.xsd");
            StreamSource ss = new StreamSource(in);
            schema = schemaFactory.newSchema(ss);
        }
        catch (SAXException e) {
            throw new Error("Could not load jboss unit schema for validation", e);
        }
    }
}

