/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.spi.pojo;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.unit.api.pojo.annotations.Create;
import org.jboss.unit.api.pojo.annotations.Description;
import org.jboss.unit.api.pojo.annotations.Destroy;
import org.jboss.unit.api.pojo.annotations.Parameter;
import org.jboss.unit.api.pojo.annotations.Tag;
import org.jboss.unit.api.pojo.annotations.Test;
import org.jboss.unit.spi.pojo.ArgumentTestParameter;
import org.jboss.unit.spi.pojo.MethodKey;
import org.jboss.unit.spi.pojo.ParameterDescriptor;
import org.jboss.unit.spi.pojo.PropertyTestParameter;
import org.jboss.unit.spi.pojo.TestCase;
import org.jboss.unit.spi.pojo.TestCaseDef;
import org.jboss.unit.spi.pojo.TestCaseDescriptor;
import org.jboss.unit.spi.pojo.TestCaseImpl;
import org.jboss.unit.spi.pojo.TestCaseLifeCycleException;
import org.jboss.unit.spi.pojo.TestLifeCycle;
import org.jboss.unit.spi.pojo.TestParameter;
import org.jboss.unit.spi.pojo.TestProvider;
import org.jboss.unit.spi.pojo.TestSuiteDescriptor;
import org.jboss.unit.util.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProviderSupport
implements TestProvider,
TestLifeCycle,
TestSuiteDescriptor {
    private final String suiteName;
    private final String suiteDescription;
    private final Map<String, TestCaseDef> testCases;
    private final Method create;
    private final Method destroy;
    final Map<String, PropertyTestParameter> propertyParameters;
    private final Constructor ctor;
    private final Set<String> suiteKeywords;
    final Map<String, TestParameter> suiteParameters;

    public TestProviderSupport(Class testClass) {
        Description descriptionAnnotation;
        String suiteDescription;
        String suiteName;
        Constructor ctor;
        if (testClass == null) {
            throw new IllegalArgumentException();
        }
        if (Modifier.isAbstract(testClass.getModifiers())) {
            throw new IllegalArgumentException("Test class is abstract");
        }
        try {
            ctor = testClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Test testAnnotation = testClass.getAnnotation(Test.class);
        String string = suiteName = testAnnotation != null ? testAnnotation.name() : "";
        if (suiteName.length() == 0) {
            suiteName = testClass.getName();
        }
        String string2 = suiteDescription = (descriptionAnnotation = testClass.getAnnotation(Description.class)) != null ? descriptionAnnotation.value() : "";
        if (suiteDescription.length() == 0) {
            suiteDescription = "Test of class " + testClass.getName();
        }
        Tag tag = testClass.getAnnotation(Tag.class);
        HashSet<String> suiteKeywords = new HashSet<String>();
        if (tag != null) {
            suiteKeywords.addAll(CollectionTools.set(tag.value()));
        }
        TreeMap<MethodKey, Method> methods = new TreeMap<MethodKey, Method>();
        for (Method method : testClass.getMethods()) {
            MethodKey key = new MethodKey(method);
            methods.put(key, method);
        }
        HashMap<String, PropertyTestParameter> propertyParameters = new HashMap<String, PropertyTestParameter>();
        HashMap<String, TestCaseDef> testCases = new HashMap<String, TestCaseDef>();
        Method create = null;
        Method destroy = null;
        for (Method method : methods.values()) {
            String methodName = method.getName();
            int modifiers = method.getModifiers();
            Parameter parameterMethodAnnotation = method.getAnnotation(Parameter.class);
            Test testMethodAnnotation = method.getAnnotation(Test.class);
            Create createMethodAnnotation = method.getAnnotation(Create.class);
            Destroy destroyMethodAnnotation = method.getAnnotation(Destroy.class);
            if (testMethodAnnotation != null && parameterMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (createMethodAnnotation != null && parameterMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (createMethodAnnotation != null && testMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (destroyMethodAnnotation != null && parameterMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (destroyMethodAnnotation != null && testMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (destroyMethodAnnotation != null && createMethodAnnotation != null) {
                throw new IllegalArgumentException();
            }
            if (parameterMethodAnnotation != null) {
                PropertyTestParameter parameter;
                Description descriptionMethodAnnotation;
                String description;
                if (!methodName.startsWith("set")) {
                    throw new IllegalArgumentException();
                }
                if (methodName.length() < 4) {
                    throw new IllegalArgumentException();
                }
                if (method.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException();
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalArgumentException();
                }
                if (Modifier.isAbstract(modifiers)) {
                    throw new IllegalArgumentException();
                }
                if (!Modifier.isPublic(modifiers)) {
                    throw new IllegalArgumentException();
                }
                if (Modifier.isStatic(modifiers)) {
                    throw new IllegalArgumentException();
                }
                String name = parameterMethodAnnotation.name();
                if (name.length() == 0) {
                    name = Introspector.decapitalize(method.getName().substring(3));
                }
                String string3 = description = (descriptionMethodAnnotation = method.getAnnotation(Description.class)) != null ? descriptionMethodAnnotation.value() : "";
                if (description.length() == 0) {
                    description = "Parameter " + name;
                }
                if ((parameter = (PropertyTestParameter)propertyParameters.get(name)) == null) {
                    parameter = new PropertyTestParameter(name, description);
                    propertyParameters.put(name, parameter);
                }
                parameter.addSetter(method);
                continue;
            }
            if (createMethodAnnotation != null) {
                if (create != null) {
                    throw new IllegalArgumentException();
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalArgumentException();
                }
                if (Modifier.isAbstract(modifiers)) {
                    throw new IllegalArgumentException();
                }
                if (!Modifier.isPublic(modifiers)) {
                    throw new IllegalArgumentException();
                }
                if (Modifier.isStatic(modifiers)) {
                    throw new IllegalArgumentException();
                }
                if (method.getParameterTypes().length > 0) {
                    throw new IllegalArgumentException();
                }
                create = method;
                continue;
            }
            if (destroyMethodAnnotation == null) continue;
            if (destroy != null) {
                throw new IllegalArgumentException();
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException();
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalArgumentException();
            }
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalArgumentException();
            }
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException();
            }
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException();
            }
            destroy = method;
        }
        for (Method method : methods.values()) {
            Description descriptionMethodAnnotation;
            String description;
            int modifiers = method.getModifiers();
            Test testMethodAnnotation = method.getAnnotation(Test.class);
            if (testMethodAnnotation == null) continue;
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException();
            }
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalArgumentException();
            }
            if (!Modifier.isPublic(modifiers)) {
                throw new IllegalArgumentException();
            }
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException();
            }
            LinkedHashMap<String, ArgumentTestParameter> methodParameters = new LinkedHashMap<String, ArgumentTestParameter>();
            for (Annotation[] parameterAnnotations : method.getParameterAnnotations()) {
                String description2;
                String name;
                HashMap<Class<? extends Annotation>, Annotation> parameterAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    Class<? extends Annotation> blah = parameterAnnotation.annotationType();
                    parameterAnnotationMap.put(blah, parameterAnnotation);
                }
                Parameter argumentParameterAnnotation = (Parameter)parameterAnnotationMap.get(Parameter.class);
                if (argumentParameterAnnotation != null) {
                    name = argumentParameterAnnotation.name();
                    if (name.length() == 0) {
                        throw new IllegalArgumentException();
                    }
                    if (methodParameters.containsKey(name)) {
                        throw new IllegalArgumentException();
                    }
                    Description descriptionArgumentParameterAnnotation = (Description)parameterAnnotationMap.get(Description.class);
                    String string4 = description2 = descriptionArgumentParameterAnnotation != null ? descriptionArgumentParameterAnnotation.value() : "";
                    if (description2.length() == 0) {
                        description2 = "Method parameter " + name;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                methodParameters.put(name, new ArgumentTestParameter(name, description2));
            }
            String name = testMethodAnnotation.name();
            if (testMethodAnnotation.name().length() == 0) {
                name = method.getName();
            }
            String string5 = description = (descriptionMethodAnnotation = method.getAnnotation(Description.class)) != null ? descriptionMethodAnnotation.value() : "";
            if (description.length() == 0) {
                description = "Test of method " + method.getName();
            }
            HashSet<String> keywords = new HashSet<String>();
            Tag tagMethodAnnotation = method.getAnnotation(Tag.class);
            if (tagMethodAnnotation != null) {
                keywords.addAll(CollectionTools.set(tagMethodAnnotation.value()));
            }
            HashMap<String, TestParameter> parameters = new HashMap<String, TestParameter>(propertyParameters);
            parameters.putAll(methodParameters);
            TestCaseDef testCaseDef = new TestCaseDef(method, name, description, parameters, methodParameters, keywords);
            if (testCases.put(testCaseDef.getName(), testCaseDef) == null) continue;
            throw new IllegalArgumentException();
        }
        this.suiteName = suiteName;
        this.suiteDescription = suiteDescription;
        this.suiteKeywords = suiteKeywords;
        this.propertyParameters = propertyParameters;
        this.testCases = testCases;
        this.ctor = ctor;
        this.create = create;
        this.destroy = destroy;
        HashMap<String, TestParameter> suiteParameters = new HashMap<String, TestParameter>();
        for (TestCaseDef testCase : testCases.values()) {
            suiteParameters.putAll(testCase.arguments);
        }
        suiteParameters.putAll(propertyParameters);
        this.suiteParameters = suiteParameters;
    }

    @Override
    public TestSuiteDescriptor getDescriptor() {
        return this;
    }

    @Override
    public TestLifeCycle getLifeCycle() {
        return this;
    }

    @Override
    public String getName() {
        return this.suiteName;
    }

    @Override
    public String getDescription() {
        return this.suiteDescription;
    }

    @Override
    public Set<String> getKeywords() {
        return this.suiteKeywords;
    }

    @Override
    public Map<String, ? extends ParameterDescriptor> getParameters() {
        return Collections.unmodifiableMap(this.suiteParameters);
    }

    @Override
    public Map<String, ? extends TestCaseDescriptor> getTestCases() {
        return Collections.unmodifiableMap(this.testCases);
    }

    @Override
    public TestCase newTestCase(String name) throws TestCaseLifeCycleException {
        Object instance;
        TestCaseDef testCaseDef = this.testCases.get(name);
        if (testCaseDef == null) {
            throw new TestCaseLifeCycleException("No such test case <" + name + ">");
        }
        try {
            instance = this.ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new TestCaseLifeCycleException("Cannot create test case " + name, e.getCause());
        }
        catch (Exception e) {
            throw new TestCaseLifeCycleException("Cannot configure parameter " + name, e);
        }
        return new TestCaseImpl(testCaseDef, instance);
    }

    @Override
    public void testCaseParametrize(TestCase _testCase, Map<String, String> parametrization) throws TestCaseLifeCycleException {
        TestCaseImpl testCase = (TestCaseImpl)_testCase;
        testCase.parametrization = parametrization;
        for (PropertyTestParameter parameter : this.propertyParameters.values()) {
            if (!parametrization.containsKey(parameter.getName())) {
                throw new TestCaseLifeCycleException("Missing parameter " + parameter.getName());
            }
            String parameterValue = parametrization.get(parameter.getName());
            for (Method setter : parameter.setters) {
                try {
                    setter.invoke(testCase.pojo, parameterValue);
                }
                catch (InvocationTargetException e) {
                    throw new TestCaseLifeCycleException("Cannot configure parameter " + parameter.getName(), e.getCause());
                }
                catch (Exception e) {
                    throw new TestCaseLifeCycleException("Cannot configure parameter " + parameter.getName(), e);
                }
            }
        }
    }

    @Override
    public void testCaseCreate(TestCase _testCase) throws TestCaseLifeCycleException {
        TestCaseImpl testCase = (TestCaseImpl)_testCase;
        if (this.create != null) {
            try {
                this.create.invoke(testCase.getPOJO(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new TestCaseLifeCycleException("Cannot create test case", e.getCause());
            }
            catch (Exception e) {
                throw new TestCaseLifeCycleException("Cannot create test case", e);
            }
        }
    }

    @Override
    public void testCaseInvoke(TestCase _testCase) throws TestCaseLifeCycleException {
        TestCaseImpl testCase = (TestCaseImpl)_testCase;
        ArrayList<String> argList = new ArrayList<String>();
        for (String parameterName : testCase.def.arguments.keySet()) {
            if (!testCase.parametrization.containsKey(parameterName)) {
                throw new TestCaseLifeCycleException("Missing parameter " + parameterName);
            }
            String parameterValue = testCase.parametrization.get(parameterName);
            if (parameterValue == null) {
                throw new IllegalArgumentException();
            }
            argList.add(parameterValue);
        }
        Object[] args = argList.toArray();
        try {
            testCase.def.method.invoke(testCase.pojo, args);
        }
        catch (InvocationTargetException e) {
            throw new TestCaseLifeCycleException("Cannot invoke test case", e.getCause());
        }
        catch (Exception e) {
            throw new TestCaseLifeCycleException("Cannot invoke test case", e);
        }
    }

    @Override
    public void testCaseDestroy(TestCase _testCase) {
        TestCaseImpl testCase = (TestCaseImpl)_testCase;
        if (this.destroy != null) {
            try {
                this.destroy.invoke(testCase.getPOJO(), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

