/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.filter;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.runner.TestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTestFilter
implements TestFilter {
    private List<TestFilter> includeFilters = new LinkedList<TestFilter>();
    private List<TestFilter> excludeFilters = new LinkedList<TestFilter>();

    public MainTestFilter() {
    }

    public MainTestFilter(List<TestFilter> matchFilters, List<TestFilter> excludeFilters) {
        if (matchFilters == null) {
            throw new IllegalArgumentException("includeFilters cannot be null");
        }
        if (excludeFilters == null) {
            throw new IllegalArgumentException("excludeFilters cannot be null");
        }
        this.includeFilters = matchFilters;
        this.excludeFilters = excludeFilters;
    }

    @Override
    public boolean include(TestId testId, TestInfo testInfo) {
        for (TestFilter ef : this.excludeFilters) {
            if (ef.include(testId, testInfo)) continue;
            return false;
        }
        for (TestFilter mf : this.includeFilters) {
            if (!mf.include(testId, testInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean include(TestId testId, Map<String, String> parametrization, TestInfo testInfo) {
        return this.include(testId, testInfo);
    }

    public void addIncludeFilter(TestFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        this.includeFilters.add(filter);
    }

    public void addExcludeFilter(TestFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        this.excludeFilters.add(filter);
    }
}

