/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.VirtualFileHandlerVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSContext
implements VFSContext {
    protected final Logger log = Logger.getLogger(this.getClass());
    private VFS vfs;
    private final URI rootURI;
    private Map<String, String> rootOptions;
    private VirtualFileHandler rootPeer;

    protected AbstractVFSContext(URI rootURI) {
        if (rootURI == null) {
            throw new IllegalArgumentException("Null rootURI");
        }
        this.rootURI = rootURI;
        String query = rootURI.getQuery();
        this.rootOptions = VFSUtils.parseURLQuery(query);
    }

    protected AbstractVFSContext(URL rootURL) throws URISyntaxException {
        this(rootURL.toURI());
    }

    @Override
    public VFS getVFS() {
        if (this.vfs == null) {
            this.vfs = new VFS(this);
        }
        return this.vfs;
    }

    @Override
    public URI getRootURI() {
        return this.rootURI;
    }

    public void setRootPeer(VirtualFileHandler handler) {
        this.rootPeer = handler;
    }

    @Override
    public VirtualFileHandler getRootPeer() {
        return this.rootPeer;
    }

    protected void addOption(String key, String value) {
        this.rootOptions.put(key, value);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.rootOptions;
    }

    @Override
    public List<VirtualFileHandler> getChildren(VirtualFileHandler parent, boolean ignoreErrors) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        return parent.getChildren(ignoreErrors);
    }

    @Override
    public VirtualFileHandler getChild(VirtualFileHandler parent, String path) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        return parent.getChild(path);
    }

    public URL getChildURL(VirtualFileHandler parent, String name) throws IOException {
        StringBuilder urlStr = new StringBuilder(256);
        URI rootUri = this.getRootURI();
        urlStr.append(rootUri.getScheme()).append(":").append(rootUri.getPath());
        if (parent != null) {
            String pPathName = null;
            pPathName = parent instanceof AbstractVirtualFileHandler ? ((AbstractVirtualFileHandler)parent).getLocalPathName() : parent.getPathName();
            if (urlStr.charAt(urlStr.length() - 1) != '/') {
                urlStr.append("/");
            }
            if (pPathName.length() != 0) {
                urlStr.append(pPathName);
            }
            if (urlStr.charAt(urlStr.length() - 1) != '/') {
                urlStr.append("/");
            }
            urlStr.append(name);
        }
        return new URL(urlStr.toString());
    }

    @Override
    public void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        VisitorAttributes attributes = visitor.getAttributes();
        boolean includeRoot = attributes.isIncludeRoot();
        boolean leavesOnly = attributes.isLeavesOnly();
        boolean ignoreErrors = attributes.isIgnoreErrors();
        boolean includeHidden = attributes.isIncludeHidden();
        VirtualFileFilter recurseFilter = attributes.getRecurseFilter();
        this.visit(handler, visitor, includeRoot, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
    }

    protected void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor, boolean includeRoot, boolean leavesOnly, boolean ignoreErrors, boolean includeHidden, VirtualFileFilter recurseFilter) throws IOException {
        List<VirtualFileHandler> children;
        if (includeRoot) {
            visitor.visit(handler);
        }
        boolean trace = this.log.isTraceEnabled();
        try {
            children = this.getChildren(handler, ignoreErrors);
        }
        catch (IOException e) {
            if (!ignoreErrors) {
                throw e;
            }
            if (trace) {
                this.log.trace((Object)("Ignored: " + e));
            }
            return;
        }
        for (VirtualFileHandler child : children) {
            if (!includeHidden && child.isHidden()) {
                if (!trace) continue;
                this.log.trace((Object)("Ignoring hidden file: " + child));
                continue;
            }
            boolean isLeaf = child.isLeaf();
            if (!leavesOnly || isLeaf) {
                visitor.visit(child);
            } else if (trace) {
                this.log.trace((Object)("Skipping non-leaf file: " + child));
            }
            VirtualFile file = child.getVirtualFile();
            if (isLeaf || recurseFilter == null || !recurseFilter.accepts(file)) continue;
            try {
                if (handler instanceof DelegatingHandler) {
                    child.getVFSContext().visit(child, visitor);
                    continue;
                }
                this.visit(child, visitor, false, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
            }
            catch (StackOverflowError e) {
                this.log.debug((Object)("Original: " + child), (Throwable)e);
                throw new IOException("Stack overflow, the file system is too complicated? " + child);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('[');
        buffer.append(this.rootURI);
        buffer.append(']');
        return buffer.toString();
    }

    public int hashCode() {
        return this.rootURI.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VFSContext)) {
            return false;
        }
        VFSContext other = (VFSContext)obj;
        return this.rootURI.equals(other.getRootURI());
    }
}

