/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.memory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.memory.MemoryContext;
import org.jboss.virtual.plugins.context.memory.MemoryContextHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextFactory;

public class MemoryContextFactory
implements VFSContextFactory {
    private static final String[] PROTOCOLS = new String[]{"vfsmemory"};
    private static MemoryContextFactory instance = new MemoryContextFactory();
    private Map<String, MemoryContext> registry = new ConcurrentHashMap<String, MemoryContext>();

    private MemoryContextFactory() {
    }

    public static MemoryContextFactory getInstance() {
        return instance;
    }

    public String[] getProtocols() {
        return PROTOCOLS;
    }

    public VFSContext getVFS(URL rootURL) throws IOException {
        return this.createRoot(rootURL);
    }

    public VFSContext getVFS(URI rootURI) throws IOException {
        return this.createRoot(rootURI.toURL());
    }

    public VFS find(String host) {
        MemoryContext context = this.registry.get(host);
        return context != null ? context.getVFS() : null;
    }

    public VFSContext createRoot(URL url) {
        try {
            if (url.getPath() != null && url.getPath().length() > 0) {
                throw new IllegalArgumentException("Root can not contain '/'");
            }
            String rootName = url.getHost();
            MemoryContext ctx = this.registry.get(rootName);
            if (ctx == null) {
                URL ctxURL = new URL("vfsmemory://" + rootName);
                ctx = new MemoryContext(ctxURL);
                this.registry.put(rootName, ctx);
            }
            return ctx;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile createDirectory(URL url) {
        String rootName = url.getHost();
        MemoryContext ctx = this.registry.get(rootName);
        if (ctx == null) {
            throw new IllegalArgumentException("No MemoryContext exists for " + rootName);
        }
        return ctx.createDirectory(url);
    }

    public VirtualFile putFile(URL url, byte[] contents) {
        String rootName = url.getHost();
        MemoryContext ctx = this.registry.get(rootName);
        if (ctx == null) {
            throw new RuntimeException("No MemoryContext exists for " + rootName);
        }
        return ctx.putFile(url, contents);
    }

    public boolean deleteRoot(URL url) {
        if (url.getPath() != null && url.getPath().length() > 0) {
            throw new IllegalArgumentException("Root can not contain '/'");
        }
        String rootName = url.getHost();
        return this.registry.remove(rootName) != null;
    }

    public boolean delete(URL url) {
        try {
            if (url.getPath() == null || url.getPath().length() == 0) {
                return this.deleteRoot(url);
            }
            String rootName = url.getHost();
            MemoryContext ctx = this.registry.get(rootName);
            if (ctx != null) {
                MemoryContextHandler child = (MemoryContextHandler)ctx.getChild(ctx.getRoot(), url.getPath());
                MemoryContextHandler parent = (MemoryContextHandler)child.getParent();
                return parent.deleteChild(child);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

