/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.zip.SizeLimitedInputStream;
import org.jboss.virtual.plugins.context.zip.ZipEntryHandler;
import org.jboss.virtual.plugins.context.zip.ZipEntryWrapper;
import org.jboss.virtual.plugins.context.zip.ZipFileWrapper;
import org.jboss.virtual.plugins.context.zip.ZipStreamWrapper;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;
import org.jboss.virtual.plugins.copy.AbstractCopyMechanism;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryContext
extends AbstractVFSContext {
    private static final Logger log = Logger.getLogger(ZipEntryContext.class);
    private static boolean forceCopy;
    private ZipWrapper zipSource;
    private String rootEntryPath = "";
    private boolean autoClean = false;
    private Map<String, EntryInfo> entries = new ConcurrentHashMap<String, EntryInfo>();

    public ZipEntryContext(URL rootURL) throws URISyntaxException, IOException {
        this(rootURL, false);
    }

    public ZipEntryContext(URL rootURL, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(rootURL, null, null);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, URL localRootUrl) throws URISyntaxException, IOException {
        this(rootURL, peer, localRootUrl, false);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, URL localRootUrl, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(localRootUrl, peer, null);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, ZipWrapper zipWrapper, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(null, peer, zipWrapper);
    }

    private void init(URL localRootURL, VirtualFileHandler peer, ZipWrapper zipWrapper) throws IOException, URISyntaxException {
        int namePos;
        if (zipWrapper == null) {
            if (localRootURL == null) {
                throw new IllegalArgumentException("No ZipWrapper specified and localRootURL is null");
            }
            String rootPath = this.initRootAndPath(localRootURL);
            this.zipSource = this.createZipSource(rootPath);
        } else {
            this.zipSource = zipWrapper;
        }
        this.setRootPeer(peer);
        String name = this.getRootURI().toString();
        int toPos = name.length();
        if (name.length() != 0 && name.charAt(name.length() - 1) == '/') {
            --toPos;
        }
        if ((name = name.substring((namePos = name.lastIndexOf("/", toPos - 1)) + 1, toPos)).length() != 0 && name.charAt(name.length() - 1) == '!') {
            name = name.substring(0, name.length() - 1);
        }
        this.entries.put("", new EntryInfo(new ZipEntryHandler(this, null, name, true), null));
        this.initEntries();
    }

    protected ZipWrapper createZipSource(String rootPath) throws IOException {
        File file = null;
        String relative = null;
        File fp = new File(rootPath);
        if (fp.exists()) {
            file = fp;
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    file = curr;
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        if (file == null) {
            throw new IOException("VFS file does not exist: " + rootPath);
        }
        if (relative != null) {
            return ZipEntryContext.findEntry(new FileInputStream(file), relative);
        }
        boolean noReaper = Boolean.valueOf(this.getOptions().get("noReaper"));
        return new ZipFileWrapper(file, this.autoClean, noReaper);
    }

    protected static ZipWrapper findEntry(InputStream is, String relative) throws IOException {
        String entryName;
        ZipEntry entry;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipEntryContext.copyStreamAndClose(is, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ZipInputStream zis = new ZipInputStream(bais);
        String longestNameMatch = null;
        while ((entry = zis.getNextEntry()) != null) {
            entryName = entry.getName();
            if (!relative.startsWith(entryName)) continue;
            if (entryName.equals(relative)) {
                SizeLimitedInputStream stream = new SizeLimitedInputStream(zis, entry.getSize());
                if (entry.isDirectory() || !JarUtils.isArchive(entryName)) {
                    return new ZipEntryWrapper(stream, entryName, System.currentTimeMillis());
                }
                return new ZipStreamWrapper(stream, entryName, System.currentTimeMillis());
            }
            if (longestNameMatch != null && longestNameMatch.length() >= entryName.length()) continue;
            longestNameMatch = entryName;
        }
        if (longestNameMatch == null) {
            throw new IllegalArgumentException("Cannot find entry: " + is + ", " + relative);
        }
        bais.reset();
        zis = new ZipInputStream(bais);
        while ((entry = zis.getNextEntry()) != null) {
            entryName = entry.getName();
            if (!entryName.equals(longestNameMatch)) continue;
            relative = relative.substring(longestNameMatch.length() + 1);
            return ZipEntryContext.findEntry(new SizeLimitedInputStream(zis, entry.getSize()), relative);
        }
        throw new IllegalArgumentException("No such entry: " + is + ", " + relative);
    }

    @Override
    public String getName() {
        VirtualFileHandler peer = this.getRootPeer();
        if (peer != null) {
            return peer.getName();
        }
        return this.zipSource.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initEntries() throws IOException, URISyntaxException {
        HashMap<String, ZipEntry> relevant = new HashMap<String, ZipEntry>();
        this.zipSource.acquire();
        try {
            Enumeration<? extends ZipEntry> zipEntries = this.zipSource.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ent = zipEntries.nextElement();
                if (!ent.getName().startsWith(this.rootEntryPath)) continue;
                relevant.put(ent.getName(), ent);
            }
            TreeMap orderedRelevant = new TreeMap(relevant);
            for (Map.Entry entry : orderedRelevant.entrySet()) {
                AbstractVirtualFileHandler parent;
                ZipEntry ent = (ZipEntry)entry.getValue();
                String fullName = ent.getName().substring(this.rootEntryPath.length());
                String[] split = ZipEntryContext.splitParentChild(fullName);
                String parentPath = split[0];
                String name = split[1];
                EntryInfo ei = this.entries.get(parentPath);
                if (ei == null) {
                    ei = this.makeDummyParent(parentPath);
                }
                AbstractVirtualFileHandler abstractVirtualFileHandler = parent = ei != null ? ei.handler : null;
                if (!ent.isDirectory() && JarUtils.isArchive(ent.getName())) {
                    DelegatingHandler delegator;
                    boolean useCopyMode = forceCopy;
                    if (!useCopyMode) {
                        String flag = this.getOptions().get("useCopyJarHandler");
                        useCopyMode = Boolean.valueOf(flag);
                    }
                    if (useCopyMode) {
                        File dest = new File(ZipEntryContext.getTempDir() + "/" + ZipEntryContext.getTempFileName(ent.getName()));
                        dest.deleteOnExit();
                        dest.getParentFile().mkdirs();
                        InputStream is = this.zipSource.openStream(ent);
                        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
                        ZipEntryContext.copyStreamAndClose(is, os);
                        delegator = this.mountZipFile(parent, name, dest);
                    } else {
                        delegator = this.mountZipStream(parent, name, this.zipSource.openStream(ent));
                    }
                    this.entries.put(delegator.getLocalPathName(), new EntryInfo(delegator, ent));
                    this.addChild(parent, delegator);
                    continue;
                }
                ZipEntryHandler wrapper = new ZipEntryHandler(this, parent, name, !ent.isDirectory());
                this.entries.put(wrapper.getLocalPathName(), new EntryInfo(wrapper, ent));
            }
        }
        finally {
            this.zipSource.release();
        }
    }

    protected DelegatingHandler mountZipFile(VirtualFileHandler parent, String name, File file) throws IOException, URISyntaxException {
        URL fileUrl;
        DelegatingHandler delegator = new DelegatingHandler(this, parent, name);
        URL delegatorUrl = fileUrl = file.toURL();
        if (parent != null) {
            delegatorUrl = this.getChildURL(parent, name);
        }
        ZipEntryContext ctx = new ZipEntryContext(delegatorUrl, (VirtualFileHandler)delegator, fileUrl, true);
        VirtualFileHandler handler = ctx.getRoot();
        delegator.setDelegate(handler);
        return delegator;
    }

    protected DelegatingHandler mountZipStream(VirtualFileHandler parent, String name, InputStream zipStream) throws IOException, URISyntaxException {
        DelegatingHandler delegator = new DelegatingHandler(this, parent, name);
        ZipStreamWrapper wrapper = new ZipStreamWrapper(zipStream, name, parent.getLastModified());
        URL delegatorUrl = null;
        if (parent != null) {
            delegatorUrl = this.getChildURL(parent, name);
        }
        ZipEntryContext ctx = new ZipEntryContext(delegatorUrl, (VirtualFileHandler)delegator, wrapper, false);
        VirtualFileHandler handler = ctx.getRoot();
        delegator.setDelegate(handler);
        return delegator;
    }

    private EntryInfo makeDummyParent(String parentPath) throws IOException {
        String[] split = ZipEntryContext.splitParentChild(parentPath);
        String grandPa = split[0];
        EntryInfo eiParent = this.entries.get(grandPa);
        if (eiParent == null) {
            eiParent = this.makeDummyParent(grandPa);
        }
        ZipEntryHandler handler = new ZipEntryHandler(this, eiParent.handler, split[1], false);
        EntryInfo ei = new EntryInfo(handler, null);
        this.entries.put(parentPath, ei);
        return ei;
    }

    private String initRootAndPath(URL localRootUrl) {
        int queryStart;
        String filePath;
        String zipPath = filePath = localRootUrl.toString();
        int pos = filePath.indexOf("!");
        if (pos > 0) {
            zipPath = filePath.substring(0, pos);
            this.rootEntryPath = filePath.substring(pos + 2);
            if (this.rootEntryPath.length() != 0) {
                this.rootEntryPath = this.rootEntryPath + "/";
            }
        }
        if ((queryStart = (filePath = zipPath.substring((pos = zipPath.indexOf(":/")) + 2)).indexOf("?")) != -1) {
            filePath = filePath.substring(0, queryStart);
        }
        return filePath;
    }

    private synchronized void checkIfModified() {
        if (this.zipSource.hasBeenModified()) {
            EntryInfo rootInfo = this.entries.get("");
            this.entries = new ConcurrentHashMap<String, EntryInfo>();
            this.entries.put("", rootInfo);
            if (this.zipSource.exists()) {
                try {
                    this.initEntries();
                }
                catch (Exception ignored) {
                    log.warn((Object)("IGNORING: Failed to reinitialize context: " + this.getRootURI()), (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public VirtualFileHandler getRoot() throws IOException {
        return this.entries.get("").handler;
    }

    public VirtualFileHandler getChild(ZipEntryHandler parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.checkIfModified();
        String pathName = parent.getLocalPathName();
        pathName = "".equals(pathName) ? name : pathName + "/" + name;
        EntryInfo ei = this.entries.get(pathName);
        if (ei != null) {
            return ei.handler;
        }
        return null;
    }

    @Override
    public List<VirtualFileHandler> getChildren(VirtualFileHandler parent, boolean ignoreErrors) throws IOException {
        AbstractVirtualFileHandler parentHandler;
        EntryInfo parentEntry;
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.checkIfModified();
        if (parent instanceof AbstractVirtualFileHandler && (parentEntry = this.entries.get((parentHandler = (AbstractVirtualFileHandler)parent).getLocalPathName())) != null) {
            if (parentEntry.handler instanceof DelegatingHandler) {
                return parentEntry.handler.getChildren(ignoreErrors);
            }
            return parentEntry.getChildren();
        }
        return Collections.emptyList();
    }

    public long getLastModified(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.checkIfModified();
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        if (ei == null) {
            return 0L;
        }
        if (ei.entry == null) {
            return this.zipSource.getLastModified();
        }
        return ei.entry.getTime();
    }

    public long getSize(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.checkIfModified();
        String pathName = handler.getLocalPathName();
        EntryInfo ei = this.entries.get(pathName);
        if (ei == null) {
            return 0L;
        }
        if (ei.entry == null) {
            if (pathName.length() == 0) {
                return this.zipSource.getSize();
            }
            return 0L;
        }
        return ei.entry.getSize();
    }

    public boolean exists(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.checkIfModified();
        String pathName = handler.getLocalPathName();
        EntryInfo ei = this.entries.get(pathName);
        if (ei == null) {
            return false;
        }
        if (ei.entry == null && pathName.length() == 0) {
            return this.zipSource.exists();
        }
        return true;
    }

    public boolean isLeaf(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.checkIfModified();
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        if (ei == null || ei.entry == null) {
            return false;
        }
        return !ei.entry.isDirectory();
    }

    static boolean isArchive(VirtualFileHandler handler) {
        if (handler instanceof ZipEntryHandler && "".equals(handler.getLocalPathName())) {
            return true;
        }
        return handler instanceof DelegatingHandler && ((DelegatingHandler)handler).getDelegate() instanceof ZipEntryHandler;
    }

    static VirtualFileHandler getParent(VirtualFileHandler handler) throws IOException {
        VirtualFileHandler peer;
        VirtualFileHandler parent = handler.getParent();
        if (parent == null && (peer = handler.getVFSContext().getRootPeer()) != null) {
            parent = peer.getParent();
        }
        return parent;
    }

    static boolean isNested(VirtualFileHandler handler) throws IOException {
        VirtualFileHandler parent = ZipEntryContext.getParent(handler);
        while (parent != null) {
            if (ZipEntryContext.isArchive(parent)) {
                return true;
            }
            parent = ZipEntryContext.getParent(parent);
        }
        return false;
    }

    public InputStream openStream(ZipEntryHandler handler) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.checkIfModified();
        String localPathName = handler.getLocalPathName();
        EntryInfo ei = this.entries.get(localPathName);
        if (ei == null) {
            String uriStr;
            try {
                uriStr = handler.toURI().toString();
            }
            catch (Exception ex) {
                throw new RuntimeException("ASSERTION ERROR - uri generation failed for ZipEntryHandler: " + handler, ex);
            }
            throw new FileNotFoundException(uriStr);
        }
        if (ei.entry == null) {
            if ("".equals(localPathName)) {
                return this.zipSource.getRootAsStream();
            }
            return new ByteArrayInputStream(new byte[0]);
        }
        return this.zipSource.openStream(ei.entry);
    }

    public void addChild(AbstractVirtualFileHandler parent, AbstractVirtualFileHandler child) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        EntryInfo parentEntry = this.entries.get(parent.getLocalPathName());
        if (parentEntry == null) {
            throw new RuntimeException("Parent does not exist: " + parent);
        }
        parentEntry.add(child);
    }

    protected void finalize() {
        try {
            super.finalize();
            if (this.zipSource != null) {
                this.zipSource.close();
            }
        }
        catch (Throwable ignored) {
            log.debug((Object)("IGNORING: Failed to close zip source: " + this.zipSource), ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceChild(ZipEntryHandler parent, AbstractVirtualFileHandler original, VirtualFileHandler replacement) {
        EntryInfo parentEntry = this.entries.get(parent.getLocalPathName());
        if (parentEntry != null) {
            DelegatingHandler newOne = replacement instanceof DelegatingHandler ? (DelegatingHandler)replacement : new DelegatingHandler(this, parent, original.getName(), replacement);
            ZipEntryContext zipEntryContext = this;
            synchronized (zipEntryContext) {
                parentEntry.replaceChild(original, newOne);
                EntryInfo ei = this.entries.get(original.getLocalPathName());
                ei.handler = newOne;
                ei.entry = null;
                ei.clearChildren();
            }
        } else {
            throw new RuntimeException("Parent does not exist: " + parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyStreamAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] buff = new byte[65536];
            int count = is.read(buff);
            while (count != -1) {
                os.write(buff, 0, count);
                count = is.read(buff);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            os.close();
        }
    }

    private static URL fixUrl(URL rootURL) throws MalformedURLException {
        if (!"vfszip".equals(rootURL.getProtocol())) {
            String url = rootURL.toString();
            int pos = url.indexOf(":/");
            if (pos != -1) {
                url = url.substring(pos);
            }
            return new URL("vfszip" + url);
        }
        return rootURL;
    }

    public static String[] splitParentChild(String pathName) {
        int delimPos;
        if (pathName.length() == 0) {
            return new String[]{null, pathName};
        }
        int toPos = pathName.length();
        if (pathName.charAt(pathName.length() - 1) == '/') {
            --toPos;
        }
        String[] ret = (delimPos = pathName.lastIndexOf(47, toPos - 1)) == -1 ? new String[]{"", pathName.substring(delimPos + 1, toPos)} : new String[]{pathName.substring(0, delimPos), pathName.substring(delimPos + 1, toPos)};
        return ret;
    }

    private static String getTempFileName(String name) {
        int delim = name.lastIndexOf("/");
        if (delim != -1) {
            name = name.substring(delim + 1);
        }
        return UUID.randomUUID().toString().substring(0, 8) + "_" + name;
    }

    private static String getTempDir() {
        File dir = new File(AbstractCopyMechanism.getTempDirectory(), "vfs-nested.tmp");
        return dir.toString();
    }

    private static void deleteTmpDirContents() {
        try {
            File tmpDir = new File(ZipEntryContext.getTempDir());
            File[] files = tmpDir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (file.isDirectory() || file.isHidden()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ZipEntryContext.deleteTmpDirContents();
        forceCopy = AccessController.doPrivileged(new CheckForceCopy());
        if (forceCopy) {
            log.info((Object)"VFS force nested jars copy-mode is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceCopy
    implements PrivilegedAction<Boolean> {
        private CheckForceCopy() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceCopy", "false");
            return Boolean.valueOf(forceString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryInfo {
        private AbstractVirtualFileHandler handler;
        private ZipEntry entry;
        private List<AbstractVirtualFileHandler> children;

        EntryInfo(AbstractVirtualFileHandler handler, ZipEntry entry) {
            this.handler = handler;
            this.entry = entry;
        }

        public synchronized List<VirtualFileHandler> getChildren() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return new LinkedList<VirtualFileHandler>(this.children);
        }

        public synchronized void replaceChild(AbstractVirtualFileHandler original, AbstractVirtualFileHandler replacement) {
            if (this.children != null) {
                int i = 0;
                for (AbstractVirtualFileHandler child : this.children) {
                    if (child.getName().equals(original.getName())) {
                        this.children.set(i, replacement);
                        break;
                    }
                    ++i;
                }
            }
        }

        public synchronized void clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        public synchronized void add(AbstractVirtualFileHandler child) {
            if (this.children == null) {
                this.children = new LinkedList<AbstractVirtualFileHandler>();
            } else {
                Iterator<AbstractVirtualFileHandler> it = this.children.iterator();
                while (it.hasNext()) {
                    AbstractVirtualFileHandler handler = it.next();
                    if (!handler.getName().equals(child.getName())) continue;
                    it.remove();
                    break;
                }
            }
            this.children.add(child);
        }
    }
}

