/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.HierarchyVirtualFileHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.jar.NestedJarFromStream;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarEntryContents
extends AbstractJarHandler
implements StructuredVirtualFileHandler,
HierarchyVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private URL entryURL;
    private byte[] contents;
    private boolean isJar;
    private NestedJarFromStream njar;
    private InputStream openStream;
    private List<VirtualFileHandler> entryChildren;
    private transient Map<String, VirtualFileHandler> entryMap;

    JarEntryContents(VFSContext context, VirtualFileHandler parent, ZipEntry entry, String entryName, URL jarURL, URL entryURL, byte[] contents) throws IOException {
        super(context, parent, jarURL, null, entry, entryName);
        try {
            this.setPathName(this.getChildPathName(entryName, false));
            this.setVfsUrl(this.getChildVfsUrl(entryName, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.entryURL = entryURL;
        this.isJar = JarUtils.isArchive(this.getName());
        this.contents = contents;
    }

    @Override
    protected void initCacheLastModified() {
    }

    @Override
    public synchronized void addChild(VirtualFileHandler child) {
        if (this.entryChildren == null) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        this.entryChildren.add(child);
        if (this.entryMap != null) {
            this.entryMap.put(child.getName(), child);
        }
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isHidden() throws IOException {
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return true;
    }

    byte[] getContents() {
        return this.contents;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        List<VirtualFileHandler> children;
        if (this.isJar) {
            this.initNestedJar();
            children = this.njar.getChildren(ignoreErrors);
        } else {
            children = this.entryChildren;
        }
        if (children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(children);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        if (this.isJar) {
            this.initNestedJar();
            return this.njar.createChildHandler(name);
        }
        return this.findChildHandler(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if ("".equals(path)) {
            return this;
        }
        if (this.isJar) {
            this.initNestedJar();
            return this.njar.getChild(path);
        }
        if (this.getEntry().isDirectory()) {
            return this.structuredFindChild(path);
        }
        return null;
    }

    protected synchronized VirtualFileHandler findChildHandler(String name) throws IOException {
        if (this.entryChildren == null) {
            return null;
        }
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, VirtualFileHandler>();
            for (VirtualFileHandler child : this.entryChildren) {
                this.entryMap.put(child.getName(), child);
            }
        }
        return this.entryMap.get(name);
    }

    @Override
    public long getLastModified() {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() {
        return this.getEntry().getSize();
    }

    @Override
    public boolean isLeaf() {
        return !this.isJar && !this.getEntry().isDirectory();
    }

    @Override
    public synchronized InputStream openStream() throws IOException {
        this.initNestedJar();
        this.openStream = this.njar != null ? this.njar.openStream() : new ByteArrayInputStream(this.contents);
        return this.openStream;
    }

    @Override
    public synchronized void close() {
        if (this.openStream != null) {
            try {
                this.openStream.close();
            }
            catch (IOException e) {
                log.error((Object)"close error", (Throwable)e);
            }
            this.openStream = null;
        }
    }

    @Override
    public URI toURI() throws URISyntaxException {
        return this.entryURL.toURI();
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        if (this.isJar) {
            this.njar.internalReplaceChild(original, replacement);
        } else {
            this.entryChildren.remove(original);
            this.entryChildren.add(replacement);
            this.entryMap.put(original.getName(), replacement);
        }
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append("name=");
        tmp.append(this.getName());
        tmp.append(",size=");
        tmp.append(this.getSize());
        tmp.append(",time=");
        tmp.append(this.getLastModified());
        tmp.append(",URI=");
        try {
            tmp.append(this.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        tmp.append(']');
        return tmp.toString();
    }

    protected synchronized void initNestedJar() throws IOException {
        if (this.isJar && this.njar == null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
            ZipInputStream zis = new ZipInputStream(bais);
            this.njar = new NestedJarFromStream(this.getVFSContext(), this.getParent(), zis, this.entryURL, null, this.getEntry(), this.getName());
        }
    }
}

