/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileFilterWithAttributes;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterVirtualFileVisitor
extends AbstractVirtualFileVisitor {
    private final VirtualFileFilter filter;
    private List<VirtualFile> matched;

    private static VisitorAttributes checkAttributes(VirtualFileFilter filter, VisitorAttributes attributes) {
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        if (attributes != null) {
            return attributes;
        }
        if (filter instanceof VirtualFileFilterWithAttributes) {
            return ((VirtualFileFilterWithAttributes)filter).getAttributes();
        }
        return null;
    }

    public FilterVirtualFileVisitor(VirtualFileFilter filter) {
        this(filter, null);
    }

    public FilterVirtualFileVisitor(VirtualFileFilter filter, VisitorAttributes attributes) {
        super(FilterVirtualFileVisitor.checkAttributes(filter, attributes));
        this.filter = filter;
    }

    public List<VirtualFile> getMatched() {
        if (this.matched == null) {
            return Collections.emptyList();
        }
        return this.matched;
    }

    @Override
    public void visit(VirtualFile virtualFile) {
        if (this.filter.accepts(virtualFile)) {
            if (this.matched == null) {
                this.matched = new ArrayList<VirtualFile>();
            }
            this.matched.add(virtualFile);
        }
    }
}

