/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.PathTokenizer;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public class VFSUtils {
    private static final Logger log = Logger.getLogger(VFSUtils.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String VFS_PROTOCOL = "vfs";
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private static final InputStream EMPTY_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");

    private VFSUtils() {
    }

    public static String getPathsString(Collection<VirtualFile> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Null paths");
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (VirtualFile path : paths) {
            if (path == null) {
                throw new IllegalArgumentException("Null path in " + paths);
            }
            if (!first) {
                buffer.append(':');
            } else {
                first = false;
            }
            buffer.append(path.getPathName());
        }
        if (first) {
            buffer.append("<empty>");
        }
        return buffer.toString();
    }

    public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Null paths");
        }
        boolean trace = log.isTraceEnabled();
        Manifest manifest = VFSUtils.getManifest(file);
        if (manifest == null) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        if (classPath == null) {
            if (trace) {
                log.trace((Object)("Manifest has no Class-Path for " + file.getPathName()));
            }
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            log.debug((Object)(file + " has no parent."));
            return;
        }
        if (trace) {
            log.trace((Object)("Parsing Class-Path: " + classPath + " for " + file.getName() + " parent=" + parent.getName()));
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                VirtualFile vf = parent.getChild(path);
                if (vf.exists()) {
                    if (!paths.contains(vf)) {
                        paths.add(vf);
                        Automounter.mount(file, vf, new MountOption[0]);
                        VFSUtils.addManifestLocations(vf, paths);
                        continue;
                    }
                    if (!trace) continue;
                    log.trace((Object)(vf.getName() + " from manifiest is already in the classpath " + paths));
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)("Unable to find " + path + " from " + parent.getName()));
            }
            catch (IOException e) {
                log.debug((Object)("Manifest Class-Path entry " + path + " ignored for " + file.getPathName() + " reason=" + e));
            }
        }
    }

    public static Manifest getManifest(VirtualFile archive) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException("Null archive");
        }
        VirtualFile manifest = archive.getChild("META-INF/MANIFEST.MF");
        if (manifest == null || !manifest.exists()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Can't find manifest for " + archive.getPathName()));
            }
            return null;
        }
        return VFSUtils.readManifest(manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest readManifest(VirtualFile manifest) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest file");
        }
        InputStream stream = manifest.openStream();
        try {
            Manifest manifest2 = new Manifest(stream);
            return manifest2;
        }
        finally {
            VFSUtils.safeClose((Closeable)stream);
        }
    }

    public static String fixName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        int length = name.length();
        if (length <= 1) {
            return name;
        }
        if (name.charAt(length - 1) == '/') {
            return name.substring(0, length - 1);
        }
        return name;
    }

    public static String decode(String path) {
        return VFSUtils.decode(path, DEFAULT_ENCODING);
    }

    public static String decode(String path, String encoding) {
        try {
            return URLDecoder.decode(path, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot decode: " + path + " [" + encoding + "]", e);
        }
    }

    public static String getName(URI uri) {
        int lastSlash;
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        String name = uri.getPath();
        if (name != null && (lastSlash = name.lastIndexOf(47)) > 0) {
            name = name.substring(lastSlash + 1);
        }
        return name;
    }

    public static Map<String, String> parseURLQuery(String query) {
        Map pairsMap = CollectionsFactory.createLazyMap();
        if (query != null) {
            StringTokenizer tokenizer = new StringTokenizer(query, "=&");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                pairsMap.put(name, value);
            }
        }
        return pairsMap;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            String urispec = url.toExternalForm();
            urispec = urispec.replaceAll("%", "%25");
            urispec = urispec.replaceAll(" ", "%20");
            return new URI(urispec);
        }
    }

    public static URL sanitizeURL(URL url) throws URISyntaxException, MalformedURLException {
        return VFSUtils.toURI(url).toURL();
    }

    public static void copyChildrenRecursive(VirtualFile original, VirtualFile target) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException("Original VirtualFile must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target VirtualFile must not be null");
        }
        List<VirtualFile> children = original.getChildren();
        for (VirtualFile child : children) {
            VirtualFile targetChild = target.getChild(child.getName());
            File childFile = child.getPhysicalFile();
            if (childFile.isDirectory()) {
                if (!targetChild.getPhysicalFile().mkdir()) {
                    throw new IllegalArgumentException("Problems creating new directory: " + targetChild);
                }
                VFSUtils.copyChildrenRecursive(child, targetChild);
                continue;
            }
            FileInputStream is = new FileInputStream(childFile);
            VFSUtils.writeFile(targetChild, is);
        }
    }

    public static void copyStreamAndClose(InputStream is, OutputStream os) throws IOException {
        VFSUtils.copyStreamAndClose(is, os, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamAndClose(InputStream is, OutputStream os, int bufferSize) throws IOException {
        try {
            VFSUtils.copyStream(is, os, bufferSize);
            is.close();
            os.close();
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
            VFSUtils.safeClose((Closeable)os);
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        VFSUtils.copyStream(is, os, 65536);
    }

    public static void copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int rc;
        if (is == null) {
            throw new IllegalArgumentException("input stream is null");
        }
        if (os == null) {
            throw new IllegalArgumentException("output stream is null");
        }
        byte[] buff = new byte[bufferSize];
        while ((rc = is.read(buff)) != -1) {
            os.write(buff, 0, rc);
        }
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(VirtualFile virtualFile, byte[] bytes) throws IOException {
        File file = virtualFile.getPhysicalFile();
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(bytes);
            fos.close();
        }
        finally {
            VFSUtils.safeClose((Closeable)fos);
        }
    }

    public static void writeFile(VirtualFile virtualFile, InputStream is) throws IOException {
        File file = virtualFile.getPhysicalFile();
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        VFSUtils.copyStreamAndClose(is, fos);
    }

    public static URL getVirtualURL(VirtualFile file) throws MalformedURLException {
        return new URL(VFS_PROTOCOL, "", -1, file.getPathName(true));
    }

    public static URI getVirtualURI(VirtualFile file) throws URISyntaxException {
        return new URI(VFS_PROTOCOL, "", file.getPathName(true), null);
    }

    public static URL getPhysicalURL(VirtualFile file) throws IOException {
        return VFSUtils.getPhysicalURI(file).toURL();
    }

    public static URI getPhysicalURI(VirtualFile file) throws IOException {
        return file.getPhysicalFile().toURI();
    }

    public static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.trace((Object)"Failed to close resource", (Throwable)e);
            }
        }
    }

    public static void safeClose(Closeable ... closeables) {
        VFSUtils.safeClose(Arrays.asList(closeables));
    }

    public static void safeClose(Iterable<? extends Closeable> ci) {
        if (ci != null) {
            for (Closeable closeable : ci) {
                VFSUtils.safeClose(closeable);
            }
        }
    }

    public static void safeClose(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Exception e) {
                log.trace((Object)"Failed to close resource", (Throwable)e);
            }
        }
    }

    public static boolean recursiveDelete(File root) {
        boolean ok = true;
        if (root.isDirectory()) {
            File[] files;
            for (File file : files = root.listFiles()) {
                ok &= VFSUtils.recursiveDelete(file);
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }

    public static boolean recursiveDelete(VirtualFile root) {
        boolean ok = true;
        if (root.isDirectory()) {
            List<VirtualFile> files = root.getChildren();
            for (VirtualFile file : files) {
                ok &= VFSUtils.recursiveDelete(file);
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(File original, File destDir) throws IOException {
        String name = original.getName();
        File destFile = new File(destDir, name);
        if (original.isDirectory()) {
            destFile.mkdir();
            for (File file : original.listFiles()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                FileInputStream is = new FileInputStream(original);
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(File original, VirtualFile destDir) throws IOException {
        String name = original.getName();
        File destFile = destDir.getChild(name).getPhysicalFile();
        if (original.isDirectory()) {
            destFile.mkdir();
            for (File file : original.listFiles()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                FileInputStream is = new FileInputStream(original);
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(VirtualFile original, File destDir) throws IOException {
        String name = original.getName();
        File destFile = new File(destDir, name);
        if (original.isDirectory()) {
            destFile.mkdir();
            for (VirtualFile file : original.getChildren()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                InputStream is = original.openStream();
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveCopy(VirtualFile original, VirtualFile destDir) throws IOException {
        String name = original.getName();
        File destFile = destDir.getChild(name).getPhysicalFile();
        if (original.isDirectory()) {
            destFile.mkdir();
            for (VirtualFile file : original.getChildren()) {
                VFSUtils.recursiveCopy(file, destFile);
            }
        } else {
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                InputStream is = original.openStream();
                VFSUtils.copyStreamAndClose(is, os);
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    public static InputStream emptyStream() {
        return EMPTY_STREAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            HashSet<File> createdDirs = new HashSet<File>();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            block9: while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                List<String> tokens = PathTokenizer.getTokens(name);
                Iterator<String> it = tokens.iterator();
                File current = destDir;
                while (it.hasNext()) {
                    String token = it.next();
                    if (PathTokenizer.isCurrentToken(token) || PathTokenizer.isReverseToken(token)) continue block9;
                    current = new File(current, token);
                    if (!it.hasNext() && !zipEntry.isDirectory() || !createdDirs.add(current)) continue;
                    current.mkdir();
                }
                if (zipEntry.isDirectory()) continue;
                InputStream is = zip.getInputStream(zipEntry);
                try {
                    FileOutputStream os = new FileOutputStream(current);
                    try {
                        VFSUtils.copyStream(is, os);
                        is.close();
                        os.close();
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)os);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)is);
                }
            }
        }
        finally {
            VFSUtils.safeClose(zip);
        }
    }

    public static Pattern getGlobPattern(String glob) {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        Matcher m = GLOB_PATTERN.matcher(glob);
        boolean lastWasSlash = false;
        while (m.find()) {
            lastWasSlash = false;
            String grp = m.group(1);
            if (grp != null) {
                if (grp.length() == 2) {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append("[^/]*");
                continue;
            }
            grp = m.group(2);
            if (grp != null) {
                patternBuilder.append("[^/]");
                continue;
            }
            grp = m.group(3);
            if (grp != null) {
                patternBuilder.append(grp.charAt(1));
                continue;
            }
            grp = m.group(4);
            if (grp != null) {
                patternBuilder.append("/+");
                lastWasSlash = true;
                continue;
            }
            patternBuilder.append(Pattern.quote(m.group()));
        }
        if (lastWasSlash) {
            patternBuilder.append(".*");
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }
}

