/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VFSUtils;

public final class TempDir
implements Closeable {
    private final TempFileProvider provider;
    private final File root;
    private final AtomicBoolean open = new AtomicBoolean(true);

    TempDir(TempFileProvider provider, File root) {
        this.provider = provider;
        this.root = root;
    }

    public File getRoot() throws IOException {
        if (!this.open.get()) {
            throw VFSMessages.MESSAGES.tempDirectoryClosed();
        }
        return this.root;
    }

    public File getFile(String relativePath) throws IOException {
        if (!this.open.get()) {
            throw VFSMessages.MESSAGES.tempDirectoryClosed();
        }
        return new File(this.root, relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createFile(String relativePath, InputStream sourceData) throws IOException {
        File tempFile = this.getFile(relativePath);
        boolean ok = false;
        try {
            File file;
            FileOutputStream fos = new FileOutputStream(tempFile);
            try {
                VFSUtils.copyStream(sourceData, fos);
                fos.close();
                sourceData.close();
                ok = true;
                file = tempFile;
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose((Closeable)fos);
                throw throwable;
            }
            VFSUtils.safeClose((Closeable)fos);
            return file;
        }
        finally {
            VFSUtils.safeClose((Closeable)sourceData);
            if (!ok) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.provider.delete();
        }
    }

    protected void finalize() throws Throwable {
        VFSUtils.safeClose((Closeable)this);
    }
}

