/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.cdiTck.container;

import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.core.impl.loadable.LoadableExtensionLoader;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ManagerBuilder;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.testharness.spi.Containers;

public class ArquillianContainerAdaptor
implements Containers {
    private DeployableContainer<ManagedContainerConfiguration> deployableContainer;
    private Container container;
    private ManagedContainerConfiguration configuration;
    private Archive<?> swArchive;
    private DeploymentException exception;
    private Manager manager;

    public void setup() throws IOException {
        this.deployableContainer = ArquillianContainerAdaptor.loadDeployableContainer();
        this.manager = ManagerBuilder.from().extension(LoadableExtensionLoader.class).create();
        ((ContainerContext)this.manager.getContext(ContainerContext.class)).activate((Object)"AS7 Managed");
        this.configuration = new ManagedContainerConfiguration();
        this.configuration.setJavaVmArguments(System.getProperty("jboss.options"));
        this.manager.inject(this.deployableContainer);
        this.deployableContainer.setup((ContainerConfiguration)this.configuration);
        try {
            this.deployableContainer.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() throws IOException {
        try {
            this.deployableContainer.stop();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deploy(InputStream archive, String name) throws IOException {
        this.exception = null;
        if (name.endsWith("ear")) {
            this.swArchive = (Archive)ShrinkWrap.create(EnterpriseArchive.class, (String)name);
        } else if (name.endsWith("war")) {
            this.swArchive = (Archive)ShrinkWrap.create(WebArchive.class, (String)name);
        } else if (name.endsWith("jar")) {
            this.swArchive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)name);
        } else {
            throw new RuntimeException("Unkown archive extension: " + name);
        }
        ((ZipImporter)this.swArchive.as(ZipImporter.class)).importFrom(archive);
        try {
            this.deployableContainer.deploy(this.swArchive);
            return true;
        }
        catch (DeploymentException e) {
            this.exception = e;
            return false;
        }
    }

    public org.jboss.testharness.api.DeploymentException getDeploymentException() {
        return new org.jboss.testharness.api.DeploymentException(this.exception.getCause().getClass().getName(), this.exception.getCause());
    }

    public void undeploy(String name) throws IOException {
        try {
            this.deployableContainer.undeploy(this.swArchive);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    private static final DeployableContainer loadDeployableContainer() {
        String arquillianContainer = System.getProperty("org.jboss.har2arq.container");
        if (arquillianContainer != null) {
            try {
                Class<?> clazz = Class.forName(arquillianContainer.trim());
                return (DeployableContainer)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ServiceLoader<DeployableContainer> container = ServiceLoader.load(DeployableContainer.class);
        HashSet<DeployableContainer> containers = new HashSet<DeployableContainer>();
        for (DeployableContainer aContainer : container) {
            containers.add(aContainer);
        }
        if (containers.isEmpty()) {
            throw new RuntimeException("No Arquillian DeployableContainer found on the class path.");
        }
        if (containers.size() > 1) {
            throw new RuntimeException("More than one DeployableContainer found on the class path. " + containers);
        }
        return (DeployableContainer)containers.iterator().next();
    }
}

