/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossas.cdiTck.container.jbossas;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class DatasourceManager
implements ITestListener {
    private static final String JNDI_NAME = "java:/DefaultDS";
    private volatile boolean dataSourceChecked = false;

    public void onTestStart(ITestResult testResult) {
        block8: {
            if (this.dataSourceChecked) {
                return;
            }
            this.dataSourceChecked = true;
            String test = System.getProperty("tckTest");
            try {
                ModelControllerClient client = ModelControllerClient.Factory.create((String)"localhost", (int)9999);
                ModelNode request = new ModelNode();
                request.get("operation").set("read-resource");
                request.get("address").get("subsystem").set("naming");
                request.get("recursive").set(false);
                ModelNode r = client.execute(new OperationBuilder(request).build());
                boolean found = false;
                ModelNode resultNode = r.get("result");
                if (resultNode.hasDefined("binding")) {
                    for (ModelNode dataSource : resultNode.get("binding").asList()) {
                        if (!dataSource.asProperty().getName().equals(JNDI_NAME)) continue;
                        found = true;
                    }
                }
                if (found) break block8;
                String create = System.getProperty("jboss.datasource.add");
                if (create != null && !create.equals("false")) {
                    request = new ModelNode();
                    request.get("address").add("subsystem", "naming");
                    request.get("address").add("binding", JNDI_NAME);
                    request.get("operation").set("add");
                    request.get("lookup").set("java:jboss/datasources/ExampleDS");
                    request.get("binding-type").set("lookup");
                    ModelNode result = client.execute(new OperationBuilder(request).build());
                    if (!result.get("outcome").asString().equals("success")) {
                        throw new RuntimeException("DataSource java:/DefaultDS was not found and could not be created automatically: " + result);
                    }
                    break block8;
                }
                if (test != null && !test.isEmpty()) {
                    return;
                }
                throw new RuntimeException("DataSource java:/DefaultDS was not found. This DataSource must be defined, or the TCK will hang half way through due to missing MSC dependencies. To create this DataSource automatically run the TCK with -Djboss.datasource.add=true");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }
}

