/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.adminclient.command;

import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.jboss.adminclient.AdminClientMain;
import org.jboss.adminclient.command.AbstractClientCommand;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;

public class ListComponentsCommand
extends AbstractClientCommand {
    public String getName() {
        return "listcomponents";
    }

    public OptionParser getOptionParser() {
        return new OptionParser();
    }

    public boolean execute(AdminClientMain client, OptionSet options) {
        Set components;
        List nonOptionArgs = options.nonOptionArguments();
        if (nonOptionArgs.size() != 2) {
            throw new IllegalArgumentException("Usage: " + this.getName() + " <type> <subtype>");
        }
        String type = (String)nonOptionArgs.get(0);
        String subtype = (String)nonOptionArgs.get(1);
        ManagementView managementView = client.getConnection().getManagementView();
        ComponentType componentType = new ComponentType(type, subtype);
        try {
            components = managementView.getComponentsForType(componentType);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ManagedComponent managedComponent : components) {
            client.getPrintWriter().println(managedComponent.getName());
        }
        return true;
    }

    public String getHelp() {
        return "List all components of the specified type.";
    }

    public String getDetailedHelp() {
        return null;
    }

    public boolean isConnectionRequired() {
        return true;
    }
}

