/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.asintegration.jboss5;

import java.io.File;

import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;

import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.mx.loading.RepositoryClassLoader;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class JBoss5Integration implements JBossIntegration, ScopedClassPoolFactory
{
   /** The delegate classpool factory */
   private ScopedClassPoolFactory delegateClassPoolFactory;
   private AOPClassLoaderScopingPolicy policy;
   private AspectManager manager = AspectManager.getTopLevelAspectManager();
   DefaultTranslator translator = new DefaultTranslator(manager);

   public void start()
   {
      getIntegrationStrategy().start();
   }

   public void stop()
   {
      getIntegrationStrategy().stop();
   }
   
   public boolean isValidClassLoader(ClassLoader loader)
   {
      boolean isValid = false;
      try
      {
         if(loader instanceof RealClassLoader)
         {
            isValid = ((RealClassLoader) loader).isValid();
         }
      }
      catch (RuntimeException e)
      {
         // Annoyingly, BaseClassLoader.isValid() throws an exception if the classloader is invalid
      }
      return isValid;
   }

   public void setScopingPolicy(AOPClassLoaderScopingPolicy policy)
   {
      this.policy = policy;
   }
   
   public AOPClassLoaderScopingPolicy getScopingPolicy()
   {
      return policy;
   }
   
   public AOPClassLoaderScopingPolicy createAOPClassLoaderScopingPolicy()
   {
      return policy;
   }

   public synchronized ScopedClassPoolFactory createScopedClassPoolFactory(File tmpDir) throws Exception
   {
      if (delegateClassPoolFactory == null)
      {
         delegateClassPoolFactory = getIntegrationStrategy().createScopedClassPoolFactory(tmpDir);
      }
      return this;
   }
   
   public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
   {
      return delegateClassPoolFactory.create(cl, src, repository);
   }

   public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository)
   {
      return delegateClassPoolFactory.create(src, repository);
   }
   
   public void attachDeprecatedTranslator()
   {
      getIntegrationStrategy().attachDeprecatedTranslator();
   }

   public void detachDeprecatedTranslator()
   {
      getIntegrationStrategy().detachDeprecatedTranslator();
   }
   
   private IntegrationStrategy integrationStrategy;
   private synchronized IntegrationStrategy getIntegrationStrategy()
   {
      if (integrationStrategy == null)
      {
         if (policy.getClass().getName().endsWith("RepositoryClassLoaderScopingPolicy"))
         {
            integrationStrategy = new RepositoryIntegrationStrategy();
         }
         else
         {
            integrationStrategy = new VFSIntegrationStrategy(manager);
         }
      }
      return integrationStrategy;
   }
}
