/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.stack.MetaDataStack;

public class MetaDataClassLoaderScopingPolicy
implements AOPClassLoaderScopingPolicy {
    static Logger log = Logger.getLogger(MetaDataClassLoaderScopingPolicy.class);
    private Map<ClassLoader, Domain> domainsByLoader = new WeakHashMap<ClassLoader, Domain>();

    public Domain getDomain(ClassLoader classLoader, AspectManager parent) {
        Domain domain;
        MetaData metaData = MetaDataStack.peek();
        if (metaData != null && (domain = (Domain)metaData.getMetaData(Domain.class)) != null) {
            this.registerDomain(classLoader, domain);
            return domain;
        }
        domain = this.getRegisteredDomain(classLoader);
        if (domain != null) {
            return domain;
        }
        return null;
    }

    public Domain getTopLevelDomain(AspectManager parent) {
        Thread.currentThread().getContextClassLoader();
        return null;
    }

    public boolean isScoped(ClassLoader classLoader) {
        return false;
    }

    private synchronized void registerDomain(ClassLoader cl, Domain domain) {
        Domain found = this.domainsByLoader.get(cl);
        if (found == null) {
            this.domainsByLoader.put(cl, domain);
        }
        if (found != domain) {
            log.warn((Object)"Several domains being used for a particular classloader");
        }
    }

    private synchronized Domain getRegisteredDomain(ClassLoader cl) {
        return this.domainsByLoader.get(cl);
    }
}

