/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss5.JBoss5ClassPool;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;

public class ScopedJBoss5ClassPool
extends JBoss5ClassPool {
    Logger log = Logger.getLogger(ScopedJBoss5ClassPool.class);
    ThreadLocal<ClassPool> lastPool = new ThreadLocal();
    WeakReference<ClassLoaderDomain> domainRef;

    public ScopedJBoss5ClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, URL tmpURL, boolean parentFirst, ClassLoaderDomain domain) {
        super(cl, src, repository, tmpURL);
        this.childFirstLookup = !parentFirst;
        this.domainRef = new WeakReference<ClassLoaderDomain>(domain);
    }

    private URL getResourceUrlForClass(String resourcename) {
        ClassLoaderDomain domain = (ClassLoaderDomain)this.domainRef.get();
        return domain.getResource(resourcename);
    }

    private boolean isMine(URL myURL, String resourceName) {
        if (myURL == null) {
            return false;
        }
        ClassLoaderDomain domain = (ClassLoaderDomain)this.domainRef.get();
        Loader parent = domain.getParent();
        URL parentURL = parent.getResource(resourceName);
        if (parentURL == null) {
            return true;
        }
        return !myURL.equals(parentURL);
    }

    public CtClass getCached(String classname) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("getCached() " + classname));
        }
        if (classname == null) {
            if (trace) {
                this.log.trace((Object)"getCached() returning null (classname == null)");
            }
            return null;
        }
        if (this.isUnloadedClassLoader()) {
            if (trace) {
                this.log.trace((Object)"getCached() returning null (unloaded)");
            }
            return null;
        }
        if (this.generatedClasses.get(classname) != null) {
            if (trace) {
                this.log.trace((Object)"getCached() In generated classes - check super");
            }
            return super.getCached(classname);
        }
        String resourcename = this.getResourceName(classname);
        URL url = this.getResourceUrlForClass(resourcename);
        if (this.isMine(url, resourcename)) {
            if (this.childFirstLookup) {
                CtClass clazz = super.getCachedLocally(classname);
                if (clazz == null) {
                    if (trace) {
                        this.log.trace((Object)("getCached() Creating my class " + classname));
                    }
                    if ((clazz = this.createCtClass(classname, false)) != null) {
                        this.lockInCache(clazz);
                    }
                }
                if (clazz != null) {
                    if (trace) {
                        this.log.trace((Object)("getCached() Returning my class " + classname));
                    }
                    return clazz;
                }
            }
            if (trace) {
                this.log.trace((Object)("getCached() Checking super for my class " + classname));
            }
            return super.getCached(classname);
        }
        if (url == null) {
            if (trace) {
                this.log.trace((Object)("getCached() Checking super for my class " + classname + " (no url)"));
            }
            return super.getCached(classname);
        }
        try {
            ClassPool pool = this.getCorrectPoolForResource(classname, resourcename, url, trace);
            if (trace) {
                this.log.trace((Object)("getCached() Found pool for class " + classname + " " + pool));
            }
            if (pool != this.lastPool.get()) {
                this.lastPool.set(pool);
                CtClass found = pool.get(classname);
                if (trace) {
                    this.log.trace((Object)("getCached() Found clazz " + classname + " in " + pool + " : " + found));
                }
                CtClass ctClass = found;
                return ctClass;
            }
        }
        catch (NotFoundException e) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
        finally {
            this.lastPool.set(null);
        }
        return null;
    }

    protected boolean includeInGlobalSearch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getCorrectPoolForResource(String classname, String resourceName, URL url, boolean trace) {
        Map map = AspectManager.getRegisteredCLs();
        synchronized (map) {
            ArrayList<AOPClassPool> noAnnotationURLClassLoaderPools = null;
            for (AOPClassPool aOPClassPool : AspectManager.getRegisteredCLs().values()) {
                if (aOPClassPool.isUnloadedClassLoader()) {
                    AspectManager.instance().unregisterClassLoader(aOPClassPool.getClassLoader());
                    continue;
                }
                if (aOPClassPool.getClassLoader() instanceof RealClassLoader) {
                    RealClassLoader bcl = (RealClassLoader)aOPClassPool.getClassLoader();
                    URL foundUrl = bcl.getResourceLocally(resourceName);
                    if (foundUrl == null || !url.equals(foundUrl)) continue;
                    if (trace) {
                        this.log.trace((Object)("getCorrectPoolForResource() Candidate classloader " + bcl + " has local resource " + foundUrl));
                    }
                    return aOPClassPool;
                }
                if (!this.isInstanceOfNoAnnotationURLClassLoader(aOPClassPool.getClassLoader())) continue;
                if (noAnnotationURLClassLoaderPools == null) {
                    noAnnotationURLClassLoaderPools = new ArrayList<AOPClassPool>();
                }
                noAnnotationURLClassLoaderPools.add(aOPClassPool);
            }
            if (noAnnotationURLClassLoaderPools != null) {
                for (ClassPool classPool : noAnnotationURLClassLoaderPools) {
                    try {
                        classPool.get(classname);
                        if (trace) {
                            this.log.trace((Object)("getCorrectPoolForResource(() Found  " + classname + " (no url)"));
                        }
                        return classPool;
                    }
                    catch (NotFoundException ignoreTryNext) {
                    }
                }
            }
        }
        return this.createTempPool();
    }

    private ClassPool createTempPool() {
        ClassLoader aopLoader = AspectManager.class.getClassLoader();
        ClassPool pool = AspectManager.instance().registerClassLoader(aopLoader);
        return AOPClassPool.createAOPClassPool((ClassPool)pool, (ScopedClassPoolRepository)AOPClassPoolRepository.getInstance());
    }

    private boolean isInstanceOfNoAnnotationURLClassLoader(ClassLoader loader) {
        for (Class<?> parent = loader.getClass(); parent != null; parent = parent.getSuperclass()) {
            if (!"NoAnnotationURLClassLoader".equals(parent.getSimpleName())) continue;
            return true;
        }
        return false;
    }
}

