/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.ScopedVFSClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;

public class VFSClassLoaderDomainRegistry {
    static final ClassLoaderDomain domain = new ClassLoaderDomain("NOT_USED_PLACEHOLDER");
    private Map<ClassLoader, WeakReference<ClassLoaderDomain>> classLoaderDomainsByLoader = new WeakHashMap<ClassLoader, WeakReference<ClassLoaderDomain>>();
    private Map<ClassLoaderDomain, ScopedVFSClassLoaderDomain> aopDomainsByClassLoaderDomain = new WeakHashMap<ClassLoaderDomain, ScopedVFSClassLoaderDomain>();

    synchronized void initMapsForLoader(ClassLoader loader, Module module, ScopedVFSClassLoaderDomain domain) {
        ClassLoaderSystem system = ClassLoaderSystem.getInstance();
        String domainName = module.getDeterminedDomainName();
        ClassLoaderDomain clDomain = system.getDomain(domainName);
        this.classLoaderDomainsByLoader.put(loader, new WeakReference<ClassLoaderDomain>(clDomain));
        if (domain != null) {
            this.aopDomainsByClassLoaderDomain.put(clDomain, domain);
        }
    }

    synchronized Domain getRegisteredDomain(ClassLoader cl) {
        ClassLoaderDomain clDomain = this.getClassLoaderDomainForLoader(cl);
        if (clDomain != null) {
            return (Domain)this.aopDomainsByClassLoaderDomain.get(clDomain);
        }
        return null;
    }

    synchronized ClassLoaderDomain getClassLoaderDomainForLoader(ClassLoader cl) {
        ClassLoaderDomain domain;
        WeakReference<ClassLoaderDomain> clDomainRef = this.classLoaderDomainsByLoader.get(cl);
        if (clDomainRef != null) {
            return (ClassLoaderDomain)clDomainRef.get();
        }
        ClassLoader parent = cl.getParent();
        if (parent != null && (domain = this.getClassLoaderDomainForLoader(parent)) != null) {
            this.classLoaderDomainsByLoader.put(parent, new WeakReference<ClassLoaderDomain>(domain));
            return domain;
        }
        return null;
    }
}

