/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5.temp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.asintegration.jboss5.temp.AopMetaDataDeployerOutput;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.aop.microcontainer.beans.metadata.AspectManagerAwareBeanMetaDataFactory;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAopMetaDataDeployer<T>
extends AbstractSimpleVFSRealDeployer<T> {
    private AspectManager aspectManager;
    private KernelController controller;
    private MyBeanMetaDataDeployer beanMetaDataDeployer = new MyBeanMetaDataDeployer();
    private static int sequence;

    public AbstractAopMetaDataDeployer(Class<T> input) {
        super(input);
        super.setStage(DeploymentStages.POST_CLASSLOADER);
        super.setOutput(AopMetaDataDeployerOutput.class);
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    public void setAspectManager(AspectManager aspectManager) {
        this.aspectManager = aspectManager;
    }

    public void setKernel(Kernel kernel) {
        this.controller = kernel.getController();
    }

    public void deploy(VFSDeploymentUnit unit, T deployment) throws DeploymentException {
        AspectManager correctManager;
        this.log.debug((Object)("Deploying " + unit + " " + deployment));
        AopMetaDataDeployerOutput output = new AopMetaDataDeployerOutput();
        unit.getTransientManagedObjects().addAttachment(AopMetaDataDeployerOutput.class, (Object)output);
        if (this.extractAopBeanMetaDataFactories(unit, deployment, output) && (correctManager = this.getCorrectManager(unit, output)) != this.aspectManager) {
            this.registerScopedManagerBean(unit, correctManager, output);
            this.massageScopedDeployment(unit, deployment, output);
        }
        try {
            this.deployBeans(unit, output);
        }
        catch (Throwable t) {
            this.unregisterScopedManagerBean(output.getScopedAspectManagerBeanName(), false);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(t);
        }
    }

    public void undeploy(VFSDeploymentUnit unit, T deployment) {
        this.log.debug((Object)("Undeploying " + unit + " " + deployment));
        AopMetaDataDeployerOutput output = (AopMetaDataDeployerOutput)unit.getTransientManagedObjects().getAttachment(AopMetaDataDeployerOutput.class);
        this.undeployBeans(unit, output);
        this.unregisterScopedManagerBean(output.getScopedAspectManagerBeanName(), true);
    }

    protected abstract List<BeanMetaDataFactory> getFactories(T var1);

    private boolean extractAopBeanMetaDataFactories(VFSDeploymentUnit unit, T deployment, AopMetaDataDeployerOutput output) {
        this.log.debug((Object)("Extracting aop bean metadata factories for  " + unit));
        ArrayList<AspectManagerAwareBeanMetaDataFactory> aopFactories = new ArrayList<AspectManagerAwareBeanMetaDataFactory>();
        List<BeanMetaDataFactory> factories = this.getFactories(deployment);
        if (factories != null && factories.size() > 0) {
            Iterator<BeanMetaDataFactory> it = factories.iterator();
            while (it.hasNext()) {
                BeanMetaDataFactory factory = it.next();
                if (!(factory instanceof AspectManagerAwareBeanMetaDataFactory)) continue;
                it.remove();
                aopFactories.add((AspectManagerAwareBeanMetaDataFactory)factory);
            }
        }
        if (aopFactories.size() > 0) {
            output.setFactories(aopFactories);
            return true;
        }
        return false;
    }

    private AspectManager getCorrectManager(VFSDeploymentUnit unit, AopMetaDataDeployerOutput output) throws DeploymentException {
        AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();
        Domain domain = null;
        if (policy != null) {
            if (!(policy instanceof DomainInitializer)) {
                throw new RuntimeException(policy + " must implement DomainInitializer");
            }
            DomainInitializer initializer = (DomainInitializer)policy;
            domain = initializer.initializeDomain(unit);
        }
        if (domain != null) {
            this.log.debug((Object)("Deployment is scoped to " + domain));
            return domain;
        }
        return this.aspectManager;
    }

    private void registerScopedManagerBean(VFSDeploymentUnit unit, AspectManager scopedManager, AopMetaDataDeployerOutput output) throws DeploymentException {
        String name = "ScopedManager_" + this.getSequence() + "_" + unit.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)scopedManager.getClass().getName());
        try {
            this.controller.install(builder.getBeanMetaData(), (Object)scopedManager);
            output.setScopedAspectManagerBeanName(name);
        }
        catch (Throwable e) {
            this.unregisterScopedManagerBean(name, false);
            throw new DeploymentException("Error registering scoped manager" + name + " " + scopedManager, e);
        }
    }

    private synchronized int getSequence() {
        return ++sequence;
    }

    private void unregisterScopedManagerBean(String name, boolean logError) {
        block3: {
            if (name == null) {
                return;
            }
            try {
                this.controller.uninstall((Object)name);
            }
            catch (Throwable t) {
                if (!logError) break block3;
                this.log.debug((Object)("Error unregistering scoped aspect manager " + name), t);
            }
        }
    }

    private void massageScopedDeployment(VFSDeploymentUnit unit, T deployment, AopMetaDataDeployerOutput output) throws DeploymentException {
        if (output.getScopedAspectManagerBeanName() == null) {
            return;
        }
        this.log.debug((Object)("Massaging scoped deployment " + unit));
        List<AspectManagerAwareBeanMetaDataFactory> aopFactories = output.getFactories();
        if (aopFactories != null && aopFactories.size() > 0) {
            for (AspectManagerAwareBeanMetaDataFactory factory : aopFactories) {
                factory.setManagerBean(output.getScopedAspectManagerBeanName());
                factory.setManagerProperty(null);
            }
        }
    }

    private void deployBeans(VFSDeploymentUnit unit, AopMetaDataDeployerOutput output) throws DeploymentException {
        List<AspectManagerAwareBeanMetaDataFactory> aopFactories = output.getFactories();
        ArrayList<BeanMetaData> done = new ArrayList<BeanMetaData>();
        try {
            if (aopFactories != null && aopFactories.size() > 0) {
                for (AspectManagerAwareBeanMetaDataFactory factory : aopFactories) {
                    List beans = factory.getBeans();
                    if (beans == null || beans.size() <= 0) continue;
                    for (BeanMetaData bean : beans) {
                        this.beanMetaDataDeployer.deploy((DeploymentUnit)unit, bean);
                        done.add(bean);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (int i = done.size() - 1; i >= 0; --i) {
                try {
                    this.beanMetaDataDeployer.undeploy((DeploymentUnit)unit, (BeanMetaData)done.get(i));
                    this.controller.uninstall(done.get(i));
                    continue;
                }
                catch (Throwable e) {
                    this.log.debug((Object)("Error undeploying " + done.get(i) + " for " + unit));
                }
            }
            throw new DeploymentException(t);
        }
    }

    private void undeployBeans(VFSDeploymentUnit unit, AopMetaDataDeployerOutput output) {
        List<AspectManagerAwareBeanMetaDataFactory> aopFactories = output.getFactories();
        if (aopFactories != null && aopFactories.size() > 0) {
            for (int i = aopFactories.size() - 1; i >= 0; --i) {
                AspectManagerAwareBeanMetaDataFactory factory = aopFactories.get(i);
                List beans = factory.getBeans();
                if (beans == null || beans.size() <= 0) continue;
                for (int j = beans.size() - 1; j >= 0; --j) {
                    BeanMetaData bean = (BeanMetaData)beans.get(j);
                    this.beanMetaDataDeployer.undeploy((DeploymentUnit)unit, bean);
                }
            }
        }
    }

    private static class DeploymentClassLoaderMetaData
    extends AbstractClassLoaderMetaData {
        private static final long serialVersionUID = 1L;
        private DeploymentUnit unit;

        public DeploymentClassLoaderMetaData(DeploymentUnit unit) {
            if (unit == null) {
                throw new IllegalArgumentException("Null unit");
            }
            this.unit = unit;
        }

        public ValueMetaData getClassLoader() {
            return new AbstractValueMetaData((Object)this.unit.getClassLoader());
        }
    }

    private class MyBeanMetaDataDeployer {
        private MyBeanMetaDataDeployer() {
        }

        private void deploy(DeploymentUnit unit, BeanMetaData deployment) throws DeploymentException {
            if (deployment.getClassLoader() == null) {
                try {
                    unit.getClassLoader();
                    deployment.setClassLoader((ClassLoaderMetaData)new DeploymentClassLoaderMetaData(unit));
                }
                catch (Exception e) {
                    AbstractAopMetaDataDeployer.this.log.debug((Object)("Unable to retrieve classloader for deployment: " + unit.getName() + " reason=" + e.toString()));
                }
            }
            AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, deployment, null);
            try {
                AbstractAopMetaDataDeployer.this.controller.install((ControllerContext)context);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment.getName()), (Throwable)t);
            }
        }

        private void undeploy(DeploymentUnit unit, BeanMetaData deployment) {
            try {
                AbstractAopMetaDataDeployer.this.controller.uninstall((Object)deployment.getName());
                ClassLoaderMetaData classLoader = deployment.getClassLoader();
                if (classLoader instanceof DeploymentClassLoaderMetaData) {
                    deployment.setClassLoader(null);
                }
            }
            catch (Throwable t) {
                AbstractAopMetaDataDeployer.this.log.info((Object)("Error undeploying " + deployment + " for " + unit));
            }
        }
    }
}

