/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.asintegration.jboss5;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class AOPClassLoaderDeployer extends AbstractVFSRealDeployer
{
   AspectManager aspectManager;
   
   public AOPClassLoaderDeployer(int xmlRelativeOrder)
   {
      setStage(DeploymentStages.CLASSLOADER);
      //This needs to come after the classloader deployer
      setRelativeOrder(xmlRelativeOrder + 1);
   }

   public AspectManager getAspectManager()
   {
      return aspectManager;
   }

   public void setAspectManager(AspectManager aspectManager)
   {
      this.aspectManager = aspectManager;
   }

   @Override
   public void deploy(VFSDeploymentUnit unit) throws DeploymentException
   {
      //Scoped AOP deployments are only available when deployed as part of a scoped sar, ear etc.
      //It can contain an aop.xml file, or it can be part of a .aop file
      //Linking a standalone -aop.xml file onto a scoped deployment is not possible at the moment
      AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();

      AspectManager manager = aspectManager;
      if (policy != null)
      {
         if (policy instanceof DomainInitializer == false)
         {
            throw new RuntimeException(policy + " must implement DomainInitializer");
         }
         DomainInitializer initializer = (DomainInitializer)policy;
         Domain domain  = initializer.initializeDomain(unit);
         if (domain != null)
         {
            manager = domain;
         }
      }
      
      unit.getTransientManagedObjects().addAttachment(AspectManager.class, manager);
   }

   @Override
   public void undeploy(VFSDeploymentUnit unit)
   {
      if (unit.getTopLevel() == unit)
      {
         aspectManager.unregisterClassLoader(unit.getClassLoader());
      }
   }
}
