/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.asintegration.jboss5;

import java.io.File;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;

import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss4.JBossClassPoolFactory;
import org.jboss.aop.deployment.AspectManagerService;
import org.jboss.mx.util.MBeanServerLocator;

import javassist.scopedpool.ScopedClassPoolFactory;

/**
 * Takes care of the specifics in JBoss 5 when the RepositoryClassLoaders are used.
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class RepositoryIntegrationStrategy implements IntegrationStrategy
{
   public void start()
   {
   }
   
   public void stop()
   {
   }

   public ScopedClassPoolFactory createScopedClassPoolFactory(File tmpDir) throws Exception
   {
      //This is the classpool factory from jboss-aop-jboss4-jdk50.jar
      return new JBossClassPoolFactory(tmpDir);
   }

   public void attachDeprecatedTranslator()
   {
      AspectManager mgr = AspectManager.instance();
      MBeanServer server = MBeanServerLocator.locateJBoss();
      try
      {
         server.setAttribute(AspectManagerService.DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", mgr));
      }
      catch (InstanceNotFoundException e)
      {
         throw new RuntimeException(e);
      }
      catch (AttributeNotFoundException e)
      {
         throw new RuntimeException(e);
      }
      catch (InvalidAttributeValueException e)
      {
         throw new RuntimeException(e);
      }
      catch (MBeanException e)
      {
         throw new RuntimeException(e);
      }
      catch (ReflectionException e)
      {
         throw new RuntimeException(e);
      }
   }

   public void detachDeprecatedTranslator()
   {
      MBeanServer server = MBeanServerLocator.locateJBoss();
      try
      {
         server.setAttribute(AspectManagerService.DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", null));
      }
      catch (InstanceNotFoundException e)
      {
         throw new RuntimeException(e);
      }
      catch (AttributeNotFoundException e)
      {
         throw new RuntimeException(e);
      }
      catch (InvalidAttributeValueException e)
      {
         throw new RuntimeException(e);
      }
      catch (MBeanException e)
      {
         throw new RuntimeException(e);
      }
      catch (ReflectionException e)
      {
         throw new RuntimeException(e);
      }
   }

}
