/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.asintegration.jboss5;

import java.util.HashMap;
import java.util.Map;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.classpool.ExtraClassPoolFactoryParameters;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class VFSClassLoaderScopingPolicy implements AOPClassLoaderScopingPolicy, DomainInitializer
{
   static Logger log = Logger.getLogger(VFSClassLoaderScopingPolicy.class);
   VFSClassLoaderDomainRegistry registry = new VFSClassLoaderDomainRegistry();
   
   public Domain initializeDomain(VFSDeploymentUnit unit)
   {
      Module module = unit.getTopLevel().getAttachment(Module.class);
      ClassLoader loader = unit.getClassLoader();
      ClassLoader topLoader = unit.getTopLevel().getClassLoader();
      
      boolean isWar = unit.isAttachmentPresent("org.jboss.metadata.web.jboss.JBossWebMetaData");

      if (isWar && loader != topLoader)
      {
         ScopedVFSClassLoaderDomain scopedDomain = (ScopedVFSClassLoaderDomain)registry.getRegisteredDomain(loader);
         if (scopedDomain == null) 
         {
            scopedDomain = (ScopedVFSClassLoaderDomain)registry.getRegisteredDomain(topLoader);
         }
         
         if (scopedDomain != null)
         {
            registry.initMapsForLoader(loader, module, scopedDomain);
         }

         registerClassLoader(module, isWar, loader);
         
         return scopedDomain;
      }
      else
      {
         ScopedVFSClassLoaderDomain scopedDomain = (ScopedVFSClassLoaderDomain)registry.getRegisteredDomain(loader);
         if (scopedDomain == null)
         {
            if (!module.getDeterminedDomainName().equals(ClassLoaderSystem.DEFAULT_DOMAIN_NAME))
            {
               ClassLoaderSystem system = ClassLoaderSystem.getInstance();
               String domainName = module.getDeterminedDomainName();
               ClassLoaderDomain domain = system.getDomain(domainName);
      
               boolean parentDelegation = module.isJ2seClassLoadingCompliance();
               String name = String.valueOf(System.identityHashCode(loader));
               
               scopedDomain = new ScopedVFSClassLoaderDomain(loader, name, parentDelegation, AspectManager.getTopLevelAspectManager(), false, domain, registry);
            }
      
            registry.initMapsForLoader(loader, module, scopedDomain);
            
            registerClassLoader(module, isWar, loader);
         }
         return scopedDomain;
      }      
   }

   private void registerClassLoader(Module module, boolean isWar, ClassLoader loader)
   {
      //Need to pass some data through to the classpoolfactory here
      Map properties = new HashMap();
      //The module is needed by the JBoss5ClassPoolFactory, the legacy JBossClassPoolFactory will ignore this
      properties.put(Module.class, module);
      properties.put("IsWebCl", isWar ? Boolean.TRUE : Boolean.FALSE);
      ExtraClassPoolFactoryParameters.pushThreadProperties(properties);
      try
      {
         AspectManager.instance().registerClassLoader(loader); //Ends up in classpool factory create method
      }
      finally
      {
         ExtraClassPoolFactoryParameters.popThreadProperties();
      }
   }
   
   public Domain getDomain(ClassLoader classLoader, AspectManager parent)
   {
      //Check the stored domains
      Domain domain = registry.getRegisteredDomain(classLoader);
      if (domain != null)
      {
         return domain;
      }
      
      return null;
   }

   public Domain getTopLevelDomain(AspectManager parent)
   {
      Thread.currentThread().getContextClassLoader();
      return null;
   }
}
   
