/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.domain.DomainInitializer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

public class AOPClassLoaderDeployer
extends AbstractVFSRealDeployer {
    AspectManager aspectManager;

    public AOPClassLoaderDeployer(int xmlRelativeOrder) {
        this.setStage(DeploymentStages.CLASSLOADER);
        this.setRelativeOrder(xmlRelativeOrder + 1);
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    public void setAspectManager(AspectManager aspectManager) {
        this.aspectManager = aspectManager;
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();
        AspectManager manager = this.aspectManager;
        if (policy != null) {
            if (!(policy instanceof DomainInitializer)) {
                throw new RuntimeException(policy + " must implement DomainInitializer");
            }
            DomainInitializer initializer = (DomainInitializer)policy;
            Domain domain = initializer.initializeDomain(unit);
            if (domain != null) {
                manager = domain;
            }
        }
        unit.getTransientManagedObjects().addAttachment(AspectManager.class, (Object)manager);
    }

    public void undeploy(VFSDeploymentUnit unit) {
        if (unit.getTopLevel() == unit) {
            this.aspectManager.unregisterClassLoader(unit.getClassLoader());
        }
    }
}

