/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.jboss5.DefaultTranslator;
import org.jboss.aop.asintegration.jboss5.IntegrationStrategy;
import org.jboss.aop.asintegration.jboss5.RepositoryIntegrationStrategy;
import org.jboss.aop.asintegration.jboss5.VFSIntegrationStrategy;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.classloading.spi.RealClassLoader;

public class JBoss5Integration
implements JBossIntegration,
ScopedClassPoolFactory {
    private ScopedClassPoolFactory delegateClassPoolFactory;
    private AOPClassLoaderScopingPolicy policy;
    private AspectManager manager = AspectManager.getTopLevelAspectManager();
    DefaultTranslator translator = new DefaultTranslator(this.manager);
    private static final Set<ClassLoader> bootstrapLoaders;
    private IntegrationStrategy integrationStrategy;

    public void start() {
        this.getIntegrationStrategy().start();
    }

    public void stop() {
        this.getIntegrationStrategy().stop();
    }

    public boolean isValidClassLoader(ClassLoader loader) {
        if (loader instanceof RealClassLoader && ((RealClassLoader)loader).isValid()) {
            return true;
        }
        if (loader == null) {
            return true;
        }
        return bootstrapLoaders.contains(loader);
    }

    public void setScopingPolicy(AOPClassLoaderScopingPolicy policy) {
        this.policy = policy;
    }

    public AOPClassLoaderScopingPolicy getScopingPolicy() {
        return this.policy;
    }

    public AOPClassLoaderScopingPolicy createAOPClassLoaderScopingPolicy() {
        return this.policy;
    }

    public synchronized ScopedClassPoolFactory createScopedClassPoolFactory(File tmpDir) throws Exception {
        if (this.delegateClassPoolFactory == null) {
            this.delegateClassPoolFactory = this.getIntegrationStrategy().createScopedClassPoolFactory(tmpDir);
        }
        return this;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        return this.delegateClassPoolFactory.create(cl, src, repository);
    }

    public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository) {
        return this.delegateClassPoolFactory.create(src, repository);
    }

    public void attachDeprecatedTranslator() {
        this.getIntegrationStrategy().attachDeprecatedTranslator();
    }

    public void detachDeprecatedTranslator() {
        this.getIntegrationStrategy().detachDeprecatedTranslator();
    }

    private synchronized IntegrationStrategy getIntegrationStrategy() {
        if (this.integrationStrategy == null) {
            this.integrationStrategy = this.policy.getClass().getName().endsWith("RepositoryClassLoaderScopingPolicy") ? new RepositoryIntegrationStrategy() : new VFSIntegrationStrategy(this.manager);
        }
        return this.integrationStrategy;
    }

    static {
        final HashSet loaders = new HashSet();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (ClassLoader loader = JBoss5Integration.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                    loaders.add(loader);
                }
                return null;
            }
        });
        bootstrapLoaders = Collections.unmodifiableSet(loaders);
    }
}

