/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jndi;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.RoundRobin;
import org.jboss.ha.framework.server.HARMIServerImpl;
import org.jboss.ha.jndi.DetachedHANamingService;
import org.jboss.ha.jndi.HANamingServiceMBean;
import org.jnp.interfaces.Naming;

public class HANamingService
extends DetachedHANamingService
implements HANamingServiceMBean {
    private RMIClientSocketFactory clientSocketFactory;
    private RMIServerSocketFactory serverSocketFactory;
    private String clientSocketFactoryName;
    private String serverSocketFactoryName;
    private String loadBalancePolicy = RoundRobin.class.getName();
    private int rmiPort = 0;
    protected String replicantName = "HAJNDI";
    private HARMIServerImpl rmiserver;

    public void setRmiPort(int p) {
        this.rmiPort = p;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public String getClientSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    public String getLoadBalancePolicy() {
        return this.loadBalancePolicy;
    }

    public void setLoadBalancePolicy(String policyClassName) {
        this.loadBalancePolicy = policyClassName;
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.log.debug((Object)"destroy ha rmiserver");
        this.rmiserver.destroy();
    }

    protected Naming getNamingProxy() throws Exception {
        this.rmiserver = new HARMIServerImpl(this.clusterPartition, this.replicantName, Naming.class, this.theServer, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory, this.bindAddress);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(this.loadBalancePolicy);
        LoadBalancePolicy policy = (LoadBalancePolicy)clazz.newInstance();
        Naming proxy = (Naming)this.rmiserver.createHAStub(policy);
        return proxy;
    }
}

