package org.jboss.ha.singleton;

import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;

/**
 * HASingletonElectionPolicy.
 * 
 * @author <a href="mailto:Alex.Fu@novell.com">Alex Fu</a>
 * @author Brian Stansberry
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public interface HASingletonElectionPolicy
{
   /**
    * Called by the HASingleton, during the create service phase, to set the 
    * name with which the singleton is registered with the HAPartition.
    * 
    * @param serviceName the singleton service name.
    */
   void setSingletonName(String serviceName);

   /**
    * Get the singleton name for this election policy. 
    * 
    * @return the singleton service name.
    */
   String getSingletonName(); 

   /**
    * Called by the HASingleton, during the create service phase to sets the 
    * HAPartition; from this the election policy can gain access to the 
    * DistributedReplicantManager for tracking the  deployment topology for 
    * the singleton service and to the HAPartition for making group RPC calls.
    */
   void setHAPartition(HAPartition partition);

   /**
    * Get the HA partition where the singleton is deployed, which can be used, 
    * amongst other things, to find out which nodes is the singleton available 
    * in.
    * 
    * @return the HA partition.
    */
   HAPartition getHAPartition();
   
   /**
    * Return the elected master node.
    * @return the master node or null if there're no possible master nodes.
    */
   ClusterNode elect();
}