/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.interfaces;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.invocation.unified.interfaces.UnifiedInvokerProxy;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class UnifiedInvokerHAProxy
extends UnifiedInvokerProxy
implements InvokerProxyHA {
    static final long serialVersionUID = -4813929243402349966L;
    private LoadBalancePolicy loadBalancePolicy;
    private String proxyFamilyName = null;
    private FamilyClusterInfo familyClusterInfo = null;
    public static final Map txFailoverAuthorizations = Collections.synchronizedMap(new WeakHashMap());
    private static boolean trace = false;

    public UnifiedInvokerHAProxy() {
        trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"UnifiedInvokerHAProxy constructor called with no arguments.");
        }
        this.setSubSystem("invokerha");
    }

    public UnifiedInvokerHAProxy(InvokerLocator locator, boolean isStrictRMIException, List targets, LoadBalancePolicy policy, String proxyFamilyName, long viewId) {
        super(locator, isStrictRMIException);
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (List)targets, (long)viewId);
        this.loadBalancePolicy = policy;
        this.proxyFamilyName = proxyFamilyName;
        trace = this.log.isTraceEnabled();
        this.setSubSystem("invokerha");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean txContextAllowsFailover(Invocation invocation) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            if (trace) {
                this.log.trace((Object)("Checking tx failover authorisation map with tpc " + tpc));
            }
            Object object = tpc;
            synchronized (object) {
                boolean failoverAuthorised;
                boolean bl = failoverAuthorised = !txFailoverAuthorizations.containsKey(tpc);
                if (failoverAuthorised) {
                    if (trace) {
                        this.log.trace((Object)("Failover authorised, so we remove the sticky target associated with tpc " + tpc));
                    }
                    txFailoverAuthorizations.put(tpc, null);
                    invocation.getTransientPayload().put("TX_STICKY_TARGET", null);
                }
                return failoverAuthorised;
            }
        }
        return true;
    }

    public void invocationHasReachedAServer(Invocation invocation) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            if (trace) {
                this.log.trace((Object)("After reaching the server, transaction propagation context (tpc) is " + tpc));
            }
            Object stickyTarget = invocation.getTransientValue((Object)"TX_STICKY_TARGET");
            if (trace && stickyTarget != null) {
                this.log.trace((Object)("Remember transaction bound target[" + stickyTarget + "] for tpc " + tpc));
            }
            txFailoverAuthorizations.put(tpc, stickyTarget);
        }
    }

    public String getProxyFamilyName() {
        return this.proxyFamilyName;
    }

    protected int totalNumberOfTargets() {
        if (this.familyClusterInfo != null) {
            return this.familyClusterInfo.getTargets().size();
        }
        return 0;
    }

    protected void resetView() {
        this.familyClusterInfo.resetView();
    }

    protected synchronized Client getClient(Invocation invocationBasedRouting) throws MalformedURLException {
        Object target = this.loadBalancePolicy.chooseTarget(this.familyClusterInfo, invocationBasedRouting);
        InvokerLocator targetLocator = (InvokerLocator)target;
        if (!this.getLocator().equals((Object)targetLocator)) {
            this.init(targetLocator);
        }
        return this.getClient();
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), PayloadKey.AS_IS);
        Object response = null;
        GenericClusteringException lastException = null;
        boolean failoverAuthorized = true;
        while (this.familyClusterInfo.getTargets() != null && this.familyClusterInfo.getTargets().size() > 0 && failoverAuthorized) {
            boolean definitivlyRemoveNodeOnFailure = true;
            try {
                invocation.setValue((Object)"CLUSTER_VIEW_ID", (Object)new Long(this.familyClusterInfo.getCurrentViewId()));
                if (trace) {
                    this.log.trace((Object)("Client cluster view id: " + this.familyClusterInfo.getCurrentViewId()));
                    this.log.trace(this.printPossibleTargets());
                }
                this.putIfExistsTransactionTarget(invocation, this.getTransactionPropagationContext());
                Client clientInstance = this.getClient(invocation);
                if (trace) {
                    this.log.trace((Object)("Making invocation on " + clientInstance.getInvoker().getLocator()));
                }
                response = clientInstance.invoke((Object)invocation, null);
                HARMIResponse haResponse = null;
                if (response instanceof Exception) {
                    if (trace) {
                        this.log.trace((Object)("Invocation returned exception: " + response));
                    }
                    if (response instanceof GenericClusteringException) {
                        GenericClusteringException gcex;
                        lastException = gcex = (GenericClusteringException)((Object)response);
                        if (gcex.getCompletionStatus() == 1) {
                            if (this.totalNumberOfTargets() >= failoverCounter && !gcex.isDefinitive()) {
                                definitivlyRemoveNodeOnFailure = false;
                            }
                            this.removeDeadTarget(this.getLocator());
                            if (!definitivlyRemoveNodeOnFailure) {
                                this.resetView();
                            }
                            failoverAuthorized = this.txContextAllowsFailover(invocation);
                            invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(++failoverCounter), PayloadKey.AS_IS);
                            if (!trace) continue;
                            this.log.trace((Object)"Received GenericClusteringException where request was not completed.  Will retry if transaction failover is authorised.");
                            continue;
                        }
                        this.invocationHasReachedAServer(invocation);
                        throw new ServerException("Clustering error", (Exception)((Object)gcex));
                    }
                    throw (Exception)response;
                }
                haResponse = response instanceof MarshalledObject ? (HARMIResponse)((MarshalledObject)response).get() : (HARMIResponse)response;
                if (haResponse.newReplicants != null) {
                    this.updateClusterInfo(haResponse.newReplicants, haResponse.currentViewId);
                }
                this.invocationHasReachedAServer(invocation);
                response = haResponse.response;
                return response;
            }
            catch (CannotConnectException cncEx) {
                if (trace) {
                    this.log.trace((Object)("Invocation failed: CannotConnectException - " + (Object)((Object)cncEx)), (Throwable)cncEx);
                }
                this.removeDeadTarget(this.getLocator());
                this.resetView();
                failoverAuthorized = this.txContextAllowsFailover(invocation);
                invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(++failoverCounter), PayloadKey.AS_IS);
            }
            catch (GenericClusteringException gcex) {
                lastException = gcex;
                if (gcex.getCompletionStatus() == 1) {
                    if (this.totalNumberOfTargets() >= failoverCounter && !gcex.isDefinitive()) {
                        definitivlyRemoveNodeOnFailure = false;
                    }
                    this.removeDeadTarget(this.getLocator());
                    if (!definitivlyRemoveNodeOnFailure) {
                        this.resetView();
                    }
                    failoverAuthorized = this.txContextAllowsFailover(invocation);
                    invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(++failoverCounter), PayloadKey.AS_IS);
                    if (!trace) continue;
                    this.log.trace((Object)"Received GenericClusteringException where request was not completed.  Will retry.");
                    continue;
                }
                this.invocationHasReachedAServer(invocation);
                throw new ServerException("Clustering error", (Exception)((Object)gcex));
            }
            catch (RemoteException aex) {
                if (trace) {
                    this.log.trace((Object)("Invocation failed: RemoteException - " + aex), (Throwable)aex);
                }
                if (this.isStrictRMIException()) {
                    throw new ServerException(aex.getMessage(), aex);
                }
                throw aex;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.log.trace((Object)("Invocation failed: " + throwable), throwable);
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }
        if (!failoverAuthorized) {
            throw new ServiceUnavailableException("Service unavailable (failover not possible inside a user transaction) for " + invocation.getObjectName() + " calling method " + invocation.getMethod(), (Throwable)lastException);
        }
        throw new ServiceUnavailableException("Service unavailable for " + invocation.getObjectName() + " calling method " + invocation.getMethod(), (Throwable)lastException);
    }

    private Object printPossibleTargets() {
        List possibleTargets;
        StringBuffer buffer = new StringBuffer();
        if (this.familyClusterInfo != null && (possibleTargets = this.familyClusterInfo.getTargets()) != null && possibleTargets.size() > 0) {
            for (int x = 0; x < possibleTargets.size(); ++x) {
                buffer.append("\nPossible target " + (x + 1) + ": " + possibleTargets.get(x));
            }
        }
        return buffer.toString();
    }

    private void removeDeadTarget(InvokerLocator locator) {
        if (locator != null && this.familyClusterInfo != null) {
            this.familyClusterInfo.removeDeadTarget((Object)locator);
            if (trace) {
                this.log.trace((Object)("Removed " + locator + " from target list."));
            }
        }
    }

    public void updateClusterInfo(ArrayList newReplicants, long currentViewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo((List)newReplicants, currentViewId);
            if (trace) {
                this.log.trace((Object)("Updating cluster info.  New view id: " + currentViewId));
                this.log.trace((Object)"New cluster target list is:");
                for (int x = 0; x < newReplicants.size(); ++x) {
                    this.log.trace(newReplicants.get(x));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(500);
        out.writeUTF(this.getLocator().getOriginalURI());
        out.writeBoolean(this.isStrictRMIException());
        List targets = null;
        long vid = 0L;
        FamilyClusterInfo familyClusterInfo = this.familyClusterInfo;
        synchronized (familyClusterInfo) {
            targets = this.familyClusterInfo.getTargets();
            vid = this.familyClusterInfo.getCurrentViewId();
        }
        out.writeObject(targets);
        out.writeObject(this.loadBalancePolicy);
        out.writeObject(this.proxyFamilyName);
        out.writeLong(vid);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 500: {
                this.setLocator(new InvokerLocator(in.readUTF()));
                this.setStrictRMIException(in.readBoolean());
                this.init(this.getLocator());
                List targets = (List)in.readObject();
                this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
                this.proxyFamilyName = (String)in.readObject();
                long vid = in.readLong();
                this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)targets, (long)vid);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown version seen: " + version);
            }
        }
        trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Init, clusterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy));
        }
    }

    protected Object getTransactionPropagationContext() {
        TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        if (trace) {
            this.log.trace((Object)("Using tpc factory " + tpcFactory));
        }
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    protected void putIfExistsTransactionTarget(Invocation invocation, Object tpc) throws GenericClusteringException {
        if (tpc != null) {
            Object stickyTarget;
            if (trace) {
                this.log.trace((Object)("In the proxy, transaction propagation context (tpc) is " + tpc));
                this.log.trace((Object)("Contains key returns " + txFailoverAuthorizations.containsKey(tpc)));
            }
            if ((stickyTarget = txFailoverAuthorizations.get(tpc)) != null) {
                if (this.familyClusterInfo.getTargets().contains(stickyTarget)) {
                    if (trace) {
                        this.log.trace((Object)("Put transaction bound target into transient payload: " + stickyTarget));
                    }
                    invocation.getTransientPayload().put("TX_STICKY_TARGET", stickyTarget);
                } else {
                    throw new GenericClusteringException(0, "Transaction sticky target is no longer available, so invocation needs to be halted");
                }
            }
        }
    }
}

