/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ha.framework.server;

import java.net.InetAddress;
import java.util.Vector;

import javax.management.ObjectName;

import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.mx.util.ObjectNameFactory;
import org.jgroups.ChannelFactory;

/** 
 *   MBean interface for ClusterPartition.  It will start a JGroups
 *   channel and initialize the ReplicantManager and DistributedStateService.
 *
 *   @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>.
 *   @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 *   @version $Revision: 77705 $
 *
 * <p><b>Revisions:</b><br>
 */

public interface ClusterPartitionMBean
   extends org.jboss.system.ServiceMBean
{
   ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss:service=ClusterPartition");

   /**
    * Name of the partition being built. All nodes/services belonging to 
    * a partition with the same name are clustered together.
    */
   String getPartitionName();

   /**
    * Uniquely identifies this node. MUST be unique accros the whole cluster!
    * Cannot be changed once the partition has been started (otherwise an exception is thrown)
    */
   String getNodeName();
   
   /**
    * The node address used to generate the node name
    */
   InetAddress getNodeAddress();
   
   /** The version of JGroups this is running on */
   String getJGroupsVersion();

   /* Number of milliseconds to wait until state has been transferred. Increase this value for large states
      0 = wait forever */
   long getStateTransferTimeout();

   void setStateTransferTimeout(long timeout);

   /** Max time (in ms) to wait for <em>synchronous</em> group method calls
    * ({@link HAPartition#callMethodOnCluster(String, String, Object[], Class[], boolean)}) */ 
   long getMethodCallTimeout();

   void setMethodCallTimeout(long timeout);

   /**
    * Deprecated; always returns <code>false</code>.
    * 
    * @return <code>false</code>
    * 
    * @deprecated will be removed in next major release
    */
   @Deprecated
   boolean getDeadlockDetection();
   
   /**
    * Returns whether this partition will synchronously notify any 
    * HAPartition.HAMembershipListener of membership changes using the 
    * calling thread from the underlying group communications layer
    * (e.g. JGroups).
    * 
    * @return <code>true</code> if registered listeners that don't implement
    *         <code>AsynchHAMembershipExtendedListener</code> or
    *         <code>AsynchHAMembershipListener</code> will be notified
    *         synchronously of membership changes; <code>false</code> if
    *         those listeners will be notified asynchronously.  Default
    *         is <code>false</code>.
    */
   public boolean getAllowSynchronousMembershipNotifications();

   /**
    * Sets whether this partition will synchronously notify any 
    * HAPartition.HAMembershipListener of membership changes using the  
    * calling thread from the underlying group communications layer
    * (e.g. JGroups).
    * 
    * @param allowSync  <code>true</code> if registered listeners that don't 
    *         implement <code>AsynchHAMembershipExtendedListener</code> or
    *         <code>AsynchHAMembershipListener</code> should be notified
    *         synchronously of membership changes; <code>false</code> if
    *         those listeners can be notified asynchronously.  Default
    *         is <code>false</code>.
    */
   public void setAllowSynchronousMembershipNotifications(boolean allowSync);

   /** Access to the underlying HAPartition without going through JNDI
    *
    * @return the HAPartition for the cluster service
    */
   HAPartition getHAPartition ();
   
   /**
    * Access to the DistributedReplicantManager implementation
    */
   DistributedReplicantManager getDistributedReplicantManager();
   
   /**
    * Access to the DistributedState implementation
    * 
    * @deprecated Use JBoss Cache for distributed caching
    */
   DistributedState getDistributedStateService();
   
   /**
    * Gets the configuration name under which our cache is registered
    * with the cache manager.
    */
   String getCacheConfigName();
   
   /**
    * Gets the JGroups channel factory used by ClusterPartition.
    */
   ChannelFactory getChannelFactory();
   
   /**
    * Gets the name of the JGroups channel protocol stack configuration
    * provided to the {@link #getChannelFactory() channel factory}. 
    */
   String getChannelStackName();

   /** Return the list of member nodes that built from the current view
    * @return A Vector Strings representing the host:port values of the nodes
    */
   Vector getCurrentView();

   String showHistory ();

   String showHistoryAsXML ();

}
