/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.ha.singleton.HASingletonDeploymentScannerMBean;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profileservice.DeploymentPhaseVFSScanner;
import org.jboss.virtual.VirtualFile;

public class HASingletonDeploymentScanner
extends DeploymentPhaseVFSScanner
implements HASingletonDeploymentScannerMBean {
    private static final ManagedDeployment.DeploymentPhase DEPLOYMENT_PHASE = ManagedDeployment.DeploymentPhase.APPLICATION;
    private MainDeployer mainDeployer;
    private DeploymentManager deploymentManager;
    private boolean deployed;
    private ProfileKey activeProfile;
    private Set<String> uploadedNames = new LinkedHashSet<String>();

    public HASingletonDeploymentScanner() {
        super(DEPLOYMENT_PHASE);
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void setProfileService(ProfileService profileService) {
        super.setProfileService(profileService);
        this.deploymentManager = profileService != null ? profileService.getDeploymentManager() : null;
    }

    public synchronized void deploySingletons(String uris) throws Exception {
        if (!this.deployed) {
            if (this.deploymentManager == null && this.mainDeployer == null) {
                throw new IllegalStateException("Configuration must either provide a ProfileService with a DeploymentManager or a MainDeployer");
            }
            StringTokenizer tokenizer = new StringTokenizer(uris, ",");
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                uri = uri.trim();
                this.addURI(new URI(uri));
            }
            this.scan();
            if (this.deploymentManager == null) {
                this.mainDeployer.process();
            } else {
                String[] allUploaded = this.getAllUploadedNames();
                DeploymentProgress progress = this.deploymentManager.start(DEPLOYMENT_PHASE, allUploaded);
                progress.run();
            }
            this.deployed = true;
        }
    }

    public synchronized void undeploySingletons(String uris) throws Exception {
        if (this.deployed) {
            if (this.deploymentManager == null && this.mainDeployer == null) {
                throw new IllegalStateException("Configuration must either provide a ProfileService with a DeploymentManager or a MainDeployer");
            }
            StringTokenizer tokenizer = new StringTokenizer(uris, ",");
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                uri = uri.trim();
                this.removeURI(new URI(uri));
            }
            this.scan();
            if (this.deploymentManager == null) {
                this.mainDeployer.process();
            } else {
                String[] allUploaded = this.getAllUploadedNames();
                this.uploadedNames.clear();
                DeploymentProgress progress = this.deploymentManager.stop(DEPLOYMENT_PHASE, allUploaded);
                progress.run();
                progress = this.deploymentManager.undeploy(DEPLOYMENT_PHASE, allUploaded);
                progress.run();
            }
            this.deployed = false;
        }
    }

    protected VFSDeployment add(Profile profile, VirtualFile file) throws Exception {
        VFSDeployment deployment = this.createDeployment(file);
        if (this.deploymentManager == null) {
            if (!profile.hasDeployment(deployment.getName(), DEPLOYMENT_PHASE)) {
                profile.addDeployment(deployment, DEPLOYMENT_PHASE);
                this.mainDeployer.addDeployment((Deployment)deployment);
            }
        } else {
            this.activateProfile(profile.getKey());
            String name = file.getPathName();
            DeploymentProgress progress = this.deploymentManager.distribute(name, DEPLOYMENT_PHASE, file.toURL());
            progress.run();
            String[] repoNames = progress.getDeploymentID().getRepositoryNames();
            if (repoNames != null) {
                for (String repoName : repoNames) {
                    this.uploadedNames.add(repoName);
                }
            }
        }
        return deployment;
    }

    protected void remove(Profile profile, String name) throws Exception {
        if (this.deploymentManager == null && profile.hasDeployment(name, DEPLOYMENT_PHASE)) {
            profile.removeDeployment(name, DEPLOYMENT_PHASE);
            this.mainDeployer.removeDeployment(name);
        }
    }

    private void activateProfile(ProfileKey key) throws Exception {
        if (this.activeProfile != key) {
            this.deploymentManager.loadProfile(key, false);
            this.activeProfile = key;
        }
    }

    private String[] getAllUploadedNames() {
        String[] result = new String[this.uploadedNames.size()];
        return this.uploadedNames.toArray(result);
    }
}

