/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton.examples;

import java.io.Serializable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public class HASingletonPojoExample
implements Serializable {
    private static final long serialVersionUID = 6823691561869778917L;
    private static Logger log = Logger.getLogger(HASingletonPojoExample.class);
    private final String jndiName;
    private boolean isMasterNode;

    public HASingletonPojoExample(String jndiName) {
        this.jndiName = jndiName;
    }

    public void startSingleton() throws NamingException {
        this.isMasterNode = true;
        InitialContext ctx = new InitialContext();
        Util.rebind((Context)ctx, (String)this.jndiName, (Object)this);
        log.info((Object)("Notified to start as singleton and bound to jndi under " + this.jndiName));
    }

    public boolean isMasterNode() {
        return this.isMasterNode;
    }

    public void stopSingleton() throws NamingException {
        this.isMasterNode = false;
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, (String)this.jndiName);
        log.info((Object)("Notified to stop as singleton and unbound from jndi under " + this.jndiName));
    }
}

