/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.HARMIProxy;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HARMIClient
implements HARMIProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = -1227816478666532463L;
    private static final Logger log = Logger.getLogger(HARMIClient.class);
    protected static final Method TO_STRING;
    protected static final Method HASH_CODE;
    protected static final Method EQUALS;
    protected String key = null;
    protected org.jboss.ha.client.loadbalance.LoadBalancePolicy loadBalancePolicy;
    protected transient Object local = null;
    protected transient boolean trace;
    FamilyClusterInfo familyClusterInfo = null;

    public HARMIClient() {
    }

    public HARMIClient(List<?> targets, org.jboss.ha.client.loadbalance.LoadBalancePolicy policy, String key) {
        this(targets, 0L, policy, key, null);
    }

    public HARMIClient(List<?> targets, long initViewId, org.jboss.ha.client.loadbalance.LoadBalancePolicy policy, String key, Object local) {
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)key, targets, (long)initViewId);
        this.loadBalancePolicy = policy;
        if (this.loadBalancePolicy instanceof LoadBalancePolicy) {
            ((LoadBalancePolicy)this.loadBalancePolicy).init(this);
        }
        this.key = key;
        this.local = local;
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("Init, cluterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy));
        }
    }

    public void updateClusterInfo(List<?> targets, long viewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo(targets, viewId);
        }
    }

    public Object getRemoteTarget() {
        return this.loadBalancePolicy.chooseTarget(this.familyClusterInfo);
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    public Method findLocalMethod(Method method, Object[] args) throws Exception {
        return method;
    }

    public Object invokeRemote(Object proxy, Method method, Object[] args) throws Throwable {
        boolean trace = log.isTraceEnabled();
        HARMIServer target = (HARMIServer)this.getRemoteTarget();
        RemoteException nsoe = null;
        RemoteException lastException = null;
        while (target != null) {
            try {
                if (trace) {
                    log.trace((Object)("Invoking on target=" + target));
                }
                MarshalledInvocation mi = new MarshalledInvocation(null, method, args, null, null, null);
                mi.setObjectName((Object)"");
                HARMIResponse rsp = target.invoke(this.familyClusterInfo.getCurrentViewId(), mi);
                if (rsp.newReplicants != null) {
                    if (trace) {
                        log.trace((Object)("newReplicants: " + rsp.newReplicants));
                    }
                    this.updateClusterInfo(rsp.newReplicants, rsp.currentViewId);
                }
                return rsp.response;
            }
            catch (ConnectException e) {
                lastException = e;
            }
            catch (ConnectIOException e) {
                lastException = e;
            }
            catch (NoSuchObjectException e) {
                nsoe = e;
                lastException = e;
            }
            catch (UnknownHostException e) {
                lastException = e;
            }
            if (trace) {
                log.trace((Object)("Invoke failed, target=" + target), (Throwable)lastException);
            }
            this.remoteTargetHasFailed(target);
            target = (HARMIServer)this.getRemoteTarget();
        }
        ConnectException toWrap = nsoe == null ? lastException : nsoe;
        throw new RemoteException("Service unavailable.", toWrap);
    }

    @Override
    public boolean isLocal() {
        return this.local != null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (method.equals(TO_STRING)) {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('(');
            tmp.append(this.familyClusterInfo);
            tmp.append(')');
            return tmp.toString();
        }
        if (name.equals("equals")) {
            return method.invoke((Object)this, args);
        }
        if (name.equals("hashCode")) {
            return method.invoke((Object)this, args);
        }
        if (name.equals("isLocal") && (args == null || args.length == 0)) {
            return method.invoke((Object)this, args);
        }
        if (this.local != null) {
            try {
                Method localMethod = this.findLocalMethod(method, args);
                return localMethod.invoke(this.local, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        return this.invokeRemote(null, method, args);
    }

    protected void removeDeadTarget(Object target) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.removeDeadTarget(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.key = stream.readUTF();
        List<?> targets = (List<?>)stream.readObject();
        long vid = stream.readLong();
        this.loadBalancePolicy = (org.jboss.ha.client.loadbalance.LoadBalancePolicy)stream.readObject();
        HARMIServer server = HARMIServer.rmiServers.get(this.key);
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)this.key, (List)targets, (long)vid);
        if (this.loadBalancePolicy instanceof LoadBalancePolicy) {
            ((LoadBalancePolicy)this.loadBalancePolicy).init(this);
        }
        if (server != null) {
            List<?> list = targets;
            synchronized (list) {
                try {
                    targets = server.getReplicants();
                    this.local = server.getLocal();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("Init, clusterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        ArrayList currentTargets = null;
        long vid = 0L;
        FamilyClusterInfo familyClusterInfo = this.familyClusterInfo;
        synchronized (familyClusterInfo) {
            currentTargets = new ArrayList(this.familyClusterInfo.getTargets());
            vid = this.familyClusterInfo.getCurrentViewId();
        }
        stream.writeUTF(this.key);
        stream.writeObject(currentTargets);
        stream.writeLong(vid);
        stream.writeObject(this.loadBalancePolicy);
    }

    static {
        try {
            Class[] empty = new Class[]{};
            Class<Object> type = Object.class;
            TO_STRING = type.getMethod("toString", empty);
            HASH_CODE = type.getMethod("hashCode", empty);
            EQUALS = type.getMethod("equals", type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

