/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.resource.adapter.jdbc;

import java.sql.SQLException;

/**
 * The ExceptionSorter interface allows for <code>java.sql.SQLException</code>
 * evaluation to determine if an error is fatal. 
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @author <a href="mailto:weston.price@jboss.com>Weston Price</a>
 * 
 * @see ValidConnectionChecker
 * @see CheckValidConnectionSQL
 *  
 * @version $Revision: 46133 $
 */

public interface ExceptionSorter
{
   
   
   /**
    * Evaluates a <code>java.sql.SQLException</code> to determine if
    * the error was fatal
    * 
    * @param e the <code>java.sql.SQLException</code>
    * 
    * @return whether or not the exception is vatal.
    */
   boolean isExceptionFatal(SQLException e);
}
