package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

/**
 * A SybaseValidConnectionChecker.
 * 
 * @author <a href="weston.price@jboss.com">Weston Price</a>
 * @version $Revision: 1.1 $
 */
public class SybaseValidConnectionChecker implements ValidConnectionChecker, Serializable
{
   private static final Logger log = Logger.getLogger(SybaseValidConnectionChecker.class);
   
   /** The serialVersionUID */
   private static final long serialVersionUID = 4179707462244257791L;
   
   /** The VALID_QUERY */
   private static final String VALID_QUERY = "SELECT getdate()";
   
   
   public SQLException isValidConnection(Connection c)
   {
      SQLException sqe = null;
      Statement s = null;
      ResultSet rs = null;
      
         try
         {
            s = c.createStatement();
            rs = s.executeQuery(VALID_QUERY);
            
         }catch (SQLException e)
         {
                   
            sqe = e;
            
         }finally
         {
            
            try
            {
               if(s != null)
               {
                  s.close();
                  
               }
            }
            
            catch (SQLException ignore)
            {
               log.warn("JDBC resource for " + this + " could not be closed");
               
            }
         
            try
            {
               if(rs != null)
               {
                  rs.close();
               }
            }
            
            catch (SQLException ignore)
            {
               log.warn("JDBC resource for " + this + " could not be closed");
            }
         }
                  
      
      return sqe;
   }

}
