package org.jboss.resource.metadata.repository;

import javax.resource.spi.ActivationSpec;

import org.jboss.resource.deployment.AdminObject;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;

/**
 * A JCAMetaDataRepository.
 * 
 * @author <a href="weston.price@jboss.org">Weston Price</a>
 * @version $Revision: 1.1 $
 */
public interface JCAMetaDataRepository
{   
   public int getConnectorMetaDataCount();
   
   public int getActivationSpecCount();
   
   public int getManagedConnectionFactoryCount();
   
   public int getAdminObjectCount();
   
   public void setFormatterClassName(String formatterClassName);
   
   public String getFormatterClassName();
   
   public void addConnectorMetaData(String name, ConnectorMetaData cmd);
   
   public ConnectorMetaData getConnectorMetaData(String name);
   
   public void addActivationSpec(String rarName, ActivationSpec spec);
   
   public void addManagedConnectionFactoryDeploymentGroup(ManagedConnectionFactoryDeploymentGroup group);
   
   public void addAdminObject(String rarName, AdminObject adminObject);
   
   public Object listDeploymentsForConnector(String rarName);
     
   
}
