/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.resource.metadata.mcf.DBMSMetaData;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsDataSourceTemplateInfo
extends BasicDeploymentTemplateInfo {
    private static final long serialVersionUID = 1L;
    private static MetaValueFactory METAVALUE_FACTORY = MetaValueFactory.getInstance();
    private static final MetaTypeFactory METATYPE_FACTORY = MetaTypeFactory.getInstance();
    private Map<String, String> propertyNameMappings;
    private String dsType = "local-tx-datasource";

    public DsDataSourceTemplateInfo(String arg0, String arg1, Map<String, ManagedProperty> arg2) {
        super(arg0, arg1, arg2);
    }

    public DsDataSourceTemplateInfo(String name, String description, String datasourceType) {
        super(name, description);
        this.dsType = datasourceType;
    }

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
        this.propertyNameMappings = propertyNameMappings;
    }

    public String getConnectionFactoryType() {
        return this.dsType;
    }

    public void setConnectionFactoryType(String dsType) {
        this.dsType = dsType;
    }

    public void start() {
        if ("local-tx-datasource".equals(this.dsType)) {
            this.createLocalTxDsTemplate();
        } else if ("xa-datasource".equals(this.dsType)) {
            this.createXaDsTemplate();
        } else if ("tx-connection-factory".equals(this.dsType)) {
            this.createTxCfTemplate();
        } else if ("no-tx-datasource".equals(this.dsType)) {
            this.createNoTxDsTemplate();
        } else if ("no-tx-connection-factory".equals(this.dsType)) {
            this.createNoTxCfTemplate();
        } else {
            throw new IllegalStateException("Unsupported dsType: " + this.dsType);
        }
    }

    private void createXaDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(XADataSourceDeploymentMetaData.class.getName());
        this.addDsProperties(mo);
        this.addManagedProperty("xa-datasource-class", "The xa datasource class name", true, (MetaType)SimpleMetaType.STRING, mo);
        MapCompositeMetaType type = new MapCompositeMetaType((MetaType)SimpleMetaType.STRING);
        this.addManagedProperty("xa-datasource-properties", "The xa datasource properties", false, (MetaType)type, mo);
        this.addManagedProperty("url-property", "The URL property", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
    }

    private void createLocalTxDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(LocalDataSourceDeploymentMetaData.class.getName());
        this.addNonXADsProperties(mo);
    }

    private void createNoTxDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(NoTxDataSourceDeploymentMetaData.class.getName());
        this.addNonXADsProperties(mo);
    }

    private void createTxCfTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(TxConnectionFactoryDeploymentMetaData.class.getName());
        this.addCommonProperties(mo);
        this.addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("xa-transaction", "", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
    }

    private void createNoTxCfTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(NoTxConnectionFactoryDeploymentMetaData.class.getName());
        this.addCommonProperties(mo);
    }

    private void addNonXADsProperties(ManagedObjectImpl mo) {
        this.addDsProperties(mo);
        this.addManagedProperty("driver-class", "The jdbc driver class name", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("connection-url", "The jdbc url of the DataSource", true, (MetaType)SimpleMetaType.STRING, mo);
        MapCompositeMetaType type = new MapCompositeMetaType((MetaType)SimpleMetaType.STRING);
        this.addManagedProperty("connection-properties", "The jdbc driver connection properties", false, (MetaType)type, mo);
    }

    private void addDsProperties(ManagedObjectImpl mo) {
        this.addCommonProperties(mo);
        this.addManagedProperty("transaction-isolation", "The transaction isolation level", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("user-name", "The username for the connection-url", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("password", "The password for the connection-url", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("new-connection-sql", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("check-valid-connection-sql", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("valid-connection-checker-class-name", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("exception-sorter-class-name", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("stale-connection-checker-class-name", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("track-statements", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("prepared-statement-cache-size", "", false, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("share-prepared-statements", "", false, (MetaType)SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("set-tx-query-timeout", "", false, (MetaType)SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("query-timeout", "", false, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("url-delimiter", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("url-selector-strategy-class-name", "", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("use-try-lock", "", false, (MetaType)SimpleMetaType.LONG, mo);
    }

    private void addCommonProperties(ManagedObjectImpl mo) {
        this.addManagedProperty("jndi-name", "The jndi name to bind the DataSource under", true, true, (MetaType)SimpleMetaType.STRING, (Serializable)((Object)""), mo);
        this.addManagedProperty("rar-name", "The resource adapter archive name", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("use-java-context", "Whether to bind the connection factory under 'java:' context", true, (MetaType)SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
        this.addManagedProperty("connection-definition", "The connection factory class name", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("jmx-invoker-name", "The name of the JMX invoker", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("min-pool-size", "The min size of the pool", true, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("max-pool-size", "The max size of the pool", true, (MetaType)SimpleMetaType.INTEGER, new Integer(10), mo);
        this.addManagedProperty("blocking-timeout-millis", "The time to wait for a connection to become available before giving up", true, (MetaType)SimpleMetaType.LONG, new Long(30000L), mo);
        this.addManagedProperty("idle-timeout-minutes", "The idle timeout in minutes", true, (MetaType)SimpleMetaType.INTEGER, new Integer(30), mo);
        this.addManagedProperty("prefill", "Whether to prefill the pool", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("background-validation", "Whether to use backgroup validation", true, (MetaType)SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("background-validation-millis", "", false, (MetaType)SimpleMetaType.LONG, new Long(0L), mo);
        this.addManagedProperty("validate-on-match", "", true, (MetaType)SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
        this.addManagedProperty("use-strict-min", "", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("no-tx-separate-pools", "", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("statistics-formatter", "", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("isSameRM-override-value", "", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("track-connection-by-tx", "", false, (MetaType)SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
        this.addManagedProperty("interleaving", "", false, (MetaType)SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("allocation-retry", "The number of times allocation retries should be tried", false, (MetaType)SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("allocation-retry-wait-millis", "The time to wait between allocation retries", false, (MetaType)SimpleMetaType.LONG, new Long(5000L), mo);
        this.addManagedProperty("config-property", "The connection factory config properties", false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("security-domain", "The security-domain used to validate connections", false, (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, mo);
        this.addManagedProperty("depends", "", false, METATYPE_FACTORY.resolve(List.class), mo);
        this.addManagedProperty("metadata", "", false, METATYPE_FACTORY.resolve(DBMSMetaData.class), mo);
        this.addManagedProperty("type-mapping", "", true, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("local-transaction", "", true, (MetaType)SimpleMetaType.BOOLEAN, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, ManagedObjectImpl mo) {
        this.addManagedProperty(fieldName, fieldDescr, mandatory, false, metaType, (MetaValue)null, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, Serializable value, ManagedObjectImpl mo) {
        MetaValue mv = METAVALUE_FACTORY.create((Object)value);
        this.addManagedProperty(fieldName, fieldDescr, mandatory, false, metaType, mv, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, MetaValue value, ManagedObjectImpl mo) {
        this.addManagedProperty(fieldName, fieldDescr, mandatory, false, metaType, value, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, boolean isID, MetaType metaType, Serializable value, ManagedObjectImpl mo) {
        MetaValue mv = METAVALUE_FACTORY.create((Object)value);
        this.addManagedProperty(fieldName, fieldDescr, mandatory, isID, metaType, mv, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, boolean isID, MetaType metaType, MetaValue value, ManagedObjectImpl mo) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        this.setFieldName(fieldName, (Fields)fields);
        fields.setDescription(fieldDescr);
        fields.setMandatory(mandatory);
        fields.setMetaType(metaType);
        ManagedPropertyImpl mp = new ManagedPropertyImpl((ManagedObject)mo, (Fields)fields);
        if (isID) {
            HashMap<String, ManagementObjectID> annotations = new HashMap<String, ManagementObjectID>();
            Map idFields = Collections.emptyMap();
            try {
                ManagementObjectID id = (ManagementObjectID)AnnotationProxy.createProxy(idFields, ManagementObjectID.class);
                annotations.put(ManagementObjectID.class.getName(), id);
                mp.setAnnotations(annotations);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        super.addProperty((ManagedProperty)mp);
        if (value != null) {
            if (!(value instanceof MetaValue)) {
                value = METAVALUE_FACTORY.create((Object)value);
            }
            mp.setValue(value);
        }
    }

    protected void setFieldName(String name, Fields f) {
        String mappedName;
        f.setField("name", (Object)name);
        if (this.propertyNameMappings != null && (mappedName = this.propertyNameMappings.get(name)) != null) {
            f.setField("mappedName", (Object)mappedName);
        }
    }
}

