/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsManagedConnection;
import org.jboss.resource.adapter.jms.JmsMessageConsumer;
import org.jboss.resource.adapter.jms.JmsMessageProducer;
import org.jboss.resource.adapter.jms.JmsQueueReceiver;
import org.jboss.resource.adapter.jms.JmsQueueSender;
import org.jboss.resource.adapter.jms.JmsSessionFactoryImpl;
import org.jboss.resource.adapter.jms.JmsTopicPublisher;
import org.jboss.resource.adapter.jms.JmsTopicSubscriber;

public class JmsSession
implements Session,
QueueSession,
TopicSession {
    private static final Logger log = Logger.getLogger(JmsSession.class);
    private JmsManagedConnection mc;
    private JmsConnectionRequestInfo info;
    private JmsSessionFactoryImpl sf;
    private HashSet consumers = new HashSet();
    private HashSet producers = new HashSet();
    private boolean trace = log.isTraceEnabled();

    public JmsSession(JmsManagedConnection mc, JmsConnectionRequestInfo info) {
        this.mc = mc;
        this.info = info;
        if (this.trace) {
            log.trace((Object)("new JmsSession " + this + " mc=" + mc + " cri=" + info));
        }
    }

    public void setJmsSessionFactory(JmsSessionFactoryImpl sf) {
        this.sf = sf;
    }

    protected void lock() throws JMSException {
        JmsManagedConnection mc = this.mc;
        if (mc == null) {
            throw new IllegalStateException("Connection is not associated with a managed connection. " + this);
        }
        mc.tryLock();
    }

    protected void unlock() {
        JmsManagedConnection mc = this.mc;
        if (mc != null) {
            mc.unlock();
        }
    }

    Session getSession() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        this.checkTransactionActive();
        Session session = this.mc.getSession();
        if (this.trace) {
            log.trace((Object)("getSession " + session + " for " + this));
        }
        return session;
    }

    void checkTransactionActive() throws IllegalStateException {
        if (this.sf != null) {
            this.sf.checkTransactionActive();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createBytesMessage" + session));
        }
        return session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createMapMessage" + session));
        }
        return session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createMessage" + session));
        }
        return session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createObjectMessage" + session));
        }
        return session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createObjectMessage(Object)" + session));
        }
        return session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createStreamMessage" + session));
        }
        return session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createTextMessage" + session));
        }
        return session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createTextMessage(String)" + session));
        }
        return session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        this.getSession();
        return this.info.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    public void run() {
        throw new Error("Method not allowed");
    }

    public void close() throws JMSException {
        this.sf.closeSession(this);
        this.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (!this.info.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (this.trace) {
                log.trace((Object)("Commit session " + this));
            }
            session.commit();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (!this.info.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (this.trace) {
                log.trace((Object)("Rollback session " + this));
            }
            session.rollback();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.info.isTransacted()) {
                throw new IllegalStateException("Session is transacted");
            }
            if (this.trace) {
                log.trace((Object)("Recover session " + this));
            }
            session.recover();
        }
        finally {
            this.unlock();
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create topic for javax.jms.QueueSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createTopic " + session + " topicName=" + topicName));
        }
        Topic result = session.createTopic(topicName);
        if (this.trace) {
            log.trace((Object)("createdTopic " + session + " topic=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSession();
            if (this.trace) {
                log.trace((Object)("createSubscriber " + session + " topic=" + topic));
            }
            TopicSubscriber result = session.createSubscriber(topic);
            result = new JmsTopicSubscriber(result, this);
            if (this.trace) {
                log.trace((Object)("createdSubscriber " + session + " JmsTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSession();
            if (this.trace) {
                log.trace((Object)("createSubscriber " + session + " topic=" + topic + " selector=" + messageSelector + " noLocal=" + noLocal));
            }
            TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
            result = new JmsTopicSubscriber(result, this);
            if (this.trace) {
                log.trace((Object)("createdSubscriber " + session + " JmsTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create durable subscriber from javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createDurableSubscriber " + session + " topic=" + topic + " name=" + name));
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name);
            result = new JmsTopicSubscriber(result, this);
            if (this.trace) {
                log.trace((Object)("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createDurableSubscriber " + session + " topic=" + topic + " name=" + name + " selector=" + messageSelector + " noLocal=" + noLocal));
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
            result = new JmsTopicSubscriber(result, this);
            if (this.trace) {
                log.trace((Object)("createdDurableSubscriber " + session + " JmsTopicSubscriber=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSession();
            if (this.trace) {
                log.trace((Object)("createPublisher " + session + " topic=" + topic));
            }
            TopicPublisher result = session.createPublisher(topic);
            result = new JmsTopicPublisher(result, this);
            if (this.trace) {
                log.trace((Object)("createdPublisher " + session + " publisher=" + result));
            }
            this.addProducer((MessageProducer)result);
            TopicPublisher topicPublisher = result;
            return topicPublisher;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot create temporary topic for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createTemporaryTopic " + session));
            }
            TemporaryTopic temp = session.createTemporaryTopic();
            if (this.trace) {
                log.trace((Object)("createdTemporaryTopic " + session + " temp=" + temp));
            }
            this.sf.addTemporaryTopic(temp);
            TemporaryTopic temporaryTopic = temp;
            return temporaryTopic;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String name) throws JMSException {
        if (this.info.getType() == 1) {
            throw new IllegalStateException("Cannot unsubscribe for javax.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("unsubscribe " + session + " name=" + name));
            }
            session.unsubscribe(name);
        }
        finally {
            this.unlock();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create browser for javax.jms.TopicSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createBrowser " + session + " queue=" + queue));
        }
        QueueBrowser result = session.createBrowser(queue);
        if (this.trace) {
            log.trace((Object)("createdBrowser " + session + " browser=" + result));
        }
        return result;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createBrowser " + session + " queue=" + queue + " selector=" + messageSelector));
        }
        QueueBrowser result = session.createBrowser(queue, messageSelector);
        if (this.trace) {
            log.trace((Object)("createdBrowser " + session + " browser=" + result));
        }
        return result;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create browser or javax.jms.TopicSession");
        }
        Session session = this.getSession();
        if (this.trace) {
            log.trace((Object)("createQueue " + session + " queueName=" + queueName));
        }
        Queue result = session.createQueue(queueName);
        if (this.trace) {
            log.trace((Object)("createdQueue " + session + " queue=" + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSession();
            if (this.trace) {
                log.trace((Object)("createReceiver " + session + " queue=" + queue));
            }
            QueueReceiver result = session.createReceiver(queue);
            result = new JmsQueueReceiver(result, this);
            if (this.trace) {
                log.trace((Object)("createdReceiver " + session + " receiver=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSession();
            if (this.trace) {
                log.trace((Object)("createReceiver " + session + " queue=" + queue + " selector=" + messageSelector));
            }
            QueueReceiver result = session.createReceiver(queue, messageSelector);
            result = new JmsQueueReceiver(result, this);
            if (this.trace) {
                log.trace((Object)("createdReceiver " + session + " receiver=" + result));
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSession();
            if (this.trace) {
                log.trace((Object)("createSender " + session + " queue=" + queue));
            }
            QueueSender result = session.createSender(queue);
            result = new JmsQueueSender(result, this);
            if (this.trace) {
                log.trace((Object)("createdSender " + session + " sender=" + result));
            }
            this.addProducer((MessageProducer)result);
            QueueSender queueSender = result;
            return queueSender;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.info.getType() == 2) {
            throw new IllegalStateException("Cannot create temporary queue for javax.jms.TopicSession");
        }
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createTemporaryQueue " + session));
            }
            TemporaryQueue temp = session.createTemporaryQueue();
            if (this.trace) {
                log.trace((Object)("createdTemporaryQueue " + session + " temp=" + temp));
            }
            this.sf.addTemporaryQueue(temp);
            TemporaryQueue temporaryQueue = temp;
            return temporaryQueue;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination));
            }
            MessageConsumer result = session.createConsumer(destination);
            result = new JmsMessageConsumer(result, this);
            if (this.trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector));
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector);
            result = new JmsMessageConsumer(result, this);
            if (this.trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector + " noLocal=" + noLocal));
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
            result = new JmsMessageConsumer(result, this);
            if (this.trace) {
                log.trace((Object)("createdConsumer " + session + " consumer=" + result));
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSession();
            if (this.trace) {
                log.trace((Object)("createProducer " + session + " dest=" + destination));
            }
            MessageProducer result = this.getSession().createProducer(destination);
            result = new JmsMessageProducer(result, this);
            if (this.trace) {
                log.trace((Object)("createdProducer " + session + " producer=" + result));
            }
            this.addProducer(result);
            MessageProducer messageProducer = result;
            return messageProducer;
        }
        finally {
            this.unlock();
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        this.getSession();
        return this.info.getAcknowledgeMode();
    }

    void setManagedConnection(JmsManagedConnection mc) {
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = mc;
    }

    void destroy() {
        this.mc = null;
    }

    void start() throws JMSException {
        if (this.mc != null) {
            this.mc.start();
        }
    }

    void stop() throws JMSException {
        if (this.mc != null) {
            this.mc.stop();
        }
    }

    void checkStrict() throws JMSException {
        if (this.mc != null && this.mc.getManagedConnectionFactory().isStrict()) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws JMSException {
        if (this.mc != null) {
            Iterator i;
            log.trace((Object)"Closing session");
            try {
                this.mc.stop();
            }
            catch (Throwable t) {
                log.trace((Object)"Error stopping managed connection", t);
            }
            HashSet t = this.consumers;
            synchronized (t) {
                i = this.consumers.iterator();
                while (i.hasNext()) {
                    JmsMessageConsumer consumer = (JmsMessageConsumer)i.next();
                    try {
                        consumer.closeConsumer();
                    }
                    catch (Throwable t2) {
                        log.trace((Object)"Error closing consumer", t2);
                    }
                    i.remove();
                }
            }
            t = this.producers;
            synchronized (t) {
                i = this.producers.iterator();
                while (i.hasNext()) {
                    JmsMessageProducer producer = (JmsMessageProducer)i.next();
                    try {
                        producer.closeProducer();
                    }
                    catch (Throwable t3) {
                        log.trace((Object)"Error closing producer", t3);
                    }
                    i.remove();
                }
            }
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 1);
            ev.setConnectionHandle((Object)this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer consumer) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer consumer) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer producer) {
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer producer) {
        HashSet hashSet = this.producers;
        synchronized (hashSet) {
            this.producers.remove(producer);
        }
    }

    QueueSession getQueueSession() throws JMSException {
        Session s = this.getSession();
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
        }
        return (QueueSession)s;
    }

    TopicSession getTopicSession() throws JMSException {
        Session s = this.getSession();
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
        }
        return (TopicSession)s;
    }
}

