/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.vfs.spi.deployer.MultipleObjectModelFactoryDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.resource.deployment.JBossRAObjectModelFactory;
import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.JBossRAMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;
import org.jboss.resource.metadata.repository.JCAMetaDataRepository;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;

public class RARParserDeployer
extends MultipleObjectModelFactoryDeployer<RARDeploymentMetaData> {
    private JCAMetaDataRepository metaDataRepository;
    private static String jeeSpecRarDD = "ra.xml";
    private static String jbossRarDD = "jboss-ra.xml";

    private static Map<String, Class<?>> getCustomMappings() {
        HashMap mappings = new HashMap();
        mappings.put(jeeSpecRarDD, ConnectorMetaData.class);
        mappings.put(jbossRarDD, JBossRAMetaData.class);
        return mappings;
    }

    public RARParserDeployer() {
        super(RARDeploymentMetaData.class, RARParserDeployer.getCustomMappings());
        this.setBuildManagedObject(true);
        this.addInput("org.jboss.metadata.ear.spec.EarMetaData");
    }

    protected <U> ObjectModelFactory getObjectModelFactory(Class<U> expectedType, String fileName, U root) {
        if (ConnectorMetaData.class.equals(expectedType)) {
            return new ResourceAdapterObjectModelFactory();
        }
        if (JBossRAMetaData.class.equals(expectedType)) {
            return new JBossRAObjectModelFactory();
        }
        throw new IllegalArgumentException("Cannot match arguments: expectedClass=" + expectedType + ", fileName=" + fileName);
    }

    protected RARDeploymentMetaData mergeMetaData(VFSDeploymentUnit unit, Map<Class<?>, List<Object>> metadata) throws Exception {
        JBossRAMetaData jrmd;
        RARDeploymentMetaData deployment = new RARDeploymentMetaData();
        ConnectorMetaData cmd = (ConnectorMetaData)this.getInstance(metadata, ConnectorMetaData.class);
        if (cmd != null) {
            deployment.setConnectorMetaData(cmd);
        }
        if ((jrmd = (JBossRAMetaData)this.getInstance(metadata, JBossRAMetaData.class)) != null) {
            deployment.setRaXmlMetaData(jrmd);
        }
        VFSDeploymentUnit parent = unit.getParent();
        String name = unit.getSimpleName();
        if (parent != null) {
            name = parent.getSimpleName() + "#" + name;
        }
        VirtualFile file = unit.getMetaDataFile(jeeSpecRarDD);
        deployment.getConnectorMetaData().setURL(file.toURL());
        this.metaDataRepository.addConnectorMetaData(name, deployment.getConnectorMetaData());
        return deployment;
    }

    public JCAMetaDataRepository getMetaDataRepository() {
        return this.metaDataRepository;
    }

    public void setMetaDataRepository(JCAMetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }
}

