/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.PrintWriter;
import java.util.Set;
import javax.jms.ConnectionMetaData;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionFactoryImpl;
import org.jboss.resource.adapter.jms.JmsConnectionMetaData;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsCred;
import org.jboss.resource.adapter.jms.JmsMCFProperties;
import org.jboss.resource.adapter.jms.JmsManagedConnection;

public class JmsManagedConnectionFactory
implements ManagedConnectionFactory {
    private static final long serialVersionUID = -923483284031773011L;
    private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
    private JmsMCFProperties mcfProperties = new JmsMCFProperties();
    private boolean strict = true;
    private JMSProviderAdapter adapter;
    private int useTryLock = 60;

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        JmsConnectionFactoryImpl cf = new JmsConnectionFactoryImpl(this, cxManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created connection factory: " + cf + ", using connection manager: " + cxManager));
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        boolean trace = log.isTraceEnabled();
        info = this.getInfo(info);
        if (trace) {
            log.trace((Object)("connection request info: " + info));
        }
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        if (trace) {
            log.trace((Object)("jms credentials: " + cred));
        }
        JmsManagedConnection mc = new JmsManagedConnection(this, info, cred.name, cred.pwd);
        if (trace) {
            log.trace((Object)("created new managed connection: " + mc));
        }
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        boolean trace = log.isTraceEnabled();
        info = this.getInfo(info);
        JmsCred cred = JmsCred.getJmsCred(this, subject, info);
        if (trace) {
            log.trace((Object)("Looking for connection matching credentials: " + cred));
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof JmsManagedConnection)) continue;
            JmsManagedConnection mc = (JmsManagedConnection)obj;
            JmsManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(cred.name)) || !((Object)mcf).equals(this) || !info.equals(mc.getInfo())) continue;
            if (trace) {
                log.trace((Object)("Found matching connection: " + mc));
            }
            return mc;
        }
        if (trace) {
            log.trace((Object)"No matching connection was found");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof JmsManagedConnectionFactory) {
            return this.mcfProperties.equals(((JmsManagedConnectionFactory)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        return this.mcfProperties.hashCode();
    }

    public void setJmsProviderAdapterJNDI(String jndi) {
        this.mcfProperties.setProviderJNDI(jndi);
    }

    public String getJmsProviderAdapterJNDI() {
        return this.mcfProperties.getProviderJNDI();
    }

    public void setUserName(String userName) {
        this.mcfProperties.setUserName(userName);
    }

    public String getUserName() {
        return this.mcfProperties.getUserName();
    }

    public void setPassword(String password) {
        this.mcfProperties.setPassword(password);
    }

    public String getPassword() {
        return this.mcfProperties.getPassword();
    }

    public String getClientID() {
        return this.mcfProperties.getClientID();
    }

    public void setClientID(String clientID) {
        this.mcfProperties.setClientID(clientID);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public void setSessionDefaultType(String type) throws ResourceException {
        this.mcfProperties.setSessionDefaultType(type);
    }

    public String getSessionDefaultType() {
        return this.mcfProperties.getSessionDefaultType();
    }

    public void setJmsProviderAdapter(JMSProviderAdapter adapter) {
        this.adapter = adapter;
    }

    public JMSProviderAdapter getJmsProviderAdapter() {
        return this.adapter;
    }

    public int getUseTryLock() {
        return this.useTryLock;
    }

    public void setUseTryLock(int useTryLock) {
        this.useTryLock = useTryLock;
    }

    private ConnectionRequestInfo getInfo(ConnectionRequestInfo info) {
        if (info == null) {
            return new JmsConnectionRequestInfo(this.mcfProperties);
        }
        ((JmsConnectionRequestInfo)info).setDefaults(this.mcfProperties);
        return info;
    }

    public ConnectionMetaData getMetaData() {
        return new JmsConnectionMetaData();
    }

    protected JmsMCFProperties getProperties() {
        return this.mcfProperties;
    }
}

