/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.statistic.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.resource.statistic.JBossStatistics;
import org.jboss.resource.statistic.pool.JBossSubPoolStatistics;
import org.jboss.resource.statistic.pool.ManagedConnectionPoolStatistics;

public class JBossManagedConnectionPoolStatistics
implements ManagedConnectionPoolStatistics {
    private static final long serialVersionUID = -2962342009092796221L;
    private String poolName;
    private long blockingTimeout;
    private long idleTimeout;
    private int min;
    private int max;
    private String criteria;
    private boolean noTxnSeperatePool;
    private final List subPools;
    private boolean prefill;

    public JBossManagedConnectionPoolStatistics() {
        this.subPools = new ArrayList();
    }

    public JBossManagedConnectionPoolStatistics(int subPoolSize) {
        this.subPools = new ArrayList(subPoolSize);
    }

    public JBossManagedConnectionPoolStatistics(String poolName) {
        this();
        this.poolName = poolName;
    }

    public void addSubPool(JBossSubPoolStatistics subPool) {
        this.subPools.add(subPool);
    }

    @Override
    public Collection getSubPools() {
        return Collections.unmodifiableCollection(this.subPools);
    }

    @Override
    public long getBlockingTimeout() {
        return this.blockingTimeout;
    }

    @Override
    public void setBlockingTimeout(long blockTime) {
        this.blockingTimeout = blockTime;
    }

    @Override
    public String getCriteria() {
        return this.criteria;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public void setMin(int min) {
        this.min = min;
    }

    @Override
    public boolean getNoTxnSeperatePool() {
        return this.noTxnSeperatePool;
    }

    @Override
    public void setNoTxnSeperatePool(boolean noTxnSeperatePool) {
        this.noTxnSeperatePool = noTxnSeperatePool;
    }

    @Override
    public JBossManagedConnectionPoolStatistics getStatistics() {
        return null;
    }

    @Override
    public int getSubPoolCount() {
        return this.subPools.size();
    }

    @Override
    public int getTotalConnectionsInUseCount() {
        int statValue = 0;
        for (JBossSubPoolStatistics statGroup : this.subPools) {
            statValue += statGroup.getConnectionsInUse();
        }
        return statValue;
    }

    @Override
    public int getTotalMaxConnectionsInUseCount() {
        int statValue = 0;
        for (JBossSubPoolStatistics statGroup : this.subPools) {
            statValue += statGroup.getMaxConnectionsInUse();
        }
        return statValue;
    }

    @Override
    public boolean getPrefill() {
        return this.prefill;
    }

    @Override
    public void setPrefill(boolean prefill) {
        this.prefill = prefill;
    }

    @Override
    public String getName() {
        return this.poolName;
    }

    @Override
    public void setName(String name) {
        this.poolName = name;
    }

    @Override
    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addSubPool(JBossStatistics subPool) {
        this.subPools.add(subPool);
    }

    public String toString() {
        StringBuffer poolStatBuff = new StringBuffer();
        poolStatBuff.append(" Sub Pool Statistics:");
        poolStatBuff.append("\n Sub Pool Count:" + this.subPools.size());
        poolStatBuff.append("\n\n---------------------------------------------------------------");
        for (JBossSubPoolStatistics statGroup : this.subPools) {
            poolStatBuff.append("\n Available Connections Count:" + statGroup.getAvailableConnections());
            poolStatBuff.append("\n Max Connections In Use Count:" + statGroup.getMaxConnectionsInUse());
            poolStatBuff.append("\n Connections Destroyed Count:" + statGroup.getConnectionsDestroyed());
            poolStatBuff.append("\n Connections In Use Count:" + statGroup.getConnectionsInUse());
            poolStatBuff.append("\n Total Block Time:" + statGroup.getTotalBlockTime());
            poolStatBuff.append("\n Average Block Time For Sub Pool:" + statGroup.getAverageBlockTime());
            poolStatBuff.append("\n Maximum Wait Time For Sub Pool:" + statGroup.getMaxWaitTime());
            poolStatBuff.append("\n Total Timed Out Connections:" + statGroup.getTotalTimedOut());
            poolStatBuff.append("\n\n ---------------------------------------------------------------");
        }
        return poolStatBuff.toString();
    }
}

