/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.ConstructorMetaData;
import org.jboss.aop.metadata.FieldMetaData;
import org.jboss.aop.metadata.MethodMetaData;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.standalone.Package;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;

public class AOPLister
extends AbstractPluginWrapper {
    Thread refreshPoller;

    TreeNode[] createMetaDataTree(SimpleMetaData metaData, String description, String baseUrl) throws Exception {
        HashSet groups = metaData.tags();
        if (groups.size() == 0) {
            return null;
        }
        TreeNode[] nodes = new TreeNode[groups.size()];
        Iterator it = groups.iterator();
        int i = 0;
        while (it.hasNext()) {
            String group = (String)it.next();
            nodes[i] = this.createTreeNode(group, description, "images/database.gif", baseUrl + "&group=" + group, null, null, null);
            ++i;
        }
        return nodes;
    }

    TreeNode[] loadDefaultMetaData(ClassAdvisor advisor, String classname) throws Exception {
        SimpleMetaData metaData = advisor.getDefaultMetaData();
        return this.createMetaDataTree(metaData, "Default metadata for " + classname, "AOPDefaultMetaData.jsp?classname=" + classname);
    }

    TreeNode[] loadClassMetaData(ClassAdvisor advisor, String classname) throws Exception {
        SimpleMetaData metaData = advisor.getClassMetaData();
        return this.createMetaDataTree(metaData, "Class metadata for " + classname, "AOPClassMetaData.jsp?classname=" + classname);
    }

    TreeNode[] loadMethodMetaData(ClassAdvisor advisor, String classname) throws Exception {
        MethodMetaData metaData = advisor.getMethodMetaData();
        Iterator it = metaData.getMethods();
        if (!it.hasNext()) {
            return null;
        }
        ArrayList<SimpleTreeNode> methods = new ArrayList<SimpleTreeNode>();
        while (it.hasNext()) {
            String method = (String)it.next();
            SimpleMetaData methodData = metaData.getMethodMetaData(method);
            TreeNode[] methodNodes = this.createMetaDataTree(methodData, "Metadata for method " + method, "AOPMethodMetaData.jsp?classname=" + classname + "&method=" + URLEncoder.encode(method));
            methods.add(this.createTreeNode(method, "Metadata for method " + method, "images/starfolder.gif", null, null, methodNodes, null));
        }
        return methods.toArray(new TreeNode[methods.size()]);
    }

    TreeNode[] loadFieldMetaData(ClassAdvisor advisor, String classname) throws Exception {
        FieldMetaData metaData = advisor.getFieldMetaData();
        Iterator it = metaData.getFields();
        if (!it.hasNext()) {
            return null;
        }
        ArrayList<SimpleTreeNode> fields = new ArrayList<SimpleTreeNode>();
        while (it.hasNext()) {
            String field = (String)it.next();
            SimpleMetaData fieldData = metaData.getFieldMetaData(field);
            TreeNode[] fieldNodes = this.createMetaDataTree(fieldData, "Metadata for field " + field, "AOPFieldMetaData.jsp?classname=" + classname + "&field=" + field);
            fields.add(this.createTreeNode(field, "Metadata for field " + field, "images/starfolder.gif", null, null, fieldNodes, null));
        }
        return fields.toArray(new TreeNode[fields.size()]);
    }

    TreeNode[] loadConstructorMetaData(ClassAdvisor advisor, String classname) throws Exception {
        ConstructorMetaData metaData = advisor.getConstructorMetaData();
        Iterator it = metaData.getConstructors();
        if (!it.hasNext()) {
            return null;
        }
        ArrayList<SimpleTreeNode> constructors = new ArrayList<SimpleTreeNode>();
        while (it.hasNext()) {
            String signature = (String)it.next();
            SimpleMetaData constructorData = metaData.getConstructorMetaData(signature);
            TreeNode[] constructorNodes = this.createMetaDataTree(constructorData, "Metadata for constructor", "AOPConstructorMetaData.jsp?classname=" + classname + "&constructor=" + URLEncoder.encode(signature));
            constructors.add(this.createTreeNode(signature, "Metaata for constructor " + signature, "images/starfolder.gif", null, null, constructorNodes, null));
        }
        return constructors.toArray(new TreeNode[constructors.size()]);
    }

    TreeNode getMetaData(ClassAdvisor advisor) throws Exception {
        TreeNode[] constructorMetaData;
        TreeNode[] fieldMetaData;
        TreeNode[] methodMetaData;
        TreeNode[] classMetaData;
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        String classname = advisor.getClazz().getName();
        TreeNode[] defaultMetaData = this.loadDefaultMetaData(advisor, classname);
        if (defaultMetaData != null) {
            nodes.add(this.createTreeNode("Default", "Default metadata for for " + classname, "images/starfolder.gif", null, null, defaultMetaData, null));
        }
        if ((classMetaData = this.loadClassMetaData(advisor, classname)) != null) {
            nodes.add(this.createTreeNode("Class", "Class metadata for for " + classname, "images/starfolder.gif", null, null, classMetaData, null));
        }
        if ((methodMetaData = this.loadMethodMetaData(advisor, classname)) != null) {
            nodes.add(this.createTreeNode("Methods", "Method metadata for for " + classname, "images/starfolder.gif", null, null, methodMetaData, null));
        }
        if ((fieldMetaData = this.loadFieldMetaData(advisor, classname)) != null) {
            nodes.add(this.createTreeNode("Fields", "Field metadata for for " + classname, "images/starfolder.gif", null, null, fieldMetaData, null));
        }
        if ((constructorMetaData = this.loadConstructorMetaData(advisor, classname)) != null) {
            nodes.add(this.createTreeNode("Constructors", "Constructor metadata for for " + classname, "images/starfolder.gif", null, null, constructorMetaData, null));
        }
        if (nodes.size() == 0) {
            return null;
        }
        TreeNode[] subnodes = nodes.toArray(new TreeNode[nodes.size()]);
        return this.createTreeNode("Metadata", "Metadata for " + classname, "images/starfolder.gif", null, null, subnodes, null);
    }

    TreeNode[] getIntroductions(ClassAdvisor advisor) throws Exception {
        ArrayList introductions = advisor.getInterfaceIntroductions();
        if (introductions == null || introductions.size() == 0) {
            return null;
        }
        TreeNode[] nodes = new TreeNode[introductions.size()];
        for (int i = 0; i < introductions.size(); ++i) {
            InterfaceIntroduction introduction = (InterfaceIntroduction)introductions.get(i);
            nodes[i] = this.createTreeNode("Introduction " + i, "Introduction for " + advisor.getName(), "images/service.gif", "AOPIntroductionPointcut.jsp?pointcut=" + URLEncoder.encode(introduction.getName()), null, null, null);
        }
        return nodes;
    }

    public static String shortenMethod(String classname, Method method) {
        return method.toString().replaceAll(classname + "." + method.getName(), method.getName());
    }

    public static String shortenConstructor(String classname, Constructor constructor) {
        String base = classname.substring(classname.lastIndexOf(46) + 1);
        return constructor.toString().replaceAll(classname, base);
    }

    public static String shortenField(String classname, Field field) {
        return field.toString().replaceAll(classname + "." + field.getName(), field.getName());
    }

    public TreeNode[] createAdvisorNodes(ClassAdvisor advisor) throws Exception {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        this.populateIntroductions(advisor, nodes);
        this.populateConstructors(advisor, nodes);
        this.populateMethods(advisor, nodes);
        this.populateFields(advisor, nodes);
        TreeNode metadata = this.getMetaData(advisor);
        if (metadata != null) {
            nodes.add(metadata);
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    private void populateFields(ClassAdvisor advisor, ArrayList nodes) throws Exception {
        if (advisor.getAdvisedFields() == null) {
            return;
        }
        ArrayList<SimpleTreeNode> fieldWriteNodes = new ArrayList<SimpleTreeNode>();
        ArrayList<SimpleTreeNode> fieldReadNodes = new ArrayList<SimpleTreeNode>();
        for (int i = 0; i < advisor.getAdvisedFields().length; ++i) {
            Field f = advisor.getAdvisedFields()[i];
            Interceptor[] chain = advisor.getFieldWriteInterceptors()[i];
            if (chain != null && chain.length > 0) {
                fieldWriteNodes.add(this.createTreeNode(AOPLister.shortenField(advisor.getName(), f), "Field write interceptor chain", "images/service.gif", "AOPFieldChain.jsp?classname=" + URLEncoder.encode(advisor.getName()) + "&field=" + i + "&mode=write", null, null, null));
            }
            if ((chain = advisor.getFieldReadInterceptors()[i]) == null || chain.length <= 0) continue;
            fieldReadNodes.add(this.createTreeNode(AOPLister.shortenField(advisor.getName(), f), "Field read interceptor chain", "images/service.gif", "AOPFieldChain.jsp?classname=" + URLEncoder.encode(advisor.getName()) + "&field=" + i + "&mode=read", null, null, null));
        }
        if (fieldWriteNodes.size() > 0 && fieldWriteNodes.size() > 0) {
            TreeNode[] cnodes;
            ArrayList<SimpleTreeNode> fieldReadWriteNodes = new ArrayList<SimpleTreeNode>();
            if (fieldWriteNodes.size() > 0) {
                cnodes = fieldWriteNodes.toArray(new TreeNode[fieldWriteNodes.size()]);
                fieldReadWriteNodes.add(this.createTreeNode("write interceptors", "field write info", "images/starfolder.gif", null, null, cnodes, null));
            }
            if (fieldReadNodes.size() > 0) {
                cnodes = fieldReadNodes.toArray(new TreeNode[fieldReadNodes.size()]);
                fieldReadWriteNodes.add(this.createTreeNode("read interceptors", "field read info", "images/starfolder.gif", null, null, cnodes, null));
            }
            TreeNode[] fieldRwNodes = fieldReadWriteNodes.toArray(new TreeNode[fieldReadWriteNodes.size()]);
            nodes.add(this.createTreeNode("Fields", "field info", "images/starfolder.gif", null, null, fieldRwNodes, null));
        }
    }

    private void populateConstructors(ClassAdvisor advisor, ArrayList nodes) throws Exception {
        if (advisor.getConstructors() == null) {
            return;
        }
        if (advisor.getConstructorInterceptors() == null) {
            return;
        }
        if (advisor.getMethodCalledByConInterceptors() == null) {
            return;
        }
        ArrayList<SimpleTreeNode> constructorNodes = new ArrayList<SimpleTreeNode>();
        for (int i = 0; i < advisor.getConstructors().length; ++i) {
            Constructor con = advisor.getConstructors()[i];
            Interceptor[] chain = advisor.getConstructorInterceptors()[i];
            HashMap methodCallers = advisor.getMethodCalledByConInterceptors()[i];
            HashMap conCallers = advisor.getConCalledByConInterceptors()[i];
            if ((chain == null || chain.length <= 0) && methodCallers == null && conCallers == null) continue;
            ArrayList<SimpleTreeNode> conNodes = new ArrayList<SimpleTreeNode>();
            if (chain != null && chain.length > 0) {
                conNodes.add(this.createTreeNode("Interceptors", "Execution Interceptors", "images/service.gif", "AOPConstructorChain.jsp?classname=" + URLEncoder.encode(con.getDeclaringClass().getName()) + "&constructor=" + i, null, null, null));
            }
            if (conCallers != null) {
                conNodes.add(this.createTreeNode("constructor callers", "constructor caller interceptions", "images/starfolder.gif", null, null, this.createConstructorConstructorCallers(i, advisor, conCallers), null));
            }
            if (methodCallers != null) {
                conNodes.add(this.createTreeNode("method callers", "method caller interceptions", "images/starfolder.gif", null, null, this.createConstructorMethodCallers(i, advisor, methodCallers), null));
            }
            TreeNode[] cnodes = conNodes.toArray(new TreeNode[conNodes.size()]);
            constructorNodes.add(this.createTreeNode(AOPLister.shortenConstructor(advisor.getName(), con), "constructor info", "images/starfolder.gif", null, null, cnodes, null));
        }
        if (constructorNodes.size() > 0) {
            TreeNode[] cnodes = constructorNodes.toArray(new TreeNode[constructorNodes.size()]);
            nodes.add(this.createTreeNode("Constructors", "constructor info", "images/starfolder.gif", null, null, cnodes, null));
        }
    }

    private void populateMethods(ClassAdvisor advisor, ArrayList nodes) throws Exception {
        if (advisor.getMethodInterceptors() == null) {
            return;
        }
        ArrayList<SimpleTreeNode> methodNodes = new ArrayList<SimpleTreeNode>();
        long[] keys = advisor.getMethodInterceptors().keys();
        for (int i = 0; i < keys.length; ++i) {
            long key = keys[i];
            MethodInfo method = (MethodInfo)advisor.getMethodInterceptors().get(key);
            HashMap methodCallers = (HashMap)advisor.getMethodCalledByMethodInterceptors().get(key);
            HashMap conCallers = (HashMap)advisor.getConCalledByMethodInterceptors().get(key);
            if (method == null && methodCallers == null || method != null && methodCallers == null && (method.getInterceptors() == null || method.getInterceptors().length < 1)) continue;
            ArrayList<SimpleTreeNode> mNodes = new ArrayList<SimpleTreeNode>();
            if (method.getInterceptors() != null && method.getInterceptors().length > 0 || methodCallers != null || conCallers != null) {
                mNodes.add(this.createTreeNode("Interceptors", "Execution Interceptors", "images/service.gif", "AOPMethodChain.jsp?classname=" + URLEncoder.encode(advisor.getName()) + "&method=" + keys[i], null, null, null));
            }
            if (conCallers != null) {
                mNodes.add(this.createTreeNode("constructor callers", "constructor caller interceptions", "images/starfolder.gif", null, null, this.createMethodConstructorCallers(key, advisor, conCallers), null));
            }
            if (methodCallers != null) {
                mNodes.add(this.createTreeNode("method callers", "method caller interceptions", "images/starfolder.gif", null, null, this.createMethodMethodCallers(key, advisor, methodCallers), null));
            }
            TreeNode[] mnodes = mNodes.toArray(new TreeNode[mNodes.size()]);
            methodNodes.add(this.createTreeNode(AOPLister.shortenMethod(advisor.getName(), method.getAdvisedMethod()), "method info", "images/starfolder.gif", null, null, mnodes, null));
        }
        if (methodNodes.size() > 0) {
            TreeNode[] cnodes = methodNodes.toArray(new TreeNode[methodNodes.size()]);
            nodes.add(this.createTreeNode("Methods", "method info", "images/starfolder.gif", null, null, cnodes, null));
        }
    }

    private void populateIntroductions(ClassAdvisor advisor, ArrayList nodes) throws Exception {
        ArrayList introductions = advisor.getInterfaceIntroductions();
        if (introductions != null && introductions.size() > 0) {
            TreeNode[] introductionNodes = this.getIntroductions(advisor);
            SimpleTreeNode introductionsNode = this.createTreeNode("Introductions", "Introductions for " + advisor.getName(), "images/starfolder.gif", null, null, introductionNodes, null);
            nodes.add(introductionsNode);
        }
    }

    public TreeNode[] createConstructorMethodCallers(int index, ClassAdvisor advisor, HashMap called) throws Exception {
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        for (String calledClass : called.keySet()) {
            TLongObjectHashMap map = (TLongObjectHashMap)called.get(calledClass);
            Object[] values = map.getValues();
            long[] keys = map.keys();
            for (int i = 0; i < values.length; ++i) {
                CallerMethodInfo caller = (CallerMethodInfo)values[i];
                nodes.add(this.createTreeNode(caller.getMethod().toString(), "caller interceptions", "images/service.gif", "AOPConstructorMethodCallerChain.jsp?index=" + index + "&hash=" + URLEncoder.encode(Long.toString(keys[i])) + "&classname=" + URLEncoder.encode(advisor.getName()) + "&calledclassname=" + URLEncoder.encode(calledClass), null, null, null));
            }
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    public TreeNode[] createConstructorConstructorCallers(int index, ClassAdvisor advisor, HashMap called) throws Exception {
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        for (String calledClass : called.keySet()) {
            TLongObjectHashMap map = (TLongObjectHashMap)called.get(calledClass);
            Object[] values = map.getValues();
            long[] keys = map.keys();
            for (int i = 0; i < values.length; ++i) {
                CallerConstructorInfo caller = (CallerConstructorInfo)values[i];
                nodes.add(this.createTreeNode(caller.getConstructor().toString(), "caller interceptions", "images/service.gif", "AOPConstructorConstructorCallerChain.jsp?index=" + index + "&hash=" + URLEncoder.encode(Long.toString(keys[i])) + "&classname=" + URLEncoder.encode(advisor.getName()) + "&calledclassname=" + URLEncoder.encode(calledClass), null, null, null));
            }
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    public TreeNode[] createMethodMethodCallers(long callingHash, ClassAdvisor advisor, HashMap called) throws Exception {
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        for (String calledClass : called.keySet()) {
            TLongObjectHashMap map = (TLongObjectHashMap)called.get(calledClass);
            Object[] values = map.getValues();
            long[] keys = map.keys();
            for (int i = 0; i < values.length; ++i) {
                CallerMethodInfo caller = (CallerMethodInfo)values[i];
                nodes.add(this.createTreeNode(caller.getMethod().toString(), "caller interceptions", "images/service.gif", "AOPMethodMethodCallerChain.jsp?callinghash=" + callingHash + "&hash=" + URLEncoder.encode(Long.toString(keys[i])) + "&classname=" + URLEncoder.encode(advisor.getName()) + "&calledclassname=" + URLEncoder.encode(calledClass), null, null, null));
            }
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    public TreeNode[] createMethodConstructorCallers(long callingHash, ClassAdvisor advisor, HashMap called) throws Exception {
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        for (String calledClass : called.keySet()) {
            TLongObjectHashMap map = (TLongObjectHashMap)called.get(calledClass);
            Object[] values = map.getValues();
            long[] keys = map.keys();
            for (int i = 0; i < values.length; ++i) {
                CallerConstructorInfo caller = (CallerConstructorInfo)values[i];
                nodes.add(this.createTreeNode(caller.getConstructor().toString(), "caller interceptions", "images/service.gif", "AOPMethodConstructorCallerChain.jsp?callinghash=" + callingHash + "&hash=" + URLEncoder.encode(Long.toString(keys[i])) + "&classname=" + URLEncoder.encode(advisor.getName()) + "&calledclassname=" + URLEncoder.encode(calledClass), null, null, null));
            }
        }
        return nodes.toArray(new TreeNode[nodes.size()]);
    }

    public TreeNode[] getUnboundBindings() throws Exception {
        ArrayList<SimpleTreeNode> unbounded = new ArrayList<SimpleTreeNode>();
        for (AdviceBinding binding : AspectManager.instance().getBindings().values()) {
            if (binding.hasAdvisors()) continue;
            unbounded.add(this.createTreeNode(binding.getName(), "Unbounded Binding", "images/service.gif", "AOPBinding.jsp?binding=" + URLEncoder.encode(binding.getName()), null, null, null));
        }
        if (unbounded.size() == 0) {
            return null;
        }
        return unbounded.toArray(new TreeNode[unbounded.size()]);
    }

    TreeNode[] createAOPNodes(Package root) throws Exception {
        ArrayList<SimpleTreeNode> nodes = new ArrayList<SimpleTreeNode>();
        for (Map.Entry entry : root.packages.entrySet()) {
            String pkgName = (String)entry.getKey();
            Package p = (Package)entry.getValue();
            nodes.add(this.createTreeNode(pkgName, "Package " + pkgName, "images/starfolder.gif", null, null, this.createAOPNodes(p), null));
        }
        for (Map.Entry entry : root.advisors.entrySet()) {
            String classname = (String)entry.getKey();
            ClassAdvisor advisor = (ClassAdvisor)entry.getValue();
            nodes.add(this.createTreeNode(classname, "Class " + classname, "images/serviceset.gif", null, null, this.createAdvisorNodes(advisor), null));
        }
        TreeNode[] result = nodes.size() == 0 ? null : nodes.toArray(new TreeNode[nodes.size()]);
        return result;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            TreeNode[] unbounded = this.getUnboundBindings();
            TreeNode[] children = new TreeNode[]{this.createTreeNode("Classes", "Display all Classes", "images/serviceset.gif", null, null, this.createAOPNodes(Package.aopClassMap()), null), this.createTreeNode("Unbound Bindings", "Unbound Bindings", "images/serviceset.gif", null, null, unbounded, null)};
            return this.createTreeNode("AOP", "AOP Management", "images/spirale32.gif", null, null, children, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputChain(Interceptor[] chain) {
        String output = "";
        for (int i = 0; i < chain.length; ++i) {
            output = output + "<tr>";
            output = chain[i] instanceof AbstractAdvice ? output + "<td><font size=\"1\">advice</font></td><td><font size=\"1\">" + chain[i].getName() + "</font></td>" : (chain[i] instanceof CFlowInterceptor ? output + "<td><font size=\"1\">cflow</font></td><td><font size=\"1\">" + ((CFlowInterceptor)chain[i]).getCFlowString() + "</font></td>" : output + "<td><font size=\"1\">interceptor</font></td><td><font size=\"1\">" + chain[i].getClass().getName() + "</font></td>");
            output = output + "</tr>";
        }
        return output;
    }

    public void init(ServletConfig servletConfig) throws Exception {
        super.init(servletConfig);
        this.refreshPoller = new RefreshPoller();
        this.refreshPoller.start();
    }

    public void destroy() {
        super.destroy();
        try {
            this.refreshPoller.interrupt();
            this.refreshPoller.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ClassAdvisor findAdvisor(String classname) {
        return AdvisorFinder.getAdvisor(classname);
    }

    static class AdvisorFinder {
        AdvisorFinder() {
        }

        public static ClassAdvisor getAdvisor(String classname) {
            String[] name = classname.split("\\.");
            Package root = Package.aopClassMap();
            if (!root.name.equals("classes")) {
                throw new RuntimeException("Did not get expected root 'classes'");
            }
            for (Map.Entry entry : root.packages.entrySet()) {
                Package pkg = (Package)entry.getValue();
                ClassAdvisor advisor = AdvisorFinder.findAdvisor(pkg, classname, name, 0);
                if (advisor == null) continue;
                return advisor;
            }
            return null;
        }

        private static ClassAdvisor findAdvisor(Package pkg, String classname, String[] name, int depth) {
            if (depth >= name.length || !pkg.name.equals(name[depth])) {
                return null;
            }
            for (Map.Entry entry : pkg.packages.entrySet()) {
                Package p = (Package)entry.getValue();
                ClassAdvisor advisor = AdvisorFinder.findAdvisor(p, classname, name, depth + 1);
                if (advisor == null) continue;
                return advisor;
            }
            for (Map.Entry entry : pkg.advisors.entrySet()) {
                ClassAdvisor advisor = (ClassAdvisor)entry.getValue();
                if (!advisor.getClazz().getName().equals(classname)) continue;
                return advisor;
            }
            return null;
        }
    }

    class RefreshPoller
    extends Thread {
        static final int REFRESH_RATE = 20000;

        RefreshPoller() {
            this.setName("AOPListner");
            this.setDaemon(true);
        }

        public void run() {
            try {
                int advisorCount = 0;
                while (!this.isInterrupted()) {
                    int count = AspectManager.instance().getAdvisors().size();
                    if (count != advisorCount) {
                        AOPLister.this.pm.regenerateAdminTree();
                    }
                    advisorCount = count;
                    Thread.sleep(20000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

