/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jnp.interfaces.MarshalledValuePair;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingEnumerationImpl;
import org.jnp.interfaces.NamingEvents;
import org.jnp.interfaces.NamingParser;
import org.jnp.interfaces.TimedSocketFactory;

public class NamingContext
implements EventContext,
Serializable {
    static final long serialVersionUID = 8906455608484282128L;
    public static final String JNP_SOCKET_FACTORY = "jnp.socketFactory";
    public static final String JNP_LOCAL_ADDRESS = "jnp.localAddress";
    public static final String JNP_LOCAL_PORT = "jnp.localPort";
    public static final String JNP_DISABLE_DISCOVERY = "jnp.disableDiscovery";
    public static final String JNP_PARTITION_NAME = "jnp.partitionName";
    public static final String JNP_DISCOVERY_GROUP = "jnp.discoveryGroup";
    public static final String JNP_DISCOVERY_PORT = "jnp.discoveryPort";
    public static final String JNP_DISCOVERY_TTL = "jnp.discoveryTTL";
    public static final String JNP_DISCOVERY_TIMEOUT = "jnp.discoveryTimeout";
    public static final String JNP_PARSED_NAME = "jnp.parsedName";
    public static final String JNP_USE_RELATIVE_NAME = "jnp.useRelativeName";
    public static final String JNP_MAX_RETRIES = "jnp.maxRetries";
    public static final String JNP_NAMING_INSTANCE = "jnp.namingInstance";
    public static final String JNP_NAMING_INSTANCE_NAME = "jnp.namingInstanceName";
    public static final String DEFAULT_DISCOVERY_GROUP_ADDRESS = "230.0.0.4";
    public static final int DEFAULT_DISCOVERY_GROUP_PORT = 1102;
    public static final int DEFAULT_DISCOVERY_TIMEOUT = 5000;
    public static int MAX_RETRIES = 1;
    private static Logger log = Logger.getLogger(NamingContext.class);
    private static Hashtable<String, Naming> haServers = new Hashtable();
    private static RuntimePermission GET_HA_NAMING_SERVER = new RuntimePermission("org.jboss.naming.NamingContext.getHANamingServerForPartition");
    private static RuntimePermission SET_HA_NAMING_SERVER = new RuntimePermission("org.jboss.naming.NamingContext.setHANamingServerForPartition");
    private static Naming localServer;
    private static RuntimePermission GET_LOCAL_SERVER;
    private static RuntimePermission SET_LOCAL_SERVER;
    private static int HOST_INDEX;
    private static int PORT_INDEX;
    Naming naming;
    Hashtable env;
    Name prefix;
    NameParser parser = new NamingParser();
    static ConcurrentHashMap<InetSocketAddress, WeakReference<Naming>> cachedServers;

    public static void setHANamingServerForPartition(String partitionName, Naming haServer) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SET_HA_NAMING_SERVER);
        }
        haServers.put(partitionName, haServer);
    }

    public static void removeHANamingServerForPartition(String partitionName) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SET_HA_NAMING_SERVER);
        }
        haServers.remove(partitionName);
    }

    public static Naming getHANamingServerForPartition(String partitionName) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(GET_HA_NAMING_SERVER);
        }
        return haServers.get(partitionName);
    }

    static void addServer(String name, Naming server) {
        Object[] hostAndPort = new Object[]{name, 0};
        NamingContext.parseHostPort(name, hostAndPort, 0);
        String host = (String)hostAndPort[HOST_INDEX];
        Integer port = (Integer)hostAndPort[PORT_INDEX];
        InetSocketAddress addr = new InetSocketAddress(host, (int)port);
        NamingContext.addServer(addr, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addServer(InetSocketAddress addr, Naming server) {
        Class<NamingContext> clazz = NamingContext.class;
        synchronized (NamingContext.class) {
            WeakReference<Naming> ref = new WeakReference<Naming>(server);
            cachedServers.put(addr, ref);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static Naming getServer(String host, int port, Hashtable serverEnv) throws NamingException {
        Naming server;
        InetSocketAddress key = new InetSocketAddress(host, port);
        WeakReference<Naming> ref = cachedServers.get(key);
        if (ref != null && (server = (Naming)ref.get()) != null) {
            serverEnv.put("hostKey", key);
            return server;
        }
        try {
            Socket s;
            SocketFactory factory = NamingContext.loadSocketFactory(serverEnv);
            try {
                InetAddress localAddr = null;
                int localPort = 0;
                String localAddrStr = (String)serverEnv.get(JNP_LOCAL_ADDRESS);
                String localPortStr = (String)serverEnv.get(JNP_LOCAL_PORT);
                if (localAddrStr != null) {
                    localAddr = InetAddress.getByName(localAddrStr);
                }
                if (localPortStr != null) {
                    localPort = Integer.parseInt(localPortStr);
                }
                s = factory.createSocket(host, port, localAddr, localPort);
            }
            catch (IOException e) {
                ServiceUnavailableException ex = new ServiceUnavailableException("Failed to connect to server " + key);
                ex.setRootCause(e);
                throw ex;
            }
            BufferedInputStream bis = new BufferedInputStream(s.getInputStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            MarshalledObject stub = (MarshalledObject)in.readObject();
            server = (Naming)stub.get();
            s.close();
            NamingContext.addServer(key, server);
            serverEnv.put("hostKey", key);
            return server;
        }
        catch (IOException e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to retrieve stub from server " + key, e);
            }
            CommunicationException ex = new CommunicationException("Failed to retrieve stub from server " + key);
            ex.setRootCause(e);
            throw ex;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to connect server " + key, e);
            }
            CommunicationException ex = new CommunicationException("Failed to connect to server " + key);
            ex.setRootCause(e);
            throw ex;
        }
    }

    static SocketFactory loadSocketFactory(Hashtable serverEnv) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        SocketFactory factory = null;
        String socketFactoryName = (String)serverEnv.get(JNP_SOCKET_FACTORY);
        if (socketFactoryName == null || socketFactoryName.equals(TimedSocketFactory.class.getName())) {
            factory = new TimedSocketFactory(serverEnv);
            return factory;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = loader.loadClass(socketFactoryName);
        try {
            Class[] ctorSig = new Class[]{Hashtable.class};
            Constructor<?> ctor = factoryClass.getConstructor(ctorSig);
            Object[] ctorArgs = new Object[]{serverEnv};
            factory = (SocketFactory)ctor.newInstance(ctorArgs);
        }
        catch (NoSuchMethodException e) {
            factory = (SocketFactory)factoryClass.newInstance();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void removeServer(Hashtable serverEnv) {
        Object hostKey;
        String host = "localhost";
        int port = 1099;
        if (serverEnv.get("java.naming.provider.url") != null) {
            String providerURL = (String)serverEnv.get("java.naming.provider.url");
            StringTokenizer tokenizer = new StringTokenizer(providerURL, ", ");
            while (tokenizer.hasMoreElements()) {
                String url = tokenizer.nextToken();
                try {
                    Name urlAsName = new NamingParser().parse(url);
                    String server = NamingContext.parseNameForScheme(urlAsName, null);
                    if (server != null) {
                        url = server;
                    }
                    Object[] hostAndPort = new Object[]{url, 1099};
                    NamingContext.parseHostPort(url, hostAndPort, 1099);
                    host = (String)hostAndPort[HOST_INDEX];
                    port = (Integer)hostAndPort[PORT_INDEX];
                    Class<NamingContext> clazz = NamingContext.class;
                    // MONITORENTER : org.jnp.interfaces.NamingContext.class
                    InetSocketAddress key = new InetSocketAddress(host, port);
                    cachedServers.remove(key);
                    // MONITOREXIT : clazz
                }
                catch (NamingException ignored) {}
            }
        }
        if ((hostKey = serverEnv.remove("hostKey")) == null) return;
        Class<NamingContext> clazz = NamingContext.class;
        // MONITORENTER : org.jnp.interfaces.NamingContext.class
        cachedServers.remove(hostKey);
        // MONITOREXIT : clazz
    }

    static String parseNameForScheme(Name n, Hashtable nameEnv) throws InvalidNameException {
        String serverInfo = null;
        if (n.size() > 0) {
            String scheme = n.get(0);
            int schemeLength = 0;
            if (scheme.startsWith("java:")) {
                schemeLength = 5;
            } else if (scheme.startsWith("jnp:")) {
                schemeLength = 4;
            } else if (scheme.startsWith("jnps:")) {
                schemeLength = 5;
            } else if (scheme.startsWith("jnp-http:")) {
                schemeLength = 9;
            } else if (scheme.startsWith("jnp-https:")) {
                schemeLength = 10;
            }
            if (schemeLength > 0) {
                n = (Name)n.clone();
                String suffix = scheme.substring(schemeLength);
                if (suffix.length() == 0) {
                    n.remove(0);
                    if (n.size() > 1 && n.get(0).equals("")) {
                        serverInfo = n.get(1);
                        n.remove(0);
                        n.remove(0);
                        if (n.size() == 1 && n.get(0).length() == 0) {
                            n.remove(0);
                        }
                    }
                } else {
                    n.remove(0);
                    n.add(0, suffix);
                }
                if (nameEnv != null) {
                    nameEnv.put(JNP_PARSED_NAME, n);
                }
            }
        }
        return serverInfo;
    }

    public static Naming getLocal() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(GET_LOCAL_SERVER);
        }
        return localServer;
    }

    public static void setLocal(Naming server) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SET_LOCAL_SERVER);
        }
        localServer = server;
    }

    public NamingContext(Hashtable e, Name baseName, Naming server) throws NamingException {
        this.prefix = baseName == null ? this.parser.parse("") : baseName;
        this.env = e != null ? (Hashtable)e.clone() : new Hashtable();
        this.naming = server;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming server) {
        this.naming = server;
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        block11: {
            Hashtable refEnv = this.getEnv(name);
            this.checkRef(refEnv);
            Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
            if (parsedName != null) {
                name = parsedName;
            }
            obj = this.getStateToBind(obj, name, refEnv);
            try {
                String className = null;
                if (obj instanceof Referenceable) {
                    obj = ((Referenceable)obj).getReference();
                }
                if (!(obj instanceof Reference)) {
                    if (obj != null) {
                        className = obj.getClass().getName();
                    }
                    obj = this.createMarshalledValuePair(obj);
                } else {
                    className = ((Reference)obj).getClassName();
                }
                try {
                    this.naming.rebind(this.getAbsoluteName(name), obj, className);
                }
                catch (RemoteException re) {
                    if (this.handleStaleNamingStub(re, refEnv)) {
                        this.naming.rebind(this.getAbsoluteName(name), obj, className);
                        break block11;
                    }
                    throw re;
                }
            }
            catch (CannotProceedException cpe) {
                cpe.setEnvironment(refEnv);
                Context cctx = NamingManager.getContinuationContext(cpe);
                cctx.rebind(cpe.getRemainingName(), obj);
            }
            catch (IOException e) {
                this.naming = null;
                NamingContext.removeServer(refEnv);
                CommunicationException ex = new CommunicationException();
                ex.setRootCause(e);
                throw ex;
            }
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        block11: {
            Hashtable refEnv = this.getEnv(name);
            this.checkRef(refEnv);
            Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
            if (parsedName != null) {
                name = parsedName;
            }
            obj = this.getStateToBind(obj, name, refEnv);
            try {
                String className = null;
                if (obj instanceof Referenceable) {
                    obj = ((Referenceable)obj).getReference();
                }
                if (!(obj instanceof Reference)) {
                    if (obj != null) {
                        className = obj.getClass().getName();
                    }
                    obj = this.createMarshalledValuePair(obj);
                } else {
                    className = ((Reference)obj).getClassName();
                }
                name = this.getAbsoluteName(name);
                try {
                    this.naming.bind(name, obj, className);
                }
                catch (RemoteException re) {
                    if (this.handleStaleNamingStub(re, refEnv)) {
                        this.naming.bind(name, obj, className);
                        break block11;
                    }
                    throw re;
                }
            }
            catch (CannotProceedException cpe) {
                cpe.setEnvironment(refEnv);
                Context cctx = NamingManager.getContinuationContext(cpe);
                cctx.bind(cpe.getRemainingName(), obj);
            }
            catch (IOException e) {
                this.naming = null;
                NamingContext.removeServer(refEnv);
                CommunicationException ex = new CommunicationException();
                ex.setRootCause(e);
                throw ex;
            }
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        if (name.isEmpty()) {
            return new NamingContext(refEnv, this.prefix, this.naming);
        }
        try {
            Object n;
            int maxTries = 1;
            try {
                n = (String)refEnv.get(JNP_MAX_RETRIES);
                if (n != null) {
                    maxTries = Integer.parseInt((String)n);
                }
                if (maxTries <= 0) {
                    maxTries = 1;
                }
            }
            catch (Exception e) {
                log.debug("Failed to get JNP_MAX_RETRIES, using 1", e);
            }
            n = this.getAbsoluteName(name);
            Object res = null;
            boolean trace = log.isTraceEnabled();
            for (int i = 0; i < maxTries; ++i) {
                try {
                    try {
                        res = this.naming.lookup((Name)n);
                        break;
                    }
                    catch (RemoteException re) {
                        if (this.handleStaleNamingStub(re, refEnv)) {
                            res = this.naming.lookup((Name)n);
                            break;
                        }
                        throw re;
                    }
                }
                catch (ConnectException ce) {
                    int retries = maxTries - i - 1;
                    if (trace) {
                        log.trace("Connect failed, retry count: " + retries, ce);
                    }
                    if (retries > 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException ignored) {}
                        continue;
                    }
                    throw ce;
                }
            }
            if (res instanceof MarshalledValuePair) {
                MarshalledValuePair mvp = (MarshalledValuePair)res;
                Object storedObj = mvp.get();
                return this.getObjectInstanceWrapFailure(storedObj, name, refEnv);
            }
            if (res instanceof MarshalledObject) {
                MarshalledObject mo = (MarshalledObject)res;
                return mo.get();
            }
            if (res instanceof Context) {
                Enumeration keys = refEnv.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ((Context)res).addToEnvironment(key, refEnv.get(key));
                }
                return res;
            }
            if (res instanceof ResolveResult) {
                Object instanceID;
                Object context;
                ResolveResult rr = (ResolveResult)res;
                Object resolveRes = rr.getResolvedObj();
                if (resolveRes instanceof LinkRef) {
                    context = this.resolveLink(resolveRes, null);
                    instanceID = ((LinkRef)resolveRes).getLinkName();
                } else {
                    instanceID = context = this.getObjectInstanceWrapFailure(resolveRes, name, refEnv);
                }
                if (!(context instanceof Context)) {
                    throw new NotContextException(instanceID + " is not a Context");
                }
                Context ncontext = (Context)context;
                return ncontext.lookup(rr.getRemainingName());
            }
            if (res instanceof LinkRef) {
                res = this.resolveLink(res, refEnv);
            } else if (res instanceof Reference && (res = this.getObjectInstanceWrapFailure(res, name, refEnv)) instanceof LinkRef) {
                res = this.resolveLink(res, refEnv);
            }
            return res;
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.lookup(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        catch (ClassNotFoundException e) {
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public void unbind(Name name) throws NamingException {
        block7: {
            Hashtable refEnv = this.getEnv(name);
            this.checkRef(refEnv);
            Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
            if (parsedName != null) {
                name = parsedName;
            }
            try {
                try {
                    this.naming.unbind(this.getAbsoluteName(name));
                }
                catch (RemoteException re) {
                    if (this.handleStaleNamingStub(re, refEnv)) {
                        this.naming.unbind(this.getAbsoluteName(name));
                        break block7;
                    }
                    throw re;
                }
            }
            catch (CannotProceedException cpe) {
                cpe.setEnvironment(refEnv);
                Context cctx = NamingManager.getContinuationContext(cpe);
                cctx.unbind(cpe.getRemainingName());
            }
            catch (IOException e) {
                this.naming = null;
                NamingContext.removeServer(refEnv);
                CommunicationException ex = new CommunicationException();
                ex.setRootCause(e);
                throw ex;
            }
        }
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(this.getNameParser(oldname).parse(oldname), this.getNameParser(newname).parse(newname));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            Collection<NameClassPair> c = null;
            try {
                c = this.naming.list(this.getAbsoluteName(name));
            }
            catch (RemoteException re) {
                if (this.handleStaleNamingStub(re, refEnv)) {
                    c = this.naming.list(this.getAbsoluteName(name));
                }
                throw re;
            }
            return new NamingEnumerationImpl(c);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.list(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            Collection<Binding> bindings = null;
            try {
                bindings = this.naming.listBindings(this.getAbsoluteName(name));
            }
            catch (RemoteException re) {
                if (this.handleStaleNamingStub(re, refEnv)) {
                    bindings = this.naming.listBindings(this.getAbsoluteName(name));
                }
                throw re;
            }
            ArrayList<Binding> realBindings = new ArrayList<Binding>(bindings.size());
            for (Binding binding : bindings) {
                Object obj = binding.getObject();
                if (obj instanceof MarshalledValuePair) {
                    try {
                        obj = ((MarshalledValuePair)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                if (obj instanceof MarshalledObject) {
                    try {
                        obj = ((MarshalledObject)obj).get();
                    }
                    catch (ClassNotFoundException e) {
                        CommunicationException ex = new CommunicationException();
                        ex.setRootCause(e);
                        throw ex;
                    }
                }
                realBindings.add(new Binding(binding.getName(), binding.getClassName(), obj));
            }
            return new NamingEnumerationImpl(realBindings);
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.listBindings(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(this.parser.parse(name), this.parser.parse(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        try {
            name = this.getAbsoluteName(name);
            try {
                return this.naming.createSubcontext(name);
            }
            catch (RemoteException re) {
                if (this.handleStaleNamingStub(re, refEnv)) {
                    return this.naming.createSubcontext(name);
                }
                throw re;
            }
        }
        catch (CannotProceedException cpe) {
            cpe.setEnvironment(refEnv);
            Context cctx = NamingManager.getContinuationContext(cpe);
            return cctx.createSubcontext(cpe.getRemainingName());
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object old = this.env.get(propName);
        this.env.put(propName, propVal);
        return old;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env = null;
        this.naming = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.getNameParser(name).parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this.list(name).hasMore()) {
            throw new ContextNotEmptyException();
        }
        this.unbind(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser(name).parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        Hashtable refEnv = this.getEnv(name);
        this.checkRef(refEnv);
        Name parsedName = (Name)refEnv.get(JNP_PARSED_NAME);
        if (parsedName != null) {
            name = parsedName;
        }
        if (name.isEmpty()) {
            return this.lookup(name);
        }
        Object link = null;
        try {
            Name n = this.getAbsoluteName(name);
            try {
                link = this.naming.lookup(n);
            }
            catch (RemoteException re) {
                if (this.handleStaleNamingStub(re, refEnv)) {
                    link = this.naming.lookup(n);
                }
                throw re;
            }
            if (!(link instanceof LinkRef) && link instanceof Reference) {
                link = this.getObjectInstance(link, name, null);
            }
        }
        catch (IOException e) {
            this.naming = null;
            NamingContext.removeServer(refEnv);
            CommunicationException ex = new CommunicationException();
            ex.setRootCause(e);
            throw ex;
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not lookup link");
            ex.setRemainingName(name);
            ex.setRootCause(e);
            throw ex;
        }
        return link;
    }

    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        if (!(this.naming instanceof NamingEvents)) {
            throw new UnsupportedOperationException("Naming implementation does not support NamingExt");
        }
        NamingEvents next = (NamingEvents)this.naming;
        try {
            next.addNamingListener(this, target, scope, l);
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException("addNamingListener failed");
            ce.initCause(e);
        }
    }

    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        Name targetName = this.parser.parse(target);
        this.addNamingListener(targetName, scope, l);
    }

    public void removeNamingListener(NamingListener l) throws NamingException {
        if (!(this.naming instanceof NamingEvents)) {
            throw new UnsupportedOperationException("Naming implementation does not support NamingExt");
        }
        NamingEvents next = (NamingEvents)this.naming;
        try {
            next.removeNamingListener(l);
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException("removeNamingListener failed");
            ce.initCause(e);
        }
    }

    public boolean targetMustExist() throws NamingException {
        if (!(this.naming instanceof NamingEvents)) {
            throw new UnsupportedOperationException("Naming implementation does not support NamingExt");
        }
        NamingEvents next = (NamingEvents)this.naming;
        boolean targetMustExist = true;
        try {
            targetMustExist = next.targetMustExist();
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException("removeNamingListener failed");
            ce.initCause(e);
        }
        return targetMustExist;
    }

    protected Object resolveLink(Object res, Hashtable refEnv) throws NamingException {
        Object linkResult = null;
        try {
            LinkRef link = (LinkRef)res;
            String ref = link.getLinkName();
            linkResult = ref.startsWith("./") ? this.lookup(ref.substring(2)) : (refEnv != null ? new InitialContext(refEnv).lookup(ref) : new InitialContext().lookup(ref));
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not dereference object");
            ex.setRootCause(e);
            throw ex;
        }
        return linkResult;
    }

    private Object createMarshalledValuePair(final Object obj) throws IOException {
        MarshalledValuePair mvp = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                mvp = AccessController.doPrivileged(new PrivilegedExceptionAction<MarshalledValuePair>(){

                    @Override
                    public MarshalledValuePair run() throws Exception {
                        return new MarshalledValuePair(obj);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                IOException ioe = new IOException();
                ioe.initCause(e.getException());
                throw ioe;
            }
        } else {
            mvp = new MarshalledValuePair(obj);
        }
        return mvp;
    }

    private boolean useAbsoluteName(Hashtable env) {
        if (env == null) {
            return true;
        }
        String useRelativeName = (String)env.get(JNP_USE_RELATIVE_NAME);
        return Boolean.valueOf(useRelativeName) == Boolean.FALSE;
    }

    private Object getStateToBind(Object obj, Name name, Hashtable env) throws NamingException {
        if (this.useAbsoluteName(env)) {
            name = this.getAbsoluteName(name);
        }
        return NamingManager.getStateToBind(obj, name, this, env);
    }

    private Object getObjectInstance(Object obj, Name name, Hashtable env) throws Exception {
        if (this.useAbsoluteName(env)) {
            name = this.getAbsoluteName(name);
        }
        return NamingManager.getObjectInstance(obj, name, this, env);
    }

    private Object getObjectInstanceWrapFailure(Object obj, Name name, Hashtable env) throws NamingException {
        try {
            return this.getObjectInstance(obj, name, env);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Could not dereference object");
            ex.setRootCause(e);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Naming discoverServer(Hashtable serverEnv) throws NamingException {
        Naming naming;
        boolean trace = log.isTraceEnabled();
        String disableDiscovery = (String)serverEnv.get(JNP_DISABLE_DISCOVERY);
        if (Boolean.valueOf(disableDiscovery) == Boolean.TRUE) {
            if (!trace) return null;
            log.trace("Skipping discovery due to disable flag");
            return null;
        }
        String partitionName = (String)serverEnv.get(JNP_PARTITION_NAME);
        Naming server = null;
        if (partitionName != null && (server = NamingContext.getHANamingServerForPartition(partitionName)) != null) {
            return server;
        }
        MulticastSocket s = null;
        InetAddress iaGroup = null;
        try {
            String discoveryGroupPort;
            String discoveryTimeout;
            String discoveryTTL;
            String group = DEFAULT_DISCOVERY_GROUP_ADDRESS;
            int port = 1102;
            int timeout = 5000;
            int ttl = 16;
            String discoveryGroup = (String)serverEnv.get(JNP_DISCOVERY_GROUP);
            if (discoveryGroup != null) {
                group = discoveryGroup;
            }
            if ((discoveryTTL = (String)serverEnv.get(JNP_DISCOVERY_TTL)) != null) {
                ttl = Integer.parseInt(discoveryTTL);
            }
            if ((discoveryTimeout = (String)serverEnv.get(JNP_DISCOVERY_TIMEOUT)) == null) {
                discoveryTimeout = (String)serverEnv.get("DISCOVERY_TIMEOUT");
            }
            if (discoveryTimeout != null && !discoveryTimeout.equals("")) {
                timeout = Integer.parseInt(discoveryTimeout);
            }
            if ((discoveryGroupPort = (String)serverEnv.get(JNP_DISCOVERY_PORT)) == null) {
                discoveryGroupPort = (String)serverEnv.get("DISCOVERY_GROUP");
            }
            if (discoveryGroupPort != null && !discoveryGroupPort.equals("")) {
                int colon = discoveryGroupPort.indexOf(58);
                if (colon < 0) {
                    try {
                        port = Integer.parseInt(discoveryGroupPort);
                    }
                    catch (Exception ex) {
                        log.warn("Failed to parse port: " + discoveryGroupPort, ex);
                    }
                } else {
                    group = discoveryGroupPort.substring(0, colon);
                    String portStr = discoveryGroupPort.substring(colon + 1);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (Exception ex) {
                        log.warn("Failed to parse port: " + portStr, ex);
                    }
                }
            }
            iaGroup = InetAddress.getByName(group);
            String localAddrStr = (String)serverEnv.get(JNP_LOCAL_ADDRESS);
            String localPortStr = (String)serverEnv.get(JNP_LOCAL_PORT);
            int localPort = 0;
            if (localPortStr != null) {
                localPort = Integer.parseInt(localPortStr);
            }
            if (localAddrStr != null) {
                InetSocketAddress localAddr = new InetSocketAddress(localAddrStr, localPort);
                s = new MulticastSocket(localAddr);
            } else {
                s = new MulticastSocket(localPort);
            }
            s.setSoTimeout(timeout);
            s.setTimeToLive(ttl);
            if (log.isTraceEnabled()) {
                log.trace("TTL on multicast discovery socket is " + ttl);
            }
            s.joinGroup(iaGroup);
            if (trace) {
                log.trace("MulticastSocket: " + s);
            }
            StringBuffer data = new StringBuffer("GET_ADDRESS");
            if (partitionName != null) {
                data.append(":" + partitionName);
            }
            byte[] buf = data.toString().getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, iaGroup, port);
            if (trace) {
                log.trace("Sending discovery packet(" + data + ") to: " + iaGroup + ":" + port);
            }
            s.send(packet);
            buf = new byte[50];
            packet = new DatagramPacket(buf, buf.length);
            s.receive(packet);
            String myServer = new String(packet.getData()).trim();
            if (trace) {
                log.trace("Received answer packet: " + myServer);
            }
            while (myServer != null && myServer.startsWith("GET_ADDRESS")) {
                Arrays.fill(buf, (byte)0);
                packet.setLength(buf.length);
                s.receive(packet);
                byte[] reply = packet.getData();
                myServer = new String(reply).trim();
                if (!trace) continue;
                log.trace("Received answer packet: " + myServer);
            }
            Object[] hostAndPort = new Object[]{myServer, 0};
            NamingContext.parseHostPort(myServer, hostAndPort, 1102);
            String serverHost = (String)hostAndPort[HOST_INDEX];
            int serverPort = (Integer)hostAndPort[PORT_INDEX];
            if (serverHost != null) {
                server = NamingContext.getServer(serverHost, serverPort, serverEnv);
            }
            naming = server;
        }
        catch (IOException e) {
            try {
                if (trace) {
                    log.trace("Discovery failed", e);
                }
                CommunicationException ex = new CommunicationException(e.getMessage());
                ex.setRootCause(e);
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.leaveGroup(iaGroup);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (s == null) throw throwable;
                    s.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (s != null) {
                s.leaveGroup(iaGroup);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (s == null) return naming;
            s.close();
            return naming;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return naming;
    }

    private void checkRef(Hashtable refEnv) throws NamingException {
        if (this.naming == null) {
            String host = "localhost";
            int port = 1099;
            Exception serverEx = null;
            String urls = (String)refEnv.get("java.naming.provider.url");
            if (urls != null && urls.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(urls, ",");
                while (this.naming == null && tokenizer.hasMoreElements()) {
                    String url = tokenizer.nextToken();
                    Name urlAsName = this.getNameParser("").parse(url);
                    String server = NamingContext.parseNameForScheme(urlAsName, null);
                    if (server != null) {
                        url = server;
                    }
                    Object[] hostAndPort = new Object[]{url, 0};
                    NamingContext.parseHostPort(url, hostAndPort, 1099);
                    host = (String)hostAndPort[HOST_INDEX];
                    port = (Integer)hostAndPort[PORT_INDEX];
                    try {
                        this.naming = NamingContext.getServer(host, port, refEnv);
                    }
                    catch (Exception e) {
                        serverEx = e;
                        log.debug("Failed to connect to " + host + ":" + port, e);
                    }
                }
                Exception discoveryFailure = null;
                if (this.naming == null) {
                    block17: {
                        try {
                            this.naming = this.discoverServer(refEnv);
                        }
                        catch (Exception e) {
                            discoveryFailure = e;
                            if (serverEx != null) break block17;
                            serverEx = e;
                        }
                    }
                    if (this.naming == null) {
                        StringBuffer buffer = new StringBuffer(50);
                        buffer.append("Could not obtain connection to any of these urls: ").append(urls);
                        if (discoveryFailure != null) {
                            buffer.append(" and discovery failed with error: ").append(discoveryFailure);
                        }
                        CommunicationException ce = new CommunicationException(buffer.toString());
                        ce.setRootCause(serverEx);
                        throw ce;
                    }
                }
            } else {
                String jnpPartitionName = (String)refEnv.get(JNP_PARTITION_NAME);
                if (jnpPartitionName != null) {
                    this.naming = this.discoverServer(refEnv);
                    if (this.naming == null) {
                        throw new ConfigurationException("No valid context could be build for jnp.partitionName=" + jnpPartitionName);
                    }
                } else {
                    this.naming = localServer;
                    if (this.naming == null) {
                        this.naming = this.discoverServer(refEnv);
                        if (this.naming == null) {
                            throw new ConfigurationException("No valid Context.PROVIDER_URL was found");
                        }
                    }
                }
            }
        }
    }

    private static int parseHostPort(String url, Object[] output, int defaultPort) {
        int firstColon;
        int colon = url.indexOf(64);
        if (colon < 0 && (colon = url.lastIndexOf(58)) > (firstColon = url.indexOf(58))) {
            colon = -1;
        }
        if (colon < 0) {
            output[NamingContext.HOST_INDEX] = url;
            output[NamingContext.PORT_INDEX] = new Integer(defaultPort);
        } else {
            output[NamingContext.HOST_INDEX] = url.substring(0, colon);
            try {
                output[NamingContext.PORT_INDEX] = Integer.parseInt(url.substring(colon + 1).trim());
            }
            catch (Exception ex) {
                output[NamingContext.PORT_INDEX] = new Integer(defaultPort);
            }
        }
        return colon;
    }

    private Name getAbsoluteName(Name n) throws NamingException {
        if (n.isEmpty()) {
            return this.composeName(n, this.prefix);
        }
        if (n.get(0).toString().equals("")) {
            return n.getSuffix(1);
        }
        return this.composeName(n, this.prefix);
    }

    private Hashtable getEnv(Name n) throws InvalidNameException {
        Hashtable nameEnv = this.env;
        this.env.remove(JNP_PARSED_NAME);
        String serverInfo = NamingContext.parseNameForScheme(n, nameEnv);
        if (serverInfo != null) {
            nameEnv = (Hashtable)this.env.clone();
            nameEnv.put("java.naming.provider.url", serverInfo);
        }
        return nameEnv;
    }

    private boolean handleStaleNamingStub(Exception e, Hashtable refEnv) {
        if (e instanceof NoSuchObjectException || e.getCause() instanceof NoSuchObjectException) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Call failed with NoSuchObjectException, flushing server cache and retrying", e);
                }
                this.naming = null;
                NamingContext.removeServer(refEnv);
                this.checkRef(refEnv);
                return true;
            }
            catch (Exception e1) {
                log.error("Caught exception flushing server cache and re-establish naming after exception " + e.getLocalizedMessage(), e1);
            }
        }
        return false;
    }

    static {
        GET_LOCAL_SERVER = new RuntimePermission("org.jboss.naming.NamingContext.getLocal");
        SET_LOCAL_SERVER = new RuntimePermission("org.jboss.naming.NamingContext.setLocal");
        HOST_INDEX = 0;
        PORT_INDEX = 1;
        cachedServers = new ConcurrentHashMap();
    }
}

